/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class FeedthroughBlock
extends ConnectorBlock<FeedthroughBlockEntity> {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 15.0f).noOcclusion().dynamicShape().forceSolidOn();

    public FeedthroughBlock(BlockBehaviour.Properties props) {
        super(props, IEBlockEntities.FEEDTHROUGH);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_ALL, BlockStateProperties.WATERLOGGED});
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof FeedthroughBlockEntity && !world.isClientSide && newState.getBlock() != state.getBlock()) {
            FeedthroughBlockEntity feedthrough = (FeedthroughBlockEntity)tile;
            if (!feedthrough.currentlyDisassembling) {
                Direction dir = feedthrough.getFacing();
                BlockPos centerPos = pos.relative(dir, -feedthrough.offset);
                for (int offset : new int[]{-1, 1, 0}) {
                    if (offset == feedthrough.offset) continue;
                    BlockPos posForOffset = centerPos.relative(dir, offset);
                    BlockEntity tileAtOffset = world.getBlockEntity(posForOffset);
                    if (tileAtOffset instanceof FeedthroughBlockEntity) {
                        ((FeedthroughBlockEntity)tileAtOffset).currentlyDisassembling = true;
                    }
                    if (offset == 0) {
                        world.setBlockAndUpdate(posForOffset, feedthrough.stateForMiddle);
                        continue;
                    }
                    BlockState connector = (BlockState)WireApi.INFOS.get(feedthrough.reference).connector().setValue((Property)IEProperties.FACING_ALL, (Comparable)(offset < 0 ? dir : dir.getOpposite()));
                    ConnectionPoint cpOnFeedthrough = new ConnectionPoint(centerPos, FeedthroughBlockEntity.getIndexForOffset(offset));
                    GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
                    ArrayList removedConnections = new ArrayList();
                    global.removeAllConnectionsAt(cpOnFeedthrough, removedConnections::add);
                    world.setBlockAndUpdate(posForOffset, connector);
                    ConnectionPoint newEnd = new ConnectionPoint(posForOffset, 0);
                    for (Connection c : removedConnections) {
                        ConnectionPoint otherEnd = c.getOtherEnd(cpOnFeedthrough);
                        global.addConnection(new Connection(c.type, newEnd, otherEnd, global));
                    }
                }
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    @Override
    public void fillCreativeTab(CreativeModeTab.Output out) {
    }
}

