/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BlastFurnaceFuel
extends IESerializableRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<BlastFurnaceFuel>> SERIALIZER;
    public static final CachedRecipeList<BlastFurnaceFuel> RECIPES;
    public final Ingredient input;
    public final int burnTime;

    public BlastFurnaceFuel(Ingredient input, int burnTime) {
        super(TagOutput.EMPTY, IERecipeTypes.BLAST_FUEL);
        this.input = input;
        this.burnTime = burnTime;
    }

    public static int getBlastFuelTime(Level level, ItemStack stack) {
        for (RecipeHolder<BlastFurnaceFuel> e : RECIPES.getRecipes(level)) {
            if (!((BlastFurnaceFuel)e.value()).input.test(stack)) continue;
            return ((BlastFurnaceFuel)e.value()).burnTime;
        }
        return 0;
    }

    public static boolean isValidBlastFuel(Level level, ItemStack stack) {
        return BlastFurnaceFuel.getBlastFuelTime(level, stack) > 0;
    }

    protected IERecipeSerializer<BlastFurnaceFuel> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return ItemStack.EMPTY;
    }

    static {
        RECIPES = new CachedRecipeList<BlastFurnaceFuel>(IERecipeTypes.BLAST_FUEL);
    }
}

