/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.data.recipes.builder.BaseHelpers;
import blusunrize.immersiveengineering.data.recipes.builder.IERecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class ClocheRecipeBuilder
extends IERecipeBuilder<ClocheRecipeBuilder>
implements BaseHelpers.ItemOutput<ClocheRecipeBuilder> {
    private final List<TagOutput> outputs = new ArrayList<TagOutput>();
    private Ingredient seed;
    private Ingredient soil;
    private int time;
    private ClocheRenderFunction renderReference;

    private ClocheRecipeBuilder() {
    }

    public static ClocheRecipeBuilder builder() {
        return new ClocheRecipeBuilder();
    }

    @Override
    public ClocheRecipeBuilder output(TagOutput output) {
        this.outputs.add(output);
        return this;
    }

    public ClocheRecipeBuilder seed(ItemLike seed) {
        this.seed = Ingredient.of((ItemLike[])new ItemLike[]{seed});
        return this;
    }

    public ClocheRecipeBuilder soil(Ingredient soil) {
        this.soil = soil;
        return this;
    }

    public ClocheRecipeBuilder soil(ItemLike soil) {
        return this.soil(Ingredient.of((ItemLike[])new ItemLike[]{soil}));
    }

    public ClocheRecipeBuilder soil(TagKey<Item> soil) {
        return this.soil(Ingredient.of(soil));
    }

    public ClocheRecipeBuilder setTime(int time) {
        this.time = time;
        return this;
    }

    public ClocheRecipeBuilder setRender(ClocheRenderFunction renderReference) {
        this.renderReference = renderReference;
        return this;
    }

    public void build(RecipeOutput out, ResourceLocation name) {
        ClocheRecipe recipe = new ClocheRecipe(new TagOutputList(this.outputs), this.seed, this.soil, this.time, this.renderReference);
        out.accept(name, (Recipe)recipe, null, this.getConditions());
    }
}

