/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BaseHelpers {

    public static interface ItemInput<T>
    extends UnsizedItemInput<T> {
        public T input(IngredientWithSize var1);

        @Override
        default public T input(Ingredient input) {
            return this.input(input, 1);
        }

        default public T input(Ingredient input, int count) {
            return this.input(new IngredientWithSize(input, count));
        }

        default public T input(TagKey<Item> ore, int count) {
            return this.input(Ingredient.of(ore), count);
        }

        default public T input(ItemLike input, int count) {
            return this.input(Ingredient.of((ItemLike[])new ItemLike[]{input}), count);
        }
    }

    public static interface UnsizedItemInput<T> {
        public T input(Ingredient var1);

        default public T input(TagKey<Item> ore) {
            return this.input(Ingredient.of(ore));
        }

        default public T input(ItemLike input) {
            return this.input(Ingredient.of((ItemLike[])new ItemLike[]{input}));
        }
    }

    public static interface ItemOutput<T> {
        public T output(TagOutput var1);

        default public T output(TagKey<Item> output, int count) {
            return this.output(new TagOutput(output, count));
        }

        default public T output(Item output, int count) {
            return this.output(new TagOutput(new IngredientWithSize(Ingredient.of((ItemLike[])new ItemLike[]{output}), count)));
        }

        default public T output(ItemStack itemStack) {
            return this.output(new TagOutput(itemStack));
        }

        default public T output(TagKey<Item> output) {
            return this.output(new TagOutput(output));
        }

        default public T output(ItemLike output, int count) {
            return this.output(new TagOutput(output, count));
        }

        default public T output(ItemLike output) {
            return this.output(new TagOutput(output));
        }

        default public T output(IngredientWithSize output) {
            return this.output(new TagOutput(output));
        }
    }
}

