/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.data.recipes.IERecipeProvider;
import blusunrize.immersiveengineering.data.recipes.builder.AlloyRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.ArcFurnaceRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.CrusherRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.HammerCrushingRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.MetalPressRecipeBuilder;
import blusunrize.immersiveengineering.data.resources.RecipeMetals;
import blusunrize.immersiveengineering.data.resources.RecipeOres;
import blusunrize.immersiveengineering.data.resources.SecondaryOutput;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public class OreRecipes
extends IERecipeProvider {
    public OreRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> provider) {
        super(p_248933_, provider);
    }

    protected void buildRecipes(RecipeOutput out) {
        SecondaryOutput[] secondaryOutputs;
        this.makeMaterialRecipes(out);
        for (RecipeMetals recipeMetals : RecipeMetals.values()) {
            if (recipeMetals.getOre() != null) {
                secondaryOutputs = recipeMetals.getSecondaryOutputs();
                HammerCrushingRecipeBuilder hammerBuilder = HammerCrushingRecipeBuilder.builder(recipeMetals.getOre(), recipeMetals.getDust());
                if (!recipeMetals.isNative()) {
                    ((HammerCrushingRecipeBuilder)hammerBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getDust()))).addCondition(OreRecipes.getTagCondition(recipeMetals.getOre()));
                }
                hammerBuilder.build(out, this.toRL("crafting/hammercrushing_" + recipeMetals.getName()));
                HammerCrushingRecipeBuilder rawHammerBuilder = HammerCrushingRecipeBuilder.builder(recipeMetals.getRawOre(), recipeMetals.getDust());
                if (!recipeMetals.isNative()) {
                    ((HammerCrushingRecipeBuilder)rawHammerBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getDust()))).addCondition(OreRecipes.getTagCondition(recipeMetals.getRawOre()));
                }
                rawHammerBuilder.build(out, this.toRL("crafting/raw_hammercrushing_" + recipeMetals.getName()));
                CrusherRecipeBuilder oreCrushing = ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(recipeMetals.getDust(), 2)).input(recipeMetals.getOre())).setEnergy(6000);
                if (!recipeMetals.isNative()) {
                    ((CrusherRecipeBuilder)oreCrushing.addCondition(OreRecipes.getTagCondition(recipeMetals.getDust()))).addCondition(OreRecipes.getTagCondition(recipeMetals.getOre()));
                }
                if (secondaryOutputs != null) {
                    for (SecondaryOutput secondaryOutput : secondaryOutputs) {
                        oreCrushing.addSecondary(secondaryOutput.getItem(), secondaryOutput.getChance(), secondaryOutput.getConditions());
                    }
                }
                oreCrushing.build(out, this.toRL("crusher/ore_" + recipeMetals.getName()));
                CrusherRecipeBuilder rawOreCrushing = ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().input(recipeMetals.getRawOre())).output(recipeMetals.getDust(), 1)).addSecondary(recipeMetals.getDust(), 0.33333334f, new ICondition[0]).setEnergy(6000);
                if (!recipeMetals.isNative()) {
                    ((CrusherRecipeBuilder)rawOreCrushing.addCondition(OreRecipes.getTagCondition(recipeMetals.getDust()))).addCondition(OreRecipes.getTagCondition(recipeMetals.getRawOre()));
                }
                rawOreCrushing.build(out, this.toRL("crusher/raw_ore_" + recipeMetals.getName()));
                TagKey rawBlock = TagUtils.createItemWrapper((ResourceLocation)IETags.getRawBlock((String)recipeMetals.getName()));
                rawOreCrushing = ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().input((TagKey<Item>)rawBlock)).output(recipeMetals.getDust(), 12)).setEnergy(54000);
                if (!recipeMetals.isNative()) {
                    ((CrusherRecipeBuilder)rawOreCrushing.addCondition(OreRecipes.getTagCondition(recipeMetals.getDust()))).addCondition(OreRecipes.getTagCondition(rawBlock));
                }
                rawOreCrushing.build(out, this.toRL("crusher/raw_block_" + recipeMetals.getName()));
                ArcFurnaceRecipeBuilder arcBuilder = ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)ArcFurnaceRecipeBuilder.builder().input(recipeMetals.getOre())).output(recipeMetals.getIngot(), 2)).slag((TagKey<Item>)IETags.slag, 1).setTime(200).setEnergy(102400);
                if (!recipeMetals.isNative()) {
                    ((ArcFurnaceRecipeBuilder)arcBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()))).addCondition(OreRecipes.getTagCondition(recipeMetals.getOre()));
                }
                arcBuilder.build(out, this.toRL("arcfurnace/ore_" + recipeMetals.getName()));
                arcBuilder = ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)ArcFurnaceRecipeBuilder.builder().input(recipeMetals.getRawOre())).output(recipeMetals.getIngot(), 1)).secondary(recipeMetals.getIngot(), 0.5f, new ICondition[0]).setTime(100).setEnergy(25600);
                if (!recipeMetals.isNative()) {
                    ((ArcFurnaceRecipeBuilder)arcBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()))).addCondition(OreRecipes.getTagCondition(recipeMetals.getRawOre()));
                }
                arcBuilder.build(out, this.toRL("arcfurnace/raw_ore_" + recipeMetals.getName()));
                arcBuilder = ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)ArcFurnaceRecipeBuilder.builder().input(recipeMetals.getRawBlock())).output(recipeMetals.getIngot(), 13)).secondary(recipeMetals.getIngot(), 0.5f, new ICondition[0]).setTime(900).setEnergy(230400);
                if (!recipeMetals.isNative()) {
                    ((ArcFurnaceRecipeBuilder)arcBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()))).addCondition(OreRecipes.getTagCondition(recipeMetals.getRawBlock()));
                }
                arcBuilder.build(out, this.toRL("arcfurnace/raw_block_" + recipeMetals.getName()));
            }
            CrusherRecipeBuilder ingotCrushing = ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().input(recipeMetals.getIngot())).output(recipeMetals.getDust(), 1)).setEnergy(3000);
            if (!recipeMetals.isNative()) {
                ((CrusherRecipeBuilder)ingotCrushing.addCondition(OreRecipes.getTagCondition(recipeMetals.getDust()))).addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()));
            }
            ingotCrushing.build(out, this.toRL("crusher/ingot_" + recipeMetals.getName()));
            ArcFurnaceRecipeBuilder arcBuilder = ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)ArcFurnaceRecipeBuilder.builder().input(recipeMetals.getDust())).output(recipeMetals.getIngot(), 1)).setTime(100).setEnergy(51200);
            if (!recipeMetals.isNative()) {
                ((ArcFurnaceRecipeBuilder)arcBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()))).addCondition(OreRecipes.getTagCondition(recipeMetals.getDust()));
            }
            arcBuilder.build(out, this.toRL("arcfurnace/dust_" + recipeMetals.getName()));
            TagKey plate = TagUtils.createItemWrapper((ResourceLocation)IETags.getPlate((String)recipeMetals.getName()));
            MetalPressRecipeBuilder pressBuilder = ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder().input(recipeMetals.getIngot())).mold((ItemLike)IEItems.Molds.MOLD_PLATE).output((TagKey<Item>)plate, 1)).setEnergy(2400);
            if (!recipeMetals.isNative()) {
                ((MetalPressRecipeBuilder)pressBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()))).addCondition(OreRecipes.getTagCondition(plate));
            }
            pressBuilder.build(out, this.toRL("metalpress/plate_" + recipeMetals.getName()));
            TagKey gear = TagUtils.createItemWrapper((ResourceLocation)IETags.getGear((String)recipeMetals.getName()));
            pressBuilder = ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder().input(recipeMetals.getIngot(), 4)).mold((ItemLike)IEItems.Molds.MOLD_GEAR).output((TagKey<Item>)gear, 1)).setEnergy(2400);
            if (!recipeMetals.isNative()) {
                pressBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()));
            }
            ((MetalPressRecipeBuilder)pressBuilder.addCondition(OreRecipes.getTagCondition(gear))).build(out, this.toRL("metalpress/gear_" + recipeMetals.getName()));
            TagKey rods = TagUtils.createItemWrapper((ResourceLocation)IETags.getRod((String)recipeMetals.getName()));
            pressBuilder = ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder().input(recipeMetals.getIngot())).mold((ItemLike)IEItems.Molds.MOLD_ROD).output((TagKey<Item>)rods, 2)).setEnergy(2400);
            if (!recipeMetals.isNative()) {
                pressBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()));
            }
            ((MetalPressRecipeBuilder)pressBuilder.addCondition(OreRecipes.getTagCondition(rods))).build(out, this.toRL("metalpress/rod_" + recipeMetals.getName()));
            TagKey wire = TagUtils.createItemWrapper((ResourceLocation)IETags.getWire((String)recipeMetals.getName()));
            pressBuilder = ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder().input(recipeMetals.getIngot())).mold((ItemLike)IEItems.Molds.MOLD_WIRE).output((TagKey<Item>)wire, 2)).setEnergy(2400);
            if (!recipeMetals.isNative()) {
                pressBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()));
            }
            ((MetalPressRecipeBuilder)pressBuilder.addCondition(OreRecipes.getTagCondition(wire))).build(out, this.toRL("metalpress/wire_" + recipeMetals.getName()));
            RecipeMetals.AlloyProperties alloy = recipeMetals.getAlloyProperties();
            if (alloy == null) continue;
            IngredientWithSize[] ingredients = alloy.getAlloyIngredients();
            if (alloy.isSimple()) {
                AlloyRecipeBuilder alloyBuilder = (AlloyRecipeBuilder)AlloyRecipeBuilder.builder().output(recipeMetals.getIngot(), alloy.getOutputSize());
                if (!recipeMetals.isNative()) {
                    alloyBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()));
                }
                for (ICondition condition : alloy.getConditions()) {
                    alloyBuilder.addCondition(condition);
                }
                for (IngredientWithSize ingr : ingredients) {
                    alloyBuilder.input(ingr);
                }
                alloyBuilder.build(out, this.toRL("alloysmelter/" + recipeMetals.getName()));
            }
            arcBuilder = ((ArcFurnaceRecipeBuilder)ArcFurnaceRecipeBuilder.builder().output(recipeMetals.getIngot(), alloy.getOutputSize())).setTime(100).setEnergy(51200).input(ingredients[0]);
            if (!recipeMetals.isNative()) {
                arcBuilder.addCondition(OreRecipes.getTagCondition(recipeMetals.getIngot()));
            }
            for (ICondition condition : alloy.getConditions()) {
                arcBuilder.addCondition(condition);
            }
            for (int i = 1; i < ingredients.length; ++i) {
                arcBuilder.additive(ingredients[i]);
            }
            arcBuilder.build(out, this.toRL("arcfurnace/alloy_" + recipeMetals.getName()));
        }
        for (Enum enum_ : RecipeOres.values()) {
            secondaryOutputs = ((RecipeOres)enum_).getSecondaryOutputs();
            CrusherRecipeBuilder oreCrushing = ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().input(((RecipeOres)enum_).getOre())).output(((RecipeOres)enum_).getOutput())).setEnergy(6000);
            if (!((RecipeOres)enum_).isNative()) {
                oreCrushing.addCondition(OreRecipes.getTagCondition(((RecipeOres)enum_).getOre()));
            }
            if (secondaryOutputs != null) {
                for (SecondaryOutput secondaryOutput : secondaryOutputs) {
                    oreCrushing.addSecondary(secondaryOutput.getItem(), secondaryOutput.getChance(), secondaryOutput.getConditions());
                }
            }
            oreCrushing.build(out, this.toRL("crusher/ore_" + ((RecipeOres)enum_).getName()));
        }
    }

    private void makeMaterialRecipes(RecipeOutput out) {
        for (EnumMetals metal : EnumMetals.values()) {
            IETags.MetalTags tags = IETags.getTagsFor((EnumMetals)metal);
            ItemLike rawOre = (ItemLike)IEItems.Metals.RAW_ORES.get(metal);
            ItemLike nugget = (ItemLike)IEItems.Metals.NUGGETS.get(metal);
            ItemLike ingot = (ItemLike)IEItems.Metals.INGOTS.get(metal);
            ItemLike plate = (ItemLike)IEItems.Metals.PLATES.get(metal);
            ItemLike dust = (ItemLike)IEItems.Metals.DUSTS.get(metal);
            IEBlocks.BlockEntry block = (IEBlocks.BlockEntry)IEBlocks.Metals.STORAGE.get(metal);
            IEBlocks.BlockEntry sheetMetal = (IEBlocks.BlockEntry)IEBlocks.Metals.SHEETMETAL.get(metal);
            if (metal.shouldAddNugget()) {
                this.add3x3Conversion(ingot, nugget, (TagKey<Item>)tags.nugget, out);
            }
            if (!metal.isVanillaMetal()) {
                this.add3x3Conversion((ItemLike)block, ingot, (TagKey<Item>)tags.ingot, out);
            }
            if (metal.shouldAddOre()) {
                IEBlocks.BlockEntry ore = (IEBlocks.BlockEntry)IEBlocks.Metals.ORES.get(metal);
                this.addStandardSmeltingBlastingRecipe((ItemLike)ore, ingot, metal.smeltingXP, out);
                ore = (IEBlocks.BlockEntry)IEBlocks.Metals.DEEPSLATE_ORES.get(metal);
                this.addStandardSmeltingBlastingRecipe((ItemLike)ore, ingot, metal.smeltingXP, out);
                this.addStandardSmeltingBlastingRecipe((ItemLike)IEItems.Metals.RAW_ORES.get(metal), ingot, metal.smeltingXP, out);
                IEBlocks.BlockEntry rawBlock = (IEBlocks.BlockEntry)IEBlocks.Metals.RAW_ORES.get(metal);
                this.add3x3Conversion((ItemLike)rawBlock, rawOre, (TagKey<Item>)tags.rawOre, out);
            }
            this.addStandardSmeltingBlastingRecipe(dust, ingot, 0.0f, out, "_from_dust");
            this.shapelessMisc(plate).requires(IETags.getTagsFor((EnumMetals)metal).ingot).requires((ItemLike)IEItems.Tools.HAMMER).unlockedBy("has_" + metal.tagName() + "_ingot", OreRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)metal).ingot)).save(out, this.toRL("plate_" + metal.tagName() + "_hammering"));
            this.shapedMisc((ItemLike)sheetMetal, 4).pattern(" p ").pattern("p p").pattern(" p ").define(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)metal).plate).unlockedBy("has_" + this.toPath(plate), OreRecipes.has((ItemLike)plate)).save(out, this.toRL(this.toPath((ItemLike)sheetMetal)));
        }
    }
}

