/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.DropConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ExtractConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.RedstoneConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.SplitConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.VerticalConveyor;
import blusunrize.immersiveengineering.common.crafting.fluidaware.IngredientFluidStack;
import blusunrize.immersiveengineering.common.crafting.fluidaware.TurnAndCopyRecipe;
import blusunrize.immersiveengineering.common.items.upgrades.ToolUpgrade;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.data.recipes.IERecipeProvider;
import blusunrize.immersiveengineering.data.recipes.WrappingRecipeOutput;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public class DeviceRecipes
extends IERecipeProvider {
    public DeviceRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> provider) {
        super(p_248933_, provider);
    }

    protected void buildRecipes(RecipeOutput out) {
        this.woodenDevices(out);
        this.metalDevices(out);
        this.connectors(out);
        this.conveyors(out);
        this.cloth(out);
    }

    private void woodenDevices(RecipeOutput out) {
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.CRAFTING_TABLE).pattern("sss").pattern("rcr").pattern("r r").define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.treatedWoodSlab)).define(Character.valueOf('r'), IETags.treatedStick).define(Character.valueOf('c'), (ItemLike)Blocks.CRAFTING_TABLE).unlockedBy("has_treated_planks", DeviceRecipes.has((TagKey)IETags.getItemTag((TagKey)IETags.treatedWood))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.CRAFTING_TABLE)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.CRATE).pattern("ppp").pattern("p p").pattern("ppp").define(Character.valueOf('p'), IETags.getItemTag((TagKey)IETags.treatedWood)).unlockedBy("has_treated_planks", DeviceRecipes.has((TagKey)IETags.getItemTag((TagKey)IETags.treatedWood))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.CRATE)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.REINFORCED_CRATE).pattern("wpw").pattern("rcr").pattern("wpw").define(Character.valueOf('w'), IETags.getItemTag((TagKey)IETags.treatedWood)).define(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).define(Character.valueOf('r'), IETags.steelRod).define(Character.valueOf('c'), (ItemLike)IEBlocks.WoodenDevices.CRATE).unlockedBy("has_treated_planks", DeviceRecipes.has((TagKey)IETags.getItemTag((TagKey)IETags.treatedWood))).save(new WrappingRecipeOutput<ShapedRecipe>(out, r -> new TurnAndCopyRecipe(r, List.of(Integer.valueOf(4))).allowQuarterTurn()), this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.REINFORCED_CRATE)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.TREATED_WALLMOUNT, 4).pattern("ww").pattern("ws").define(Character.valueOf('w'), IETags.getItemTag((TagKey)IETags.treatedWood)).define(Character.valueOf('s'), IETags.treatedStick).unlockedBy("has_treated_planks", DeviceRecipes.has((TagKey)IETags.getItemTag((TagKey)IETags.treatedWood))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.TREATED_WALLMOUNT)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.SORTER).pattern("c").pattern("w").pattern("b").define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('b'), (ItemLike)ConveyorHandler.getBlock((IConveyorType)BasicConveyor.TYPE)).unlockedBy("has_" + this.toPath((ItemLike)ConveyorHandler.getBlock((IConveyorType)BasicConveyor.TYPE)), DeviceRecipes.has((ItemLike)ConveyorHandler.getBlock((IConveyorType)BasicConveyor.TYPE))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.SORTER)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.ITEM_BATCHER).pattern("c").pattern("w").pattern("e").define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC).unlockedBy("has_" + this.toPath((ItemLike)ConveyorHandler.getBlock((IConveyorType)BasicConveyor.TYPE)), DeviceRecipes.has((ItemLike)ConveyorHandler.getBlock((IConveyorType)BasicConveyor.TYPE))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.ITEM_BATCHER)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.FLUID_SORTER).pattern("c").pattern("w").pattern("b").define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('b'), (ItemLike)IEBlocks.MetalDevices.FLUID_PIPE).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDevices.FLUID_PIPE), DeviceRecipes.has((ItemLike)IEBlocks.MetalDevices.FLUID_PIPE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.FLUID_SORTER)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.LOGIC_UNIT).pattern(" t ").pattern("twt").pattern(" t ").define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('t'), (ItemLike)IEItems.Ingredients.ELECTRON_TUBE).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.ELECTRON_TUBE), DeviceRecipes.has((ItemLike)IEItems.Ingredients.ELECTRON_TUBE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.LOGIC_UNIT)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.MACHINE_INTERFACE).pattern(" r ").pattern("awa").pattern(" e ").define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('a'), IETags.aluminumWire).define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC_ADV).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.CIRCUIT_BOARD), DeviceRecipes.has((ItemLike)IEItems.Ingredients.CIRCUIT_BOARD)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.MACHINE_INTERFACE)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.TURNTABLE).pattern(" c ").pattern("sws").pattern(" r ").define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('s'), (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER)).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.COMPONENT_IRON), DeviceRecipes.has((ItemLike)IEItems.Ingredients.COMPONENT_IRON)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.TURNTABLE)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.WINDMILL).pattern("ppp").pattern("pip").pattern("ppp").define(Character.valueOf('p'), (ItemLike)IEItems.Ingredients.WINDMILL_BLADE).define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.WINDMILL_BLADE), DeviceRecipes.has((ItemLike)IEItems.Ingredients.WINDMILL_BLADE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.WINDMILL)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.WATERMILL).pattern(" p ").pattern("pip").pattern(" p ").define(Character.valueOf('p'), (ItemLike)IEItems.Ingredients.WATERWHEEL_SEGMENT).define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.WATERWHEEL_SEGMENT), DeviceRecipes.has((ItemLike)IEItems.Ingredients.WATERWHEEL_SEGMENT)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.WATERMILL)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.GUNPOWDER_BARREL).pattern("gfg").pattern("gbg").define(Character.valueOf('f'), (ItemLike)IEItems.Ingredients.HEMP_FIBER).define(Character.valueOf('g'), Tags.Items.GUNPOWDERS).define(Character.valueOf('b'), (ItemLike)IEBlocks.WoodenDevices.WOODEN_BARREL).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.WoodenDevices.WOODEN_BARREL), DeviceRecipes.has((ItemLike)IEBlocks.WoodenDevices.WOODEN_BARREL)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.GUNPOWDER_BARREL)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.WORKBENCH).pattern("iss").pattern("c f").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.treatedWoodSlab)).define(Character.valueOf('c'), (ItemLike)IEBlocks.WoodenDevices.CRAFTING_TABLE).define(Character.valueOf('f'), (ItemLike)IEBlocks.WoodenDecoration.TREATED_FENCE).unlockedBy("has_treated_planks", DeviceRecipes.has((TagKey)IETags.getItemTag((TagKey)IETags.treatedWood))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.WORKBENCH)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.BLUEPRINT_SHELF).pattern("srs").pattern("rsr").pattern("www").define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.treatedWoodSlab)).define(Character.valueOf('r'), IETags.treatedStick).define(Character.valueOf('w'), IETags.getItemTag((TagKey)IETags.treatedWood)).unlockedBy("has_treated_planks", DeviceRecipes.has((TagKey)IETags.getItemTag((TagKey)IETags.treatedWood))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.BLUEPRINT_SHELF)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.CIRCUIT_TABLE).pattern("sst").pattern("c e").define(Character.valueOf('t'), (ItemLike)IEItems.Tools.SCREWDRIVER).define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.treatedWoodSlab)).define(Character.valueOf('c'), (ItemLike)IEBlocks.WoodenDevices.CRAFTING_TABLE).define(Character.valueOf('e'), (ItemLike)IEBlocks.MetalDecoration.ENGINEERING_LIGHT).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.CIRCUIT_BOARD), DeviceRecipes.has((ItemLike)IEItems.Ingredients.CIRCUIT_BOARD)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.CIRCUIT_TABLE)));
        this.shapedMisc((ItemLike)IEBlocks.WoodenDevices.WOODEN_BARREL).pattern("sss").pattern("w w").pattern("www").define(Character.valueOf('w'), IETags.getItemTag((TagKey)IETags.treatedWood)).define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.treatedWoodSlab)).unlockedBy("has_treated_planks", DeviceRecipes.has((TagKey)IETags.getItemTag((TagKey)IETags.treatedWood))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.WoodenDevices.WOODEN_BARREL)));
    }

    private void connectors(@Nonnull RecipeOutput out) {
        this.shapedMisc((ItemLike)IEBlocks.Connectors.BREAKER_SWITCH).pattern(" l ").pattern("cic").define(Character.valueOf('l'), (ItemLike)Items.LEVER).define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).define(Character.valueOf('c'), IETags.connectorInsulator).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER)), DeviceRecipes.has((ItemLike)((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER)))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.BREAKER_SWITCH)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.REDSTONE_BREAKER).pattern("hrh").pattern("ici").define(Character.valueOf('h'), (ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)false)).define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).define(Character.valueOf('r'), (ItemLike)Items.REPEATER).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC).unlockedBy("has_hv_connector", DeviceRecipes.has((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)false))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.REDSTONE_BREAKER)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.CURRENT_TRANSFORMER).pattern(" m ").pattern(" b ").pattern("iei").define(Character.valueOf('m'), (ItemLike)IEItems.Tools.VOLTMETER).define(Character.valueOf('b'), IETags.connectorInsulator).define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC).unlockedBy("has_voltmeter", DeviceRecipes.has((ItemLike)IEItems.Tools.VOLTMETER)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.CURRENT_TRANSFORMER)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.TRANSFORMER).pattern("lm").pattern("eb").pattern("ii").define(Character.valueOf('l'), (ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)false)).define(Character.valueOf('m'), (ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"MV", (boolean)false)).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC).define(Character.valueOf('b'), (ItemLike)IEBlocks.MetalDecoration.MV_COIL).define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).unlockedBy("has_mv_connector", DeviceRecipes.has((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"MV", (boolean)false))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.TRANSFORMER)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.TRANSFORMER_HV).pattern("mh").pattern("eb").pattern("ii").define(Character.valueOf('m'), (ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"MV", (boolean)false)).define(Character.valueOf('h'), (ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)false)).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC).define(Character.valueOf('b'), (ItemLike)IEBlocks.MetalDecoration.HV_COIL).define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).unlockedBy("has_hv_connector", DeviceRecipes.has((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)false))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.TRANSFORMER_HV)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.CONNECTOR_STRUCTURAL, 8).pattern("isi").pattern("i i").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).define(Character.valueOf('s'), IETags.steelRod).unlockedBy("has_steel_ingot", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.CONNECTOR_STRUCTURAL)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE, 4).pattern("iii").pattern("brb").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).nugget).define(Character.valueOf('b'), IETags.connectorInsulator).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_electrum_nugget", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).nugget)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.CONNECTOR_PROBE).pattern(" c ").pattern("gpg").define(Character.valueOf('c'), (ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE).define(Character.valueOf('g'), Tags.Items.GLASS_PANES).define(Character.valueOf('p'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC).unlockedBy("has_connector", DeviceRecipes.has((ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.CONNECTOR_PROBE)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.CONNECTOR_BUNDLED).pattern(" w ").pattern("wcw").pattern(" w ").define(Character.valueOf('c'), (ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE).define(Character.valueOf('w'), IETags.aluminumWire).unlockedBy("has_connector", DeviceRecipes.has((ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.CONNECTOR_BUNDLED)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.REDSTONE_STATE_CELL).pattern("c").pattern("t").define(Character.valueOf('c'), (ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE).define(Character.valueOf('t'), (ItemLike)IEItems.Ingredients.ELECTRON_TUBE).unlockedBy("has_connector", DeviceRecipes.has((ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.REDSTONE_STATE_CELL)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.REDSTONE_TIMER).pattern(" t ").pattern("te ").pattern("  c").define(Character.valueOf('c'), (ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC).define(Character.valueOf('t'), (ItemLike)IEItems.Ingredients.ELECTRON_TUBE).unlockedBy("has_connector", DeviceRecipes.has((ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.REDSTONE_TIMER)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.REDSTONE_SWITCHBOARD).pattern("c c").pattern("sws").pattern("ses").define(Character.valueOf('c'), (ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE).define(Character.valueOf('s'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).define(Character.valueOf('w'), (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.REDSTONE)).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC).unlockedBy("has_connector", DeviceRecipes.has((ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.REDSTONE_SWITCHBOARD)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.SIREN).pattern(" c ").pattern("pmp").pattern(" p ").define(Character.valueOf('c'), (ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE).define(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).define(Character.valueOf('m'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).unlockedBy("has_connector", DeviceRecipes.has((ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Connectors.SIREN)));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)false), 4).pattern(" i ").pattern("cic").pattern("cic").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).define(Character.valueOf('c'), IETags.connectorInsulator).unlockedBy("has_copper_ingot", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).save(out, this.toRL("connector_lv"));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)true), 8).pattern(" i ").pattern("cic").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).define(Character.valueOf('c'), IETags.connectorInsulator).unlockedBy("has_copper_ingot", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).save(out, this.toRL("connector_lv_relay"));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"MV", (boolean)false), 4).pattern(" i ").pattern("cic").pattern("cic").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot).define(Character.valueOf('c'), IETags.connectorInsulator).unlockedBy("has_electrum_ingot", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).save(out, this.toRL("connector_mv"));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"MV", (boolean)true), 8).pattern(" i ").pattern("cic").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot).define(Character.valueOf('c'), IETags.connectorInsulator).unlockedBy("has_electrum_ingot", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).save(out, this.toRL("connector_mv_relay"));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)false), 4).pattern(" i ").pattern("cic").pattern("cic").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).define(Character.valueOf('c'), IETags.connectorInsulator).unlockedBy("has_aluminum_ingot", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).save(out, this.toRL("connector_hv"));
        this.shapedMisc((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)true), 8).pattern(" i ").pattern("cic").pattern("cic").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).define(Character.valueOf('c'), Ingredient.of((ItemLike[])new ItemLike[]{IEBlocks.StoneDecoration.INSULATING_GLASS, IEBlocks.StoneDecoration.SLAG_GLASS})).unlockedBy("has_aluminum_ingot", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).save(out, this.toRL("connector_hv_relay"));
    }

    private void cloth(@Nonnull RecipeOutput out) {
        this.shapedMisc((ItemLike)IEBlocks.Cloth.BALLOON, 2).pattern(" f ").pattern("ftf").pattern(" s ").define(Character.valueOf('f'), (ItemLike)IEItems.Ingredients.HEMP_FABRIC).define(Character.valueOf('t'), (ItemLike)Items.TORCH).define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.treatedWoodSlab)).unlockedBy("has_hemp_fabric", DeviceRecipes.has((TagKey)IETags.fabricHemp)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Cloth.BALLOON)));
        this.shapedMisc((ItemLike)IEBlocks.Cloth.CUSHION, 3).pattern("fff").pattern("f f").pattern("fff").define(Character.valueOf('f'), (ItemLike)IEItems.Ingredients.HEMP_FABRIC).unlockedBy("has_hemp_fabric", DeviceRecipes.has((TagKey)IETags.fabricHemp)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Cloth.CUSHION)));
        this.shapedMisc((ItemLike)IEBlocks.Cloth.STRIP_CURTAIN, 3).pattern("sss").pattern("fff").pattern("fff").define(Character.valueOf('s'), IETags.metalRods).define(Character.valueOf('f'), (ItemLike)IEItems.Ingredients.HEMP_FABRIC).unlockedBy("has_hemp_fabric", DeviceRecipes.has((TagKey)IETags.fabricHemp)).unlockedBy("has_metal_rod", DeviceRecipes.has((TagKey)IETags.metalRods)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.Cloth.STRIP_CURTAIN)));
    }

    private void conveyors(@Nonnull RecipeOutput out) {
        Block basic = ConveyorHandler.getBlock((IConveyorType)BasicConveyor.TYPE);
        Block redstone = ConveyorHandler.getBlock((IConveyorType)RedstoneConveyor.TYPE);
        Block dropper = ConveyorHandler.getBlock((IConveyorType)DropConveyor.TYPE);
        Block extract = ConveyorHandler.getBlock((IConveyorType)ExtractConveyor.TYPE);
        Block splitter = ConveyorHandler.getBlock((IConveyorType)SplitConveyor.TYPE);
        Block vertical = ConveyorHandler.getBlock((IConveyorType)VerticalConveyor.TYPE);
        this.addCoveyorCoveringRecipe((ItemLike)basic, out);
        this.addCoveyorCoveringRecipe((ItemLike)dropper, out);
        this.addCoveyorCoveringRecipe((ItemLike)extract, out);
        this.addCoveyorCoveringRecipe((ItemLike)splitter, out);
        this.addCoveyorCoveringRecipe((ItemLike)vertical, out);
        this.shapedMisc((ItemLike)basic, 8).pattern("lll").pattern("iri").define(Character.valueOf('l'), Tags.Items.LEATHERS).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_leather", DeviceRecipes.has((ItemLike)Items.LEATHER)).save(out, this.toRL(this.toPath((ItemLike)basic)));
        this.shapedMisc((ItemLike)redstone).pattern("c").pattern("r").define(Character.valueOf('c'), (ItemLike)basic).define(Character.valueOf('r'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has_conveyor", DeviceRecipes.has((ItemLike)basic)).save(out, this.toRL(this.toPath((ItemLike)redstone)));
        this.shapedMisc((ItemLike)dropper).pattern("c").pattern("t").define(Character.valueOf('c'), (ItemLike)basic).define(Character.valueOf('t'), this.makeIngredient(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate, IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate)).unlockedBy("has_conveyor", DeviceRecipes.has((ItemLike)basic)).save(out, this.toRL(this.toPath((ItemLike)dropper)));
        this.shapedMisc((ItemLike)extract).pattern(" s").pattern("wc").define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('s'), (ItemLike)IEBlocks.Cloth.STRIP_CURTAIN).define(Character.valueOf('c'), (ItemLike)basic).unlockedBy("has_conveyor", DeviceRecipes.has((ItemLike)basic)).save(out, this.toRL(this.toPath((ItemLike)extract)));
        this.shapedMisc((ItemLike)splitter, 3).pattern("cic").pattern(" c ").define(Character.valueOf('c'), (ItemLike)basic).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).unlockedBy("has_conveyor", DeviceRecipes.has((ItemLike)basic)).save(out, this.toRL(this.toPath((ItemLike)splitter)));
        this.shapedMisc((ItemLike)vertical, 3).pattern("ci").pattern("c ").pattern("ci").define(Character.valueOf('c'), (ItemLike)basic).define(Character.valueOf('i'), this.makeIngredient(IETags.ironRod, IETags.steelRod)).unlockedBy("has_conveyor", DeviceRecipes.has((ItemLike)basic)).save(out, this.toRL(this.toPath((ItemLike)vertical)));
    }

    private void metalDevices(RecipeOutput out) {
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.RAZOR_WIRE, 3).pattern("sps").pattern("fsf").define(Character.valueOf('s'), (ItemLike)IEItems.Ingredients.WIRE_STEEL).define(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).define(Character.valueOf('f'), (ItemLike)IEBlocks.WoodenDecoration.TREATED_FENCE).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.WIRE_STEEL), DeviceRecipes.has((ItemLike)IEItems.Ingredients.WIRE_STEEL)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.RAZOR_WIRE)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.CAPACITOR_LV).pattern("ere").pattern("awa").define(Character.valueOf('e'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).define(Character.valueOf('r'), new Ingredient((ICustomIngredient)new IngredientFluidStack(IETags.fluidRedstoneAcid, 1000))).define(Character.valueOf('a'), IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).plate).define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).unlockedBy("has_lead_ingot", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).ingot)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.CAPACITOR_LV)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.CAPACITOR_MV).pattern("ere").pattern("awc").define(Character.valueOf('e'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot).define(Character.valueOf('r'), new Ingredient((ICustomIngredient)new IngredientFluidStack(IETags.fluidRedstoneAcid, 1000))).define(Character.valueOf('a'), IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).plate).define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).unlockedBy("has_nickel_ingot", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).ingot)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.CAPACITOR_MV)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.CAPACITOR_HV).pattern("ere").pattern("awc").define(Character.valueOf('e'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).define(Character.valueOf('r'), new Ingredient((ICustomIngredient)new IngredientFluidStack(IETags.fluidRedstoneAcid, 1000))).define(Character.valueOf('a'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).plate).define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('c'), IETags.hopGraphitePlate).unlockedBy("has_graphite_dust", DeviceRecipes.has((TagKey)IETags.hopGraphiteDust)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.CAPACITOR_HV)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.BARREL).pattern("sss").pattern("w w").pattern("www").define(Character.valueOf('w'), IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).sheetmetal)).define(Character.valueOf('s'), (ItemLike)IEBlocks.TO_SLAB.get(((IEBlocks.BlockEntry)IEBlocks.Metals.SHEETMETAL.get(EnumMetals.IRON)).getId())).unlockedBy("has_iron_sheet_slab", DeviceRecipes.has((ItemLike)((ItemLike)IEBlocks.Metals.SHEETMETAL.get(EnumMetals.IRON)))).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.BARREL)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.FLUID_PUMP).pattern(" i ").pattern("ici").pattern("ppp").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).define(Character.valueOf('p'), (ItemLike)IEBlocks.MetalDevices.FLUID_PIPE).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDevices.FLUID_PIPE), DeviceRecipes.has((ItemLike)IEBlocks.MetalDevices.FLUID_PIPE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.FLUID_PUMP)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.BLAST_FURNACE_PREHEATER).pattern("ss").pattern("ss").pattern("ph").define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).sheetmetal)).define(Character.valueOf('p'), (ItemLike)IEBlocks.MetalDevices.FLUID_PIPE).define(Character.valueOf('h'), (ItemLike)IEBlocks.MetalDevices.FURNACE_HEATER).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDevices.FURNACE_HEATER), DeviceRecipes.has((ItemLike)IEBlocks.MetalDevices.FURNACE_HEATER)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.BLAST_FURNACE_PREHEATER)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.FURNACE_HEATER).pattern("pwp").pattern("wsw").pattern("prp").define(Character.valueOf('w'), (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER)).define(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).plate).define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).sheetmetal)).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDecoration.LV_COIL), DeviceRecipes.has((ItemLike)IEBlocks.MetalDecoration.LV_COIL)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.FURNACE_HEATER)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.DYNAMO).pattern("rcr").pattern("ili").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).define(Character.valueOf('l'), (ItemLike)IEBlocks.MetalDecoration.LV_COIL).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDecoration.LV_COIL), DeviceRecipes.has((ItemLike)IEBlocks.MetalDecoration.LV_COIL)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.DYNAMO)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.THERMOELECTRIC_GEN).pattern("iii").pattern("ele").pattern("eee").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).define(Character.valueOf('l'), (ItemLike)IEBlocks.MetalDecoration.LV_COIL).define(Character.valueOf('e'), IETags.getTagsFor((EnumMetals)EnumMetals.CONSTANTAN).plate).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDecoration.LV_COIL), DeviceRecipes.has((ItemLike)IEBlocks.MetalDecoration.LV_COIL)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.THERMOELECTRIC_GEN)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.ELECTRIC_LANTERN).pattern(" i ").pattern("pep").pattern(" w ").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.LIGHT_BULB).define(Character.valueOf('p'), Tags.Items.GLASS_PANES).define(Character.valueOf('w'), IETags.copperWire).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.LIGHT_BULB), DeviceRecipes.has((ItemLike)IEItems.Ingredients.LIGHT_BULB)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.ELECTRIC_LANTERN)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.CHARGING_STATION).pattern("gig").pattern("ttt").pattern("wlw").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).define(Character.valueOf('t'), (ItemLike)IEItems.Ingredients.ELECTRON_TUBE).define(Character.valueOf('w'), IETags.getItemTag((TagKey)IETags.treatedWood)).define(Character.valueOf('l'), (ItemLike)IEBlocks.MetalDecoration.LV_COIL).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDecoration.LV_COIL), DeviceRecipes.has((ItemLike)IEBlocks.MetalDecoration.LV_COIL)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.CHARGING_STATION)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.FLUID_PIPE, 8).pattern("ppp").pattern("   ").pattern("ppp").define(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).unlockedBy("has_iron_plate", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.FLUID_PIPE)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.SAMPLE_DRILL).pattern("sfs").pattern("sfs").pattern("efe").define(Character.valueOf('s'), (ItemLike)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(MetalScaffoldingType.STANDARD)).define(Character.valueOf('f'), (ItemLike)IEBlocks.MetalDecoration.STEEL_FENCE).define(Character.valueOf('e'), (ItemLike)IEBlocks.MetalDecoration.ENGINEERING_LIGHT).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(MetalScaffoldingType.STANDARD)), DeviceRecipes.has((ItemLike)((ItemLike)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(MetalScaffoldingType.STANDARD)))).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDecoration.STEEL_FENCE), DeviceRecipes.has((ItemLike)IEBlocks.MetalDecoration.STEEL_FENCE)).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDecoration.ENGINEERING_LIGHT), DeviceRecipes.has((ItemLike)IEBlocks.MetalDecoration.ENGINEERING_LIGHT)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.SAMPLE_DRILL)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.TESLA_COIL).pattern("iii").pattern(" l ").pattern("ehc").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).plate).define(Character.valueOf('l'), (ItemLike)IEBlocks.MetalDecoration.MV_COIL).define(Character.valueOf('h'), (ItemLike)IEBlocks.MetalDevices.CAPACITOR_HV).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC_ADV).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDevices.CAPACITOR_HV), DeviceRecipes.has((ItemLike)IEBlocks.MetalDevices.CAPACITOR_HV)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.TESLA_COIL)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.FLOODLIGHT).pattern("sii").pattern("pes").pattern("sci").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).define(Character.valueOf('s'), IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).plate).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.LIGHT_BULB).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).define(Character.valueOf('p'), Tags.Items.GLASS_PANES).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.LIGHT_BULB), DeviceRecipes.has((ItemLike)IEItems.Ingredients.LIGHT_BULB)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.FLOODLIGHT)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.TURRET_CHEM).pattern(" s ").pattern(" gc").pattern("bte").define(Character.valueOf('s'), (ItemLike)IEItems.Misc.TOOL_UPGRADES.get(ToolUpgrade.RAILGUN_SCOPE)).define(Character.valueOf('g'), (ItemLike)IEItems.Weapons.CHEMTHROWER).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC_ADV).define(Character.valueOf('b'), (ItemLike)IEBlocks.MetalDevices.BARREL).define(Character.valueOf('t'), (ItemLike)IEBlocks.WoodenDevices.TURNTABLE).define(Character.valueOf('e'), (ItemLike)IEBlocks.MetalDecoration.ENGINEERING_RS).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Weapons.CHEMTHROWER), DeviceRecipes.has((ItemLike)IEItems.Weapons.CHEMTHROWER)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.TURRET_CHEM)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.TURRET_GUN).pattern(" s ").pattern(" gc").pattern("bte").define(Character.valueOf('s'), (ItemLike)IEItems.Misc.TOOL_UPGRADES.get(ToolUpgrade.RAILGUN_SCOPE)).define(Character.valueOf('g'), (ItemLike)IEItems.Weapons.REVOLVER).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC_ADV).define(Character.valueOf('b'), (ItemLike)IEItems.Misc.TOOL_UPGRADES.get(ToolUpgrade.REVOLVER_MAGAZINE)).define(Character.valueOf('t'), (ItemLike)IEBlocks.WoodenDevices.TURNTABLE).define(Character.valueOf('e'), (ItemLike)IEBlocks.MetalDecoration.ENGINEERING_RS).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Weapons.REVOLVER), DeviceRecipes.has((ItemLike)IEItems.Weapons.REVOLVER)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.TURRET_GUN)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.CLOCHE).pattern("geg").pattern("gcg").pattern(" w ").define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('w'), (ItemLike)IEBlocks.WoodenDecoration.BASIC_ENGINEERING).define(Character.valueOf('e'), (ItemLike)IEItems.Ingredients.LIGHT_BULB).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.LIGHT_BULB), DeviceRecipes.has((ItemLike)IEItems.Ingredients.LIGHT_BULB)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.CLOCHE)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.FLUID_PLACER).pattern("ibi").pattern("b b").pattern("ibi").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).define(Character.valueOf('b'), (ItemLike)Items.IRON_BARS).unlockedBy("has_iron_plate", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.FLUID_PLACER)));
        for (Map.Entry chute : IEBlocks.MetalDevices.CHUTES.entrySet()) {
            this.shapedMisc((ItemLike)chute.getValue(), 12).pattern("s s").pattern("s s").pattern("s s").define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)((EnumMetals)chute.getKey())).sheetmetal)).unlockedBy("has_plate", DeviceRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)((EnumMetals)chute.getKey())).plate)).save(out, this.toRL(this.toPath((ItemLike)chute.getValue())));
        }
        Ingredient anyDyeableChute = Ingredient.fromValues(Stream.concat(IEBlocks.MetalDevices.CHUTES.values().stream(), IEBlocks.MetalDevices.DYED_CHUTES.values().stream()).map(b -> new Ingredient.ItemValue(new ItemStack((ItemLike)b))));
        for (Map.Entry chute : IEBlocks.MetalDevices.DYED_CHUTES.entrySet()) {
            this.shapedMisc((ItemLike)chute.getValue(), 12).pattern("s s").pattern("s s").pattern("s s").define(Character.valueOf('s'), (ItemLike)IEBlocks.MetalDecoration.COLORED_SHEETMETAL.get(chute.getKey())).unlockedBy("has_sheetmetal", DeviceRecipes.has((ItemLike)((ItemLike)IEBlocks.MetalDecoration.COLORED_SHEETMETAL.get(chute.getKey())))).save(out, this.toRL(this.toPath((ItemLike)chute.getValue())));
            this.shapedMisc((ItemLike)chute.getValue(), 8).pattern("ccc").pattern("cdc").pattern("ccc").define(Character.valueOf('c'), anyDyeableChute).define(Character.valueOf('d'), ((DyeColor)chute.getKey()).getTag()).unlockedBy("has_sheetmetal", DeviceRecipes.has((ItemLike)((ItemLike)IEBlocks.MetalDecoration.COLORED_SHEETMETAL.get(chute.getKey())))).save(out, this.toRL(this.toPath((ItemLike)chute.getValue()) + "_dyeing"));
        }
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.ELECTROMAGNET).pattern("pcp").pattern("wiw").pattern("pwp").define(Character.valueOf('w'), (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER)).define(Character.valueOf('p'), IETags.steelRod).define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC), DeviceRecipes.has((ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.ELECTROMAGNET)));
        this.shapedMisc((ItemLike)IEBlocks.MetalDevices.PIPE_VALVE).pattern("pc").pattern("sr").define(Character.valueOf('p'), (ItemLike)IEBlocks.MetalDevices.FLUID_PIPE).define(Character.valueOf('c'), (ItemLike)IEItems.Ingredients.COMPONENT_IRON).define(Character.valueOf('s'), IETags.ironRod).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_fluid_pipe", DeviceRecipes.has((ItemLike)IEBlocks.MetalDevices.FLUID_PIPE)).save(out, this.toRL(this.toPath((ItemLike)IEBlocks.MetalDevices.PIPE_VALVE)));
    }

    private void addCoveyorCoveringRecipe(ItemLike basic, RecipeOutput out) {
        ItemStack result = ConveyorBlock.makeCovered((ItemLike)basic, (Block)((IEBlocks.BlockEntry)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(MetalScaffoldingType.STANDARD)).get());
        this.shapedMisc((ItemLike)result.getItem()).pattern("s").pattern("c").define(Character.valueOf('s'), IETags.getItemTag((TagKey)IETags.scaffoldingSteel)).define(Character.valueOf('c'), basic).unlockedBy("has_vertical_conveyor", DeviceRecipes.has((ItemLike)basic)).save(WrappingRecipeOutput.replaceShapedOutput(out, result), this.toRL(this.toPath(basic) + "_covered"));
    }
}

