/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.models;

import blusunrize.immersiveengineering.data.models.TransformationMap;
import com.google.common.io.CharStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class TRSRModelBuilder
extends ModelBuilder<TRSRModelBuilder> {
    private final TransformationMap transforms = new TransformationMap();
    private final List<SimpleOverride> overrides = new ArrayList<SimpleOverride>();

    protected TRSRModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation, existingFileHelper);
    }

    public TRSRModelBuilder transforms(ResourceLocation source) {
        try {
            Resource transformFile = this.existingFileHelper.getResource(source, PackType.CLIENT_RESOURCES, ".json", "transformations");
            String jsonString = CharStreams.toString((Readable)new InputStreamReader(transformFile.open()));
            this.transforms.addFromJson(jsonString);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("While loading transforms from " + String.valueOf(source), e);
        }
    }

    public TRSRModelBuilder override(ModelFile model, ResourceLocation predicateKey, float predicateValue) {
        this.overrides.add(new SimpleOverride(model, Map.of(predicateKey, Float.valueOf(predicateValue))));
        return this;
    }

    public JsonObject toJson() {
        JsonObject ret = super.toJson();
        JsonObject transformJson = this.transforms.toJson();
        if (!transformJson.entrySet().isEmpty()) {
            ret.add("display", (JsonElement)transformJson);
        }
        if (!this.overrides.isEmpty()) {
            ret.add("overrides", (JsonElement)this.overrides.stream().map(SimpleOverride::toJson).collect(Collector.of(JsonArray::new, JsonArray::add, (jsonElements, jsonElements2) -> {
                jsonElements.addAll(jsonElements2);
                return jsonElements;
            }, new Collector.Characteristics[0])));
        }
        return ret;
    }

    record SimpleOverride(ModelFile model, Map<ResourceLocation, Float> predicates) {
        JsonObject toJson() {
            JsonObject ret = new JsonObject();
            JsonObject predicatesJson = new JsonObject();
            this.predicates.forEach((key, val) -> predicatesJson.addProperty(key.toString(), (Number)val));
            ret.add("predicate", (JsonElement)predicatesJson);
            ret.addProperty("model", this.model.getLocation().toString());
            return ret;
        }
    }
}

