/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.manual.icon;

import java.awt.image.BufferedImage;

public class TextureCutter {
    private final int width;
    private final int height;

    public TextureCutter(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public BufferedImage cutTexture(BufferedImage source) {
        BufferedImage bufferedimage = new BufferedImage(this.width, this.height, 2);
        int minX = source.getWidth() + 1;
        int minY = source.getWidth() + 1;
        int maxX = -1;
        int maxY = -1;
        for (int x = 0; x < source.getWidth(); ++x) {
            for (int y = 0; y < source.getHeight(); ++y) {
                int argb = source.getRGB(x, y);
                int alpha = argb >> 24 & 0xFF;
                if (alpha <= 0) continue;
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        if (minX == source.getWidth() + 1 || minY == source.getWidth() + 1 || maxX == -1 || maxY == -1 || minX >= maxX || minY >= maxY) {
            return bufferedimage;
        }
        int newWidth = maxX - minX;
        int newHeight = maxY - minY;
        if (newWidth > this.width) {
            return bufferedimage;
        }
        if (newHeight > this.height) {
            return bufferedimage;
        }
        int xOffset = (this.width - newWidth) / 2;
        int yOffset = (this.height - newHeight) / 2;
        for (int x = 0; x <= newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                bufferedimage.setRGB(xOffset + x, yOffset + y, source.getRGB(minX + x, minY + y));
            }
        }
        return bufferedimage;
    }
}

