/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.manual.icon;

import blusunrize.immersiveengineering.client.utils.DummyVertexBuilder;
import blusunrize.immersiveengineering.data.manual.icon.TextureCutter;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL40;

public class ModelRenderer
implements AutoCloseable {
    private final int width;
    private final int height;
    private final int framebufferID;
    private final int renderedTexture;
    private final int depthBuffer;
    private final File outputDirectory;
    private final ItemRenderer itemRenderer;
    private final RenderBuffers renderBuffers = new RenderBuffers(1);

    public ModelRenderer(int width, int height, File outputDirectory) {
        this.width = width;
        this.height = height;
        this.outputDirectory = outputDirectory;
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
        this.framebufferID = GL40.glGenFramebuffers();
        GL40.glBindFramebuffer((int)36160, (int)this.framebufferID);
        this.renderedTexture = GL40.glGenTextures();
        RenderSystem.bindTexture((int)this.renderedTexture);
        GL40.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (long)0L);
        GL40.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL40.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL40.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.renderedTexture, (int)0);
        this.depthBuffer = GL40.glGenRenderbuffers();
        GL40.glBindRenderbuffer((int)36161, (int)this.depthBuffer);
        GL40.glRenderbufferStorage((int)36161, (int)35056, (int)width, (int)height);
        GL40.glFramebufferRenderbuffer((int)36160, (int)33306, (int)36161, (int)this.depthBuffer);
        GL40.glViewport((int)0, (int)0, (int)width, (int)height);
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float viewSize = 20.0f;
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, 20.0f, 0.0f, 20.0f, -200.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.translate(10.0f, 10.0f, 100.0f);
        modelViewStack.scale(1.0f, -1.0f, 1.0f);
        modelViewStack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
    }

    @Override
    public void close() {
        GL40.glDeleteBuffers((int)this.framebufferID);
        GL40.glDeleteTextures((int)this.renderedTexture);
        GL40.glDeleteRenderbuffers((int)this.depthBuffer);
    }

    public void renderModel(BakedModel model, String filename, ItemStack stack) {
        if (model == null) {
            return;
        }
        model = model.getOverrides().resolve(model, stack, null, null, 0);
        GL40.glBindFramebuffer((int)36160, (int)this.framebufferID);
        RenderSystem.bindTexture((int)this.renderedTexture);
        GL40.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL40.glClearDepth((double)1.0);
        GL40.glClear((int)16640);
        GL40.glEnable((int)2884);
        GL40.glCullFace((int)1028);
        if (model.usesBlockLight()) {
            Lighting.setupFor3DItems();
        } else {
            Lighting.setupForFlatItems();
        }
        MultiBufferSource.BufferSource bufferSources = this.renderBuffers.bufferSource();
        MultiBufferSource noFoilSource = type -> {
            if (type == RenderType.glint()) {
                return DummyVertexBuilder.INSTANCE;
            }
            return bufferSources.getBuffer(type);
        };
        this.itemRenderer.render(stack, ItemDisplayContext.GUI, false, new PoseStack(), noFoilSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        bufferSources.endBatch();
        this.renderBuffers.fixedBufferPack().clearAll();
        TextureCutter cutter = new TextureCutter(this.width, this.height);
        this.exportTo(filename, () -> RenderSystem.bindTexture((int)this.renderedTexture), cutter::cutTexture);
    }

    private void exportTo(String fileName, Runnable textureBinder, Function<BufferedImage, BufferedImage> imageAdapter) {
        textureBinder.run();
        int size = this.width * this.height;
        BufferedImage bufferedimage = new BufferedImage(this.width, this.height, 2);
        File output = new File(this.outputDirectory, fileName);
        IntBuffer buffer = BufferUtils.createIntBuffer((int)size);
        int[] data = new int[size];
        GL40.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buffer);
        buffer.get(data);
        bufferedimage.setRGB(0, 0, this.width, this.height, data, 0, this.width);
        try {
            output.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)imageAdapter.apply(bufferedimage), "png", output);
        }
        catch (IOException xcp) {
            throw new RuntimeException(xcp);
        }
    }
}

