/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.client.models.ModelCoresample;
import blusunrize.immersiveengineering.client.models.PotionBucketModel;
import blusunrize.immersiveengineering.client.models.connection.FeedthroughLoader;
import blusunrize.immersiveengineering.client.models.obj.callback.item.BuzzsawCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.item.ChemthrowerCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.item.DrillCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.item.FluorescentTubeCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.item.PowerpackCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.item.RailgunCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.item.RevolverCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.item.ShieldCallbacks;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalLadderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.WarningSignBlock;
import blusunrize.immersiveengineering.common.register.IEBannerPatterns;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.data.blockstates.MultiblockStates;
import blusunrize.immersiveengineering.data.models.ConveyorModelBuilder;
import blusunrize.immersiveengineering.data.models.IEOBJBuilder;
import blusunrize.immersiveengineering.data.models.ModelProviderUtils;
import blusunrize.immersiveengineering.data.models.SpecialModelBuilder;
import blusunrize.immersiveengineering.data.models.TRSRItemModelProvider;
import blusunrize.immersiveengineering.data.models.TRSRModelBuilder;
import blusunrize.immersiveengineering.mixin.accessors.ItemModelGeneratorsAccess;
import blusunrize.immersiveengineering.mixin.accessors.TrimModelDataAccess;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.client.model.generators.loaders.ObjModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModels
extends TRSRItemModelProvider {
    private final MultiblockStates blockStates;

    public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper, MultiblockStates blockStates) {
        super(output, existingFileHelper);
        this.blockStates = blockStates;
    }

    private ResourceLocation forgeLoc(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)s);
    }

    protected void registerModels() {
        for (EnumMetals m : EnumMetals.values()) {
            this.createMetalModels(m);
        }
        this.createItemModels();
        this.createMetalModels();
        this.createWoodenModels();
        this.createStoneModels();
        this.createClothModels();
        this.createConnectorModels();
    }

    private void createMetalModels() {
        this.cubeBottomTop(this.name((ItemLike)IEBlocks.MetalDevices.BARREL), ImmersiveEngineering.rl((String)"block/metal_device/barrel_side"), ImmersiveEngineering.rl((String)"block/metal_device/barrel_up_none"), ImmersiveEngineering.rl((String)"block/metal_device/barrel_up_none"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.MetalDecoration.STEEL_POST, this.modLoc("block/wooden_device/wooden_post_inv.obj")).texture("post", this.modLoc("block/metal_decoration/steel_post"))).transforms(this.modLoc("item/post"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.MetalDecoration.ALU_POST, this.modLoc("block/wooden_device/wooden_post_inv.obj")).texture("post", this.modLoc("block/metal_decoration/aluminum_post"))).transforms(this.modLoc("item/post"));
        this.addItemModel("door_steel", (ItemLike)IEBlocks.MetalDecoration.STEEL_DOOR);
        this.addItemModel("sign_steel", (ItemLike)IEBlocks.MetalDecoration.STEEL_SIGN.sign());
        this.addItemModel("sign_steel_hanging", (ItemLike)IEBlocks.MetalDecoration.STEEL_SIGN.hanging());
        this.addItemModel("sign_aluminum", (ItemLike)IEBlocks.MetalDecoration.ALU_SIGN.sign());
        this.addItemModel("sign_aluminum_hanging", (ItemLike)IEBlocks.MetalDecoration.ALU_SIGN.hanging());
        for (Map.Entry warningSign : IEBlocks.MetalDecoration.WARNING_SIGNS.entrySet()) {
            this.addLayeredItemModel(((IEBlocks.BlockEntry)warningSign.getValue()).asItem(), ImmersiveEngineering.rl((String)"block/metal_decoration/sign/base_front"), ImmersiveEngineering.rl((String)("block/metal_decoration/sign/icon_" + ((WarningSignBlock.WarningSignIcon)warningSign.getKey()).getSerializedName())));
        }
        this.obj((ItemLike)IEBlocks.MetalDevices.CLOCHE, ImmersiveEngineering.rl((String)"block/metal_device/cloche.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/cloche")).renderType(ModelProviderUtils.getName(RenderType.translucent()));
        this.obj((ItemLike)IEBlocks.MetalDevices.TESLA_COIL, ImmersiveEngineering.rl((String)"block/metal_device/teslacoil.obj")).transforms(ImmersiveEngineering.rl((String)"item/teslacoil"));
        for (Map.Entry chute : IEBlocks.MetalDevices.CHUTES.entrySet()) {
            ((TRSRModelBuilder)this.obj((ItemLike)chute.getValue(), ImmersiveEngineering.rl((String)"block/metal_device/chute_inv.obj")).texture("texture", this.modLoc("block/metal/sheetmetal_" + ((EnumMetals)chute.getKey()).tagName()))).transforms(ImmersiveEngineering.rl((String)"item/block"));
        }
        for (Map.Entry chute : IEBlocks.MetalDevices.DYED_CHUTES.entrySet()) {
            ((TRSRModelBuilder)this.obj((ItemLike)chute.getValue(), ImmersiveEngineering.rl((String)"block/metal_device/chute_inv.obj")).texture("texture", this.modLoc("block/metal/sheetmetal_" + ((DyeColor)chute.getKey()).getName()))).transforms(ImmersiveEngineering.rl((String)"item/block"));
        }
        this.obj((ItemLike)IEBlocks.MetalDevices.TURRET_CHEM, ImmersiveEngineering.rl((String)"block/metal_device/chem_turret_inv.obj")).transforms(ImmersiveEngineering.rl((String)"item/turret"));
        this.obj((ItemLike)IEBlocks.MetalDevices.TURRET_GUN, ImmersiveEngineering.rl((String)"block/metal_device/gun_turret_inv.obj")).transforms(ImmersiveEngineering.rl((String)"item/turret"));
        this.obj((ItemLike)IEBlocks.MetalDevices.FLUID_PIPE, ImmersiveEngineering.rl((String)"block/metal_device/fluid_pipe.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/block"));
        this.obj((ItemLike)IEBlocks.MetalDevices.FLUID_PUMP, ImmersiveEngineering.rl((String)"block/metal_device/fluid_pump_inv.obj")).transforms(ImmersiveEngineering.rl((String)"item/fluid_pump"));
        this.obj((ItemLike)IEBlocks.MetalDevices.BLAST_FURNACE_PREHEATER, ImmersiveEngineering.rl((String)"block/metal_device/blastfurnace_preheater.obj")).transforms(ImmersiveEngineering.rl((String)"item/blastfurnace_preheater"));
        this.obj((ItemLike)IEBlocks.MetalDevices.SAMPLE_DRILL, ImmersiveEngineering.rl((String)"block/metal_device/core_drill.obj")).transforms(ImmersiveEngineering.rl((String)"item/sampledrill"));
        this.obj((ItemLike)IEMultiblockLogic.METAL_PRESS.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/metal_press.obj")).transforms(ImmersiveEngineering.rl((String)"item/multiblock"));
        this.obj((ItemLike)IEMultiblockLogic.CRUSHER.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/crusher.obj")).transforms(ImmersiveEngineering.rl((String)"item/crusher"));
        this.obj((ItemLike)IEMultiblockLogic.SAWMILL.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/sawmill.obj")).transforms(ImmersiveEngineering.rl((String)"item/crusher"));
        this.obj((ItemLike)IEMultiblockLogic.TANK.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/tank.obj")).transforms(ImmersiveEngineering.rl((String)"item/tank"));
        this.obj((ItemLike)IEMultiblockLogic.SILO.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/silo.obj")).transforms(ImmersiveEngineering.rl((String)"item/silo"));
        this.obj((ItemLike)IEMultiblockLogic.ASSEMBLER.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/assembler.obj")).transforms(ImmersiveEngineering.rl((String)"item/multiblock"));
        this.obj((ItemLike)IEMultiblockLogic.AUTO_WORKBENCH.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/auto_workbench.obj")).transforms(ImmersiveEngineering.rl((String)"item/multiblock"));
        this.obj((ItemLike)IEMultiblockLogic.BOTTLING_MACHINE.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/bottling_machine.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/bottling_machine"));
        this.obj((ItemLike)IEMultiblockLogic.SQUEEZER.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/squeezer.obj")).transforms(ImmersiveEngineering.rl((String)"item/multiblock"));
        this.obj((ItemLike)IEMultiblockLogic.FERMENTER.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/fermenter.obj")).transforms(ImmersiveEngineering.rl((String)"item/multiblock"));
        this.obj((ItemLike)IEMultiblockLogic.REFINERY.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/refinery.obj")).transforms(ImmersiveEngineering.rl((String)"item/refinery"));
        this.obj((ItemLike)IEMultiblockLogic.DIESEL_GENERATOR.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/diesel_generator.obj")).transforms(ImmersiveEngineering.rl((String)"item/crusher"));
        this.obj((ItemLike)IEMultiblockLogic.EXCAVATOR.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/excavator.obj")).transforms(ImmersiveEngineering.rl((String)"item/excavator"));
        this.obj((ItemLike)IEMultiblockLogic.BUCKET_WHEEL.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/bucket_wheel.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/bucket_wheel"));
        this.obj((ItemLike)IEMultiblockLogic.ARC_FURNACE.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/arc_furnace.obj")).transforms(ImmersiveEngineering.rl((String)"item/arc_furnace"));
        this.obj((ItemLike)IEMultiblockLogic.LIGHTNING_ROD.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/lightningrod.obj")).transforms(ImmersiveEngineering.rl((String)"item/multiblock"));
        this.obj((ItemLike)IEMultiblockLogic.MIXER.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/mixer.obj")).transforms(ImmersiveEngineering.rl((String)"item/multiblock"));
        this.obj((ItemLike)IEMultiblockLogic.RADIO_TOWER.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/radio_tower.obj")).transforms(ImmersiveEngineering.rl((String)"item/radio_tower"));
        this.obj((ItemLike)IEMultiblockLogic.CHUNK_LOADER.blockItem().get(), ImmersiveEngineering.rl((String)"block/metal_multiblock/chunk_loader.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/chunk_loader")).renderType(ModelProviderUtils.getName(RenderType.translucent()));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.MetalDecoration.ALU_WALLMOUNT, this.modLoc("block/wooden_device/wallmount.obj")).texture("texture", this.modLoc("block/metal_decoration/aluminum_wallmount"))).transforms(this.modLoc("item/wallmount"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.MetalDecoration.STEEL_WALLMOUNT, this.modLoc("block/wooden_device/wallmount.obj")).texture("texture", this.modLoc("block/metal_decoration/steel_wallmount"))).transforms(this.modLoc("item/wallmount"));
        for (IEBlocks.BlockEntry b : IEBlocks.MetalDevices.CONVEYORS.values()) {
            ((ConveyorModelBuilder)this.getBuilder((ItemLike)b).customLoader(ConveyorModelBuilder::begin)).type(((ConveyorBlock)b.get()).getType()).end();
        }
        this.obj((ItemLike)IEBlocks.MetalDecoration.LANTERN, this.modLoc("block/lantern_inventory.obj")).transforms(this.modLoc("item/block"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.MetalDecoration.CAGELAMP, ImmersiveEngineering.rl((String)"block/cagelamp.obj")).texture("texture", this.modLoc("block/metal_decoration/cagelamp"))).transforms(ImmersiveEngineering.rl((String)"item/block"));
        this.addLayeredItemModel(((IEBlocks.BlockEntry)IEBlocks.MetalDecoration.METAL_LADDER.get(MetalLadderBlock.CoverType.NONE)).asItem(), ImmersiveEngineering.rl((String)"block/metal_decoration/metal_ladder"));
    }

    private void createWoodenModels() {
        this.obj((ItemLike)IEBlocks.WoodenDevices.CRAFTING_TABLE, ImmersiveEngineering.rl((String)"block/wooden_device/craftingtable.obj")).transforms(ImmersiveEngineering.rl((String)"item/block"));
        this.cubeBottomTop(this.name((ItemLike)IEBlocks.WoodenDevices.WOODEN_BARREL), ImmersiveEngineering.rl((String)"block/wooden_device/barrel_side"), ImmersiveEngineering.rl((String)"block/wooden_device/barrel_up_none"), ImmersiveEngineering.rl((String)"block/wooden_device/barrel_up_none"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.WoodenDecoration.TREATED_POST, this.modLoc("block/wooden_device/wooden_post_inv.obj")).texture("post", this.modLoc("block/wooden_decoration/post"))).transforms(this.modLoc("item/post"));
        this.addItemModel("door_treated", (ItemLike)IEBlocks.WoodenDecoration.DOOR);
        this.addItemModel("door_treated_framed", (ItemLike)IEBlocks.WoodenDecoration.DOOR_FRAMED);
        this.addItemModel("sign_treated", (ItemLike)IEBlocks.WoodenDecoration.SIGN.sign());
        this.addItemModel("sign_treated_hanging", (ItemLike)IEBlocks.WoodenDecoration.SIGN.hanging());
        this.obj((ItemLike)IEBlocks.WoodenDevices.WORKBENCH, ImmersiveEngineering.rl((String)"block/wooden_device/workbench.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/workbench"));
        this.obj((ItemLike)IEBlocks.WoodenDevices.CIRCUIT_TABLE, ImmersiveEngineering.rl((String)"block/wooden_device/circuit_table.obj")).transforms(ImmersiveEngineering.rl((String)"item/workbench"));
        this.obj((ItemLike)IEBlocks.WoodenDevices.LOGIC_UNIT, ImmersiveEngineering.rl((String)"block/wooden_device/logic_unit.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/block"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.WoodenDevices.TREATED_WALLMOUNT, this.modLoc("block/wooden_device/wallmount.obj")).texture("texture", this.modLoc("block/wooden_device/wallmount"))).transforms(this.modLoc("item/wallmount"));
        this.obj((ItemLike)IEBlocks.WoodenDevices.WATERMILL, this.modLoc("block/wooden_device/watermill.obj")).transforms(this.modLoc("item/watermill"));
        this.obj((ItemLike)IEBlocks.WoodenDevices.WINDMILL, this.modLoc("block/wooden_device/windmill.obj.ie")).transforms(this.modLoc("item/windmill"));
    }

    private void createClothModels() {
        ((TRSRModelBuilder)this.withExistingParent(this.name((ItemLike)IEBlocks.Cloth.STRIP_CURTAIN), ImmersiveEngineering.rl((String)"block/stripcurtain"))).transforms(ImmersiveEngineering.rl((String)"item/stripcurtain"));
        this.obj((ItemLike)IEBlocks.Cloth.BALLOON, ImmersiveEngineering.rl((String)"block/balloon.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/block"));
    }

    private void createItemModels() {
        this.addItemModels("metal_", (ItemLike[])IEItems.Metals.INGOTS.values().stream().filter(i -> "immersiveengineering".equals(i.getId().getNamespace())).toArray(ItemLike[]::new));
        this.addItemModels("metal_", (ItemLike[])IEItems.Metals.NUGGETS.values().stream().filter(i -> "immersiveengineering".equals(i.getId().getNamespace())).toArray(ItemLike[]::new));
        this.addItemModels("metal_", (ItemLike[])IEItems.Metals.RAW_ORES.values().stream().filter(i -> "immersiveengineering".equals(i.getId().getNamespace())).toArray(ItemLike[]::new));
        this.addItemModels("metal_", IEItems.Metals.DUSTS.values().toArray(new ItemLike[0]));
        this.addItemModels("metal_", IEItems.Metals.PLATES.values().toArray(new ItemLike[0]));
        for (ItemLike itemLike : IEItems.Misc.SHADER_BAG.values()) {
            this.addItemModel("shader_bag", itemLike);
        }
        for (ItemLike itemLike : IEItems.Misc.SHADERS.values()) {
            ((TRSRModelBuilder)((TRSRModelBuilder)((TRSRModelBuilder)this.withExistingParent(this.name(itemLike), IEApi.ieLoc((String)"item/ie_item_base"))).texture("layer0", IEApi.ieLoc((String)"item/shader_0"))).texture("layer1", IEApi.ieLoc((String)"item/shader_1"))).texture("layer2", IEApi.ieLoc((String)"item/shader_2"));
        }
        this.addItemModels("material_", new ItemLike[]{IEItems.Ingredients.STICK_TREATED, IEItems.Ingredients.STICK_IRON, IEItems.Ingredients.STICK_STEEL, IEItems.Ingredients.STICK_ALUMINUM, IEItems.Ingredients.STICK_NETHERITE, IEItems.Ingredients.HEMP_FIBER, IEItems.Ingredients.HEMP_FABRIC, IEItems.Ingredients.ERSATZ_LEATHER, IEItems.Ingredients.COAL_COKE, IEItems.Ingredients.SLAG, IEItems.Ingredients.COMPONENT_IRON, IEItems.Ingredients.COMPONENT_STEEL, IEItems.Ingredients.WATERWHEEL_SEGMENT, IEItems.Ingredients.WINDMILL_BLADE, IEItems.Ingredients.WINDMILL_SAIL, IEItems.Ingredients.WOODEN_GRIP, IEItems.Ingredients.GUNPART_BARREL, IEItems.Ingredients.GUNPART_DRUM, IEItems.Ingredients.GUNPART_HAMMER, IEItems.Ingredients.DUST_COKE, IEItems.Ingredients.DUST_HOP_GRAPHITE, IEItems.Ingredients.INGOT_HOP_GRAPHITE, IEItems.Ingredients.PLATE_HOP_GRAPHITE, IEItems.Ingredients.WIRE_COPPER, IEItems.Ingredients.WIRE_ELECTRUM, IEItems.Ingredients.WIRE_ALUMINUM, IEItems.Ingredients.WIRE_STEEL, IEItems.Ingredients.WIRE_LEAD, IEItems.Ingredients.DUST_SALTPETER, IEItems.Ingredients.DUST_SULFUR, IEItems.Ingredients.DUST_WOOD, IEItems.Ingredients.LIGHT_BULB, IEItems.Ingredients.ELECTRON_TUBE, IEItems.Ingredients.CIRCUIT_BOARD, IEItems.Ingredients.DUROPLAST_PLATE, IEItems.Ingredients.COMPONENT_ELECTRONIC, IEItems.Ingredients.COMPONENT_ELECTRONIC_ADV});
        this.addItemModels("metal_", new ItemLike[]{IEItems.Ingredients.NUGGET_NETHERITE});
        this.addItemModels("tool_", this.mcLoc("item/handheld"), new ItemLike[]{IEItems.Tools.HAMMER, IEItems.Tools.WIRECUTTER, IEItems.Tools.SCREWDRIVER, IEItems.Tools.MANUAL, IEItems.Tools.STEEL_PICK, IEItems.Tools.STEEL_SHOVEL, IEItems.Tools.STEEL_AXE, IEItems.Tools.STEEL_HOE, IEItems.Tools.STEEL_SWORD});
        this.addItemModels("", new ItemLike[]{IEItems.Tools.SURVEY_TOOLS});
        this.addItemModels("", new ItemLike[]{IEItems.Tools.GLIDER});
        this.addItemModels("", IEItems.Misc.WIRE_COILS.values().toArray(new ItemLike[0]));
        this.addItemModels("", new ItemLike[]{IEItems.Misc.GRAPHITE_ELECTRODE});
        this.addItemModels("", IEItems.Misc.TOOL_UPGRADES.values().toArray(new ItemLike[0]));
        this.addItemModels("", new ItemLike[]{IEItems.Molds.MOLD_PLATE, IEItems.Molds.MOLD_GEAR, IEItems.Molds.MOLD_ROD, IEItems.Molds.MOLD_BULLET_CASING, IEItems.Molds.MOLD_WIRE, IEItems.Molds.MOLD_PACKING_4, IEItems.Molds.MOLD_PACKING_9, IEItems.Molds.MOLD_UNPACKING});
        this.addItemModels("bullet_", new ItemLike[]{IEItems.Ingredients.EMPTY_CASING, IEItems.Ingredients.EMPTY_SHELL});
        for (Map.Entry entry : IEItems.Weapons.BULLETS.entrySet()) {
            this.addLayeredItemModel(((IEItems.ItemRegObject)entry.getValue()).asItem(), ((BulletHandler.IBullet)entry.getKey()).getTextures());
        }
        this.addItemModels("", IEItems.Misc.FARADAY_SUIT.values());
        for (Map.Entry entry : IEItems.Tools.STEEL_ARMOR.entrySet()) {
            this.addTrimmedArmorModel((ArmorItem)((IEItems.ItemRegObject)entry.getValue()).get());
        }
        this.addItemModel("blueprint", (ItemLike)IEItems.Misc.BLUEPRINT);
        this.addItemModel("seed_hemp", (ItemLike)IEItems.Misc.HEMP_SEEDS);
        this.addItemModel("drillhead_iron", (ItemLike)IEItems.Tools.DRILLHEAD_IRON);
        this.addItemModel("drillhead_steel", (ItemLike)IEItems.Tools.DRILLHEAD_STEEL);
        this.addItemModels("", new ItemLike[]{IEItems.Tools.SAWBLADE, IEItems.Tools.ROCKCUTTER, IEItems.Tools.GRINDINGDISK});
        this.addItemModels("", new ItemLike[]{IEItems.Misc.MAINTENANCE_KIT});
        this.addItemModels("", new ItemLike[]{IEItems.Minecarts.CART_WOODEN_CRATE, IEItems.Minecarts.CART_REINFORCED_CRATE, IEItems.Minecarts.CART_WOODEN_BARREL, IEItems.Minecarts.CART_METAL_BARREL});
        this.addItemModels("", new ItemLike[]{IEItems.Misc.LOGIC_CIRCUIT_BOARD});
        this.addItemModels("", new ItemLike[]{IEItems.Misc.FERTILIZER});
        for (IEBannerPatterns.BannerEntry bannerEntry : IEBannerPatterns.ALL_BANNERS) {
            this.addItemModel("banner_pattern_" + bannerEntry.name(), (ItemLike)bannerEntry.item());
        }
        this.addItemModels("", new ItemLike[]{IEItems.Misc.ICON_BIRTHDAY, IEItems.Misc.ICON_LUCKY, IEItems.Misc.ICON_ACHTUNG, IEItems.Misc.ICON_DRILLBREAK, IEItems.Misc.ICON_RAVENHOLM, IEItems.Misc.ICON_FRIED, IEItems.Misc.ICON_BTTF});
        this.withExistingParent(this.name((ItemLike)IEItems.SpawnEggs.EGG_FUSILIER), ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg"));
        this.withExistingParent(this.name((ItemLike)IEItems.SpawnEggs.EGG_COMMANDO), ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg"));
        this.withExistingParent(this.name((ItemLike)IEItems.SpawnEggs.EGG_BULWARK), ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg"));
        this.addItemModels("", new ItemLike[]{IEItems.SpawnEggs.ROBOT_WOLF});
        this.obj((ItemLike)IEItems.Tools.VOLTMETER, ImmersiveEngineering.rl((String)"item/voltmeter.obj")).transforms(ImmersiveEngineering.rl((String)"item/voltmeter"));
        this.obj((ItemLike)IEItems.Tools.TOOLBOX, ImmersiveEngineering.rl((String)"item/toolbox.obj")).transforms(ImmersiveEngineering.rl((String)"item/toolbox"));
        ((TRSRModelBuilder)this.ieObjBuilder((ItemLike)IEItems.Misc.SHIELD, ImmersiveEngineering.rl((String)"item/shield.obj.ie")).dynamic(true).callback((IEOBJCallback<?>)ShieldCallbacks.INSTANCE).layer(RenderType.translucent()).end()).transforms(ImmersiveEngineering.rl((String)"item/shield"));
        ((TRSRModelBuilder)this.ieObjBuilder((ItemLike)IEItems.Weapons.REVOLVER, this.modLoc("item/revolver.obj.ie")).dynamic(true).callback((IEOBJCallback<?>)RevolverCallbacks.INSTANCE).layer(RenderType.translucent()).end()).transforms(this.modLoc("item/revolver"));
        ((TRSRModelBuilder)this.ieObjBuilder((ItemLike)IEItems.Tools.DRILL, this.modLoc("item/drill/drill_diesel.obj.ie")).dynamic(true).callback((IEOBJCallback<?>)DrillCallbacks.INSTANCE).layer(RenderType.translucent()).end()).transforms(this.modLoc("item/drill"));
        ((TRSRModelBuilder)this.ieObjBuilder((ItemLike)IEItems.Tools.BUZZSAW, this.modLoc("item/buzzsaw_diesel.obj.ie")).dynamic(true).callback((IEOBJCallback<?>)BuzzsawCallbacks.INSTANCE).layer(RenderType.translucent()).end()).transforms(this.modLoc("item/buzzsaw"));
        ((TRSRModelBuilder)this.ieObjBuilder((ItemLike)IEItems.Weapons.RAILGUN, this.modLoc("item/railgun.obj.ie")).dynamic(true).callback((IEOBJCallback<?>)RailgunCallbacks.INSTANCE).layer(RenderType.translucent()).end()).transforms(this.modLoc("item/railgun"));
        ((TRSRModelBuilder)this.ieObjBuilder((ItemLike)IEItems.Weapons.CHEMTHROWER, this.modLoc("item/chemthrower.obj.ie")).dynamic(true).callback((IEOBJCallback<?>)ChemthrowerCallbacks.INSTANCE).layer(RenderType.cutout()).end()).transforms(this.modLoc("item/chemthrower"));
        ((TRSRModelBuilder)this.ieObjBuilder((ItemLike)IEItems.Misc.POWERPACK, ImmersiveEngineering.rl((String)"item/powerpack.obj")).callback((IEOBJCallback<?>)PowerpackCallbacks.INSTANCE).layer(RenderType.translucent()).end()).transforms(ImmersiveEngineering.rl((String)"item/powerpack"));
        IEFluids.ALL_ENTRIES.forEach(this::createBucket);
        ((SpecialModelBuilder)((TRSRModelBuilder)this.withExistingParent(this.name((ItemLike)IEItems.Misc.POTION_BUCKET), this.forgeLoc("item/bucket"))).customLoader(SpecialModelBuilder.forLoader(PotionBucketModel.Loader.LOADER_NAME))).end();
        ((TRSRModelBuilder)this.ieObjBuilder((ItemLike)IEItems.Misc.FLUORESCENT_TUBE, ImmersiveEngineering.rl((String)"item/fluorescent_tube.obj.ie")).callback((IEOBJCallback<?>)FluorescentTubeCallbacks.INSTANCE).dynamic(true).end()).transforms(this.modLoc("item/fluorescent_tube"));
        this.getBuilder((ItemLike)IEItems.Misc.CORESAMPLE).customLoader(SpecialModelBuilder.forLoader(ModelCoresample.CoresampleLoader.LOCATION));
    }

    private void createBucket(IEFluids.FluidEntry entry) {
        ((DynamicFluidContainerModelBuilder)((TRSRModelBuilder)this.withExistingParent(this.name((ItemLike)entry.getBucket()), this.forgeLoc("item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid((Fluid)entry.getStill());
    }

    private void createStoneModels() {
        this.obj((ItemLike)IEBlocks.StoneDecoration.CONCRETE_SPRAYED, ImmersiveEngineering.rl((String)"block/sprayed_concrete.obj")).transforms(ImmersiveEngineering.rl((String)"item/block"));
        ((TRSRModelBuilder)this.getBuilder((ItemLike)IEMultiblockLogic.ALLOY_SMELTER.blockItem().get()).parent(this.blockStates.alloySmelterOn)).transforms(ImmersiveEngineering.rl((String)"item/alloysmelter"));
        ((TRSRModelBuilder)this.getBuilder((ItemLike)IEMultiblockLogic.BLAST_FURNACE.blockItem().get()).parent(this.blockStates.blastFurnaceOn)).transforms(ImmersiveEngineering.rl((String)"item/blastfurnace"));
        ((TRSRModelBuilder)this.getBuilder((ItemLike)IEMultiblockLogic.COKE_OVEN.blockItem().get()).parent(this.blockStates.cokeOvenOn)).transforms(ImmersiveEngineering.rl((String)"item/blastfurnace"));
        this.obj((ItemLike)IEMultiblockLogic.ADV_BLAST_FURNACE.blockItem().get(), ImmersiveEngineering.rl((String)"block/blastfurnace_advanced.obj")).transforms(ImmersiveEngineering.rl((String)"item/multiblock"));
    }

    private void createConnectorModels() {
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)false), ImmersiveEngineering.rl((String)"block/connector/connector_lv.obj")).texture("texture", this.modLoc("block/connector/connector_lv"))).transforms(ImmersiveEngineering.rl((String)"item/connector"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)true), ImmersiveEngineering.rl((String)"block/connector/connector_lv.obj")).texture("texture", this.modLoc("block/connector/relay_lv"))).transforms(ImmersiveEngineering.rl((String)"item/connector"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"MV", (boolean)false), ImmersiveEngineering.rl((String)"block/connector/connector_mv.obj")).texture("texture", this.modLoc("block/connector/connector_mv"))).transforms(ImmersiveEngineering.rl((String)"item/connector"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"MV", (boolean)true), ImmersiveEngineering.rl((String)"block/connector/connector_mv.obj")).texture("texture", this.modLoc("block/connector/relay_mv"))).transforms(ImmersiveEngineering.rl((String)"item/connector"));
        this.obj((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)false), ImmersiveEngineering.rl((String)"block/connector/connector_hv.obj")).transforms(ImmersiveEngineering.rl((String)"item/connector"));
        this.obj((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)true), ImmersiveEngineering.rl((String)"block/connector/relay_hv.obj")).transforms(ImmersiveEngineering.rl((String)"item/connector"));
        this.obj((ItemLike)IEBlocks.Connectors.CONNECTOR_REDSTONE, ImmersiveEngineering.rl((String)"block/connector/connector_redstone.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/connector"));
        this.obj((ItemLike)IEBlocks.Connectors.CONNECTOR_PROBE, ImmersiveEngineering.rl((String)"block/connector/connector_probe.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/connector")).renderType(ModelProviderUtils.getName(RenderType.translucent()));
        this.obj((ItemLike)IEBlocks.Connectors.CONNECTOR_BUNDLED, ImmersiveEngineering.rl((String)"block/connector/connector_bundled.obj")).transforms(ImmersiveEngineering.rl((String)"item/connector"));
        this.obj((ItemLike)IEBlocks.Connectors.REDSTONE_STATE_CELL, ImmersiveEngineering.rl((String)"block/connector/redstone_state_cell.obj")).transforms(ImmersiveEngineering.rl((String)"item/connector")).renderType(ModelProviderUtils.getName(RenderType.translucent()));
        this.obj((ItemLike)IEBlocks.Connectors.REDSTONE_TIMER, ImmersiveEngineering.rl((String)"block/connector/redstone_timer.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/block")).renderType(ModelProviderUtils.getName(RenderType.translucent()));
        this.obj((ItemLike)IEBlocks.Connectors.REDSTONE_SWITCHBOARD, ImmersiveEngineering.rl((String)"block/connector/switchboard.obj")).transforms(ImmersiveEngineering.rl((String)"item/switchboard"));
        this.obj((ItemLike)IEBlocks.Connectors.SIREN, ImmersiveEngineering.rl((String)"block/connector/siren.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/block"));
        this.obj((ItemLike)IEBlocks.Connectors.CONNECTOR_STRUCTURAL, ImmersiveEngineering.rl((String)"block/connector/connector_structural.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/connector"));
        this.obj((ItemLike)IEBlocks.Connectors.TRANSFORMER, ImmersiveEngineering.rl((String)"block/connector/transformer_mv_left.obj")).transforms(ImmersiveEngineering.rl((String)"item/transformer"));
        this.obj((ItemLike)IEBlocks.Connectors.TRANSFORMER_HV, ImmersiveEngineering.rl((String)"block/connector/transformer_hv_left.obj")).transforms(ImmersiveEngineering.rl((String)"item/transformer"));
        this.obj((ItemLike)IEBlocks.Connectors.REDSTONE_BREAKER, ImmersiveEngineering.rl((String)"block/connector/redstone_breaker.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/redstone_breaker"));
        this.obj((ItemLike)IEBlocks.Connectors.CURRENT_TRANSFORMER, ImmersiveEngineering.rl((String)"block/connector/e_meter.obj")).transforms(ImmersiveEngineering.rl((String)"item/current_transformer"));
        this.obj((ItemLike)IEBlocks.Connectors.BREAKER_SWITCH, ImmersiveEngineering.rl((String)"block/connector/breaker_switch_off.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/breaker_switch"));
        this.obj((ItemLike)IEBlocks.MetalDevices.RAZOR_WIRE, ImmersiveEngineering.rl((String)"block/razor_wire.obj.ie")).transforms(ImmersiveEngineering.rl((String)"item/block"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.MetalDevices.ELECTRIC_LANTERN, ImmersiveEngineering.rl((String)"block/metal_device/e_lantern.obj")).texture("texture", this.modLoc("block/metal_device/electric_lantern"))).transforms(ImmersiveEngineering.rl((String)"item/block"));
        ((TRSRModelBuilder)this.obj((ItemLike)IEBlocks.MetalDevices.FLOODLIGHT, ImmersiveEngineering.rl((String)"block/metal_device/floodlight.obj.ie")).texture("texture", this.modLoc("block/metal_device/floodlight"))).transforms(ImmersiveEngineering.rl((String)"item/floodlight"));
        this.getBuilder((ItemLike)IEBlocks.Connectors.FEEDTHROUGH).customLoader(SpecialModelBuilder.forLoader(FeedthroughLoader.LOCATION));
    }

    private TRSRModelBuilder obj(ItemLike item, ResourceLocation model) {
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(model, PackType.CLIENT_RESOURCES, "", "models"));
        return (TRSRModelBuilder)((ObjModelBuilder)this.getBuilder(item).customLoader(ObjModelBuilder::begin)).flipV(true).modelLocation(model.withPath("models/" + model.getPath())).end();
    }

    private IEOBJBuilder<TRSRModelBuilder> ieObjBuilder(ItemLike item, ResourceLocation model) {
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(model, PackType.CLIENT_RESOURCES, "", "models"));
        return ((IEOBJBuilder)this.getBuilder(item).customLoader(IEOBJBuilder::begin)).modelLocation(model.withPath("models/" + model.getPath()));
    }

    private TRSRModelBuilder getBuilder(ItemLike item) {
        return (TRSRModelBuilder)this.getBuilder(this.name(item));
    }

    private String name(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }

    @Nonnull
    public String getName() {
        return "Item models";
    }

    private void createMetalModels(EnumMetals metal) {
        String name = metal.tagName();
        if (metal.shouldAddOre()) {
            this.cubeAll(this.name((ItemLike)IEBlocks.Metals.ORES.get(metal)), ImmersiveEngineering.rl((String)("block/metal/ore_" + name)));
            this.cubeAll(this.name((ItemLike)IEBlocks.Metals.DEEPSLATE_ORES.get(metal)), ImmersiveEngineering.rl((String)("block/metal/deepslate_ore_" + name)));
        }
        if (!metal.isVanillaMetal()) {
            ResourceLocation defaultName = ImmersiveEngineering.rl((String)("block/metal/storage_" + name));
            if (metal == EnumMetals.URANIUM) {
                ResourceLocation side = ImmersiveEngineering.rl((String)("block/metal/storage_" + name + "_side"));
                ResourceLocation top = ImmersiveEngineering.rl((String)("block/metal/storage_" + name + "_top"));
                this.cubeBottomTop(this.name((ItemLike)IEBlocks.Metals.STORAGE.get(metal)), side, top, top);
            } else {
                this.cubeAll(this.name((ItemLike)IEBlocks.Metals.STORAGE.get(metal)), defaultName);
            }
        }
        ResourceLocation sheetmetalName = ImmersiveEngineering.rl((String)("block/metal/sheetmetal_" + name));
        this.cubeAll(this.name((ItemLike)IEBlocks.Metals.SHEETMETAL.get(metal)), sheetmetalName);
    }

    private void addItemModels(String texturePrefix, ItemLike ... items) {
        this.addItemModels(texturePrefix, Arrays.asList(items));
    }

    private void addItemModels(String texturePrefix, ResourceLocation parent, ItemLike ... items) {
        this.addItemModels(texturePrefix, parent, Arrays.asList(items));
    }

    private void addItemModels(String texturePrefix, Collection<? extends ItemLike> items) {
        this.addItemModels(texturePrefix, this.mcLoc("item/generated"), items);
    }

    private void addItemModels(String texturePrefix, ResourceLocation parent, Collection<? extends ItemLike> items) {
        for (ItemLike itemLike : items) {
            this.addItemModel(texturePrefix == null ? null : texturePrefix + BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath(), itemLike, parent);
        }
    }

    private void addItemModel(String texture, ItemLike item) {
        this.addItemModel(texture, item, this.mcLoc("item/generated"));
    }

    private void addItemModel(String texture, ItemLike item, ResourceLocation parent) {
        String path = this.name(item);
        Object textureLoc = texture == null ? path : "item/" + texture;
        ((TRSRModelBuilder)this.withExistingParent(path, parent)).texture("layer0", this.modLoc((String)textureLoc));
    }

    private void addLayeredItemModel(Item item, ResourceLocation ... layers) {
        String path = this.name((ItemLike)item);
        TRSRModelBuilder modelBuilder = (TRSRModelBuilder)this.withExistingParent(path, this.mcLoc("item/generated"));
        int layerIdx = 0;
        for (ResourceLocation layer : layers) {
            modelBuilder.texture("layer" + layerIdx++, layer);
        }
    }

    private void addTrimmedArmorModel(ArmorItem item) {
        String path = this.name((ItemLike)item);
        ResourceLocation baseTexture = this.modLoc("item/" + path);
        TRSRModelBuilder modelBuilder = (TRSRModelBuilder)((TRSRModelBuilder)this.withExistingParent(path, this.mcLoc("item/generated"))).texture("layer0", baseTexture);
        for (TrimModelDataAccess trim : ItemModelGeneratorsAccess.getGeneratedTrimModels()) {
            String material = trim.getName();
            String name = path + "_" + material + "_trim";
            ResourceLocation trimTexture = this.mcLoc("trims/items/" + item.getType().getName() + "_trim_" + material);
            this.existingFileHelper.trackGenerated(trimTexture, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE);
            TRSRModelBuilder trimModel = (TRSRModelBuilder)((TRSRModelBuilder)((TRSRModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", baseTexture)).texture("layer1", trimTexture);
            modelBuilder.override((ModelFile)trimModel, ResourceLocation.withDefaultNamespace((String)"trim_type"), trim.getItemModelIndex());
        }
    }
}

