/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class MineralVein {
    private final ColumnPos pos;
    private final ResourceLocation mineralName;
    @Nullable
    private MineralMix mineral;
    private final int radius;
    private int depletion;

    public MineralVein(ColumnPos pos, ResourceLocation mineral, int radius) {
        this.pos = pos;
        this.mineralName = mineral;
        this.radius = radius;
    }

    public ColumnPos getPos() {
        return this.pos;
    }

    @Nullable
    public RecipeHolder<MineralMix> getMineralHolder(Level level) {
        MineralMix mineral = this.getMineral(level);
        return mineral != null ? new RecipeHolder(this.getMineralName(), (Recipe)mineral) : null;
    }

    @Nullable
    public MineralMix getMineral(Level level) {
        if (this.mineral == null) {
            this.mineral = MineralMix.RECIPES.getById(level, this.mineralName);
        }
        return this.mineral;
    }

    public int getRadius() {
        return this.radius;
    }

    public double getFailChance(BlockPos pos) {
        double dX = pos.getX() - this.pos.x();
        double dZ = pos.getZ() - this.pos.z();
        double d = (dX * dX + dZ * dZ) / (double)(this.radius * this.radius);
        return d * d * (-2.0 * d + 3.0);
    }

    public int getDepletion() {
        return this.depletion;
    }

    public void setDepletion(int depletion) {
        this.depletion = depletion;
    }

    public void deplete() {
        if (!this.isDepleted()) {
            ++this.depletion;
            ExcavatorHandler.MARK_SAVE_DATA_DIRTY.get().run();
        }
    }

    public boolean isDepleted() {
        return ExcavatorHandler.mineralVeinYield > 0 && this.getDepletion() >= ExcavatorHandler.mineralVeinYield;
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("x", this.pos.x());
        tag.putInt("z", this.pos.z());
        tag.putString("mineral", this.mineralName.toString());
        tag.putInt("radius", this.radius);
        tag.putInt("depletion", this.depletion);
        return tag;
    }

    @Nullable
    public static MineralVein readFromNBT(CompoundTag tag) {
        try {
            ColumnPos pos = new ColumnPos(tag.getInt("x"), tag.getInt("z"));
            ResourceLocation id = ResourceLocation.parse((String)tag.getString("mineral"));
            int radius = tag.getInt("radius");
            MineralVein info = new MineralVein(pos, id, radius);
            info.depletion = tag.getInt("depletion");
            return info;
        }
        catch (ResourceLocationException ex) {
            return null;
        }
    }

    public ResourceLocation getMineralName() {
        return this.mineralName;
    }
}

