/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.client.ieobj.DefaultCallback;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.GlobalTempData;
import blusunrize.immersiveengineering.client.models.obj.SpecificIEOBJModel;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.InvertingVertexBuffer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import malte0811.modelsplitter.model.Group;
import malte0811.modelsplitter.model.MaterialLibrary;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class IEOBJItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public IEOBJItemRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void renderByItem(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext transformType, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderByItem(stack, transformType, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, GlobalTempData.getActiveModel());
    }

    public <T> void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, SpecificIEOBJModel<T> model) {
        ItemCallback callback;
        IEOBJCallback<T> baseCallback = model.getCallback();
        if (baseCallback instanceof ItemCallback) {
            ItemCallback itemCB = (ItemCallback)baseCallback;
            callback = itemCB;
        } else {
            callback = DefaultCallback.cast();
        }
        float partialTicks = ClientUtils.mc().getTimer().getGameTimeDeltaTicks();
        HashSet<String> visible = new HashSet<String>();
        for (String g : model.getGroups().keySet()) {
            if (!callback.shouldRenderGroup(model.getKey(), g, null)) continue;
            visible.add(g);
        }
        LivingEntity entity = GlobalTempData.getActiveHolder();
        Vector3f baseTransformScale = model.getBaseTransforms((ItemDisplayContext)transformType).scale;
        if (baseTransformScale.x() * baseTransformScale.y() * baseTransformScale.z() < 0.0f) {
            MultiBufferSource oldBufferIn = bufferIn;
            bufferIn = type -> new InvertingVertexBuffer(4, oldBufferIn.getBuffer(type));
        }
        for (List<String> groups : callback.getSpecialGroups(stack, transformType, entity)) {
            Transformation mat = callback.getTransformForGroups(stack, groups, transformType, entity, partialTicks);
            matrixStackIn.pushTransformation(mat);
            this.renderQuadsForGroups(groups, model, callback, stack, matrixStackIn, bufferIn, visible, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
        }
        this.renderQuadsForGroups(List.copyOf(visible), model, callback, stack, matrixStackIn, bufferIn, visible, combinedLightIn, combinedOverlayIn);
    }

    private <T> void renderQuadsForGroups(List<String> groups, SpecificIEOBJModel<T> model, ItemCallback<T> callback, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, Set<String> visible, int light, int overlay) {
        ArrayList<SpecificIEOBJModel.ShadedQuads> quadsByLayer = new ArrayList<SpecificIEOBJModel.ShadedQuads>();
        for (String groupName : groups) {
            Group<MaterialLibrary.OBJMaterial> group = model.getGroups().get(groupName);
            if (visible.contains(groupName) && callback.shouldRenderGroup(model.getKey(), groupName, null)) {
                quadsByLayer.addAll(model.addQuadsForGroup(groupName, group, true).stream().filter(Objects::nonNull).toList());
            }
            visible.remove(groupName);
        }
        matrix.pushPose();
        for (SpecificIEOBJModel.ShadedQuads quadsForLayer : quadsByLayer) {
            boolean bright = callback.areGroupsFullbright(stack, groups);
            ResourceLocation atlas = InventoryMenu.BLOCK_ATLAS;
            Color4 color = quadsForLayer.layer().getColor();
            List<RenderType> renderTypes = model.getRenderTypes(stack, Minecraft.useFancyGraphics());
            RenderType baseType = bright ? IERenderTypes.getFullbrightTranslucent(atlas) : (quadsForLayer.layer().isTranslucent() || color.a() < 1.0f ? RenderType.entityTranslucent((ResourceLocation)atlas) : (!renderTypes.isEmpty() ? renderTypes.get(0) : RenderType.entityCutoutNoCull((ResourceLocation)atlas)));
            RenderType actualType = quadsForLayer.layer().getRenderType(baseType);
            VertexConsumer builder = buffer.getBuffer(actualType);
            for (BakedQuad quad : quadsForLayer.quadsInLayer()) {
                builder.putBulkData(matrix.last(), quad, color.r(), color.g(), color.b(), color.a(), light, overlay, false);
            }
            matrix.scale(1.0005f, 1.0005f, 1.0005f);
        }
        matrix.popPose();
    }
}

