/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.fluid;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class FluidUtils {
    public static boolean enableFractionDisplay = true;
    private static final Map<Fraction, String> FRACTION_STRINGS = new HashMap<Fraction, String>();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");

    public static Optional<FluidStack> getFluidContained(@Nonnull ItemStack container) {
        if (!container.isEmpty()) {
            return FluidUtil.getFluidHandler((ItemStack)container).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        }
        return Optional.empty();
    }

    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, IFluidHandler.FluidAction doDrain) {
        ItemStack containerCopy = container.copyWithCount(1);
        IFluidHandlerItem handler = (IFluidHandlerItem)containerCopy.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return FluidActionResult.FAILURE;
        }
        FluidStack simulatedMoved = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)handler, (int)maxAmount, (boolean)false);
        if (simulatedMoved.isEmpty()) {
            return FluidActionResult.FAILURE;
        }
        handler.drain(simulatedMoved, IFluidHandler.FluidAction.EXECUTE);
        fluidDestination.fill(simulatedMoved, doDrain);
        return new FluidActionResult(handler.getContainer());
    }

    public static boolean multiblockFluidOutput(@Nullable IFluidHandler output, FluidTank tank, int slotIn, int slotOut, @Nullable IItemHandlerModifiable inv) {
        boolean updateTile = false;
        if (tank.getFluidAmount() > 0) {
            int accepted;
            if (slotIn >= 0 && slotOut >= 0 && inv != null) {
                updateTile = FluidUtils.fillFluidContainer((IFluidHandler)tank, slotIn, slotOut, inv);
            }
            FluidStack out = tank.getFluid().copyWithAmount(Math.min(tank.getFluidAmount(), 1000));
            if (output != null && (accepted = output.fill(out, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                tank.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return updateTile;
    }

    public static boolean fillFluidContainer(IFluidHandler handler, int slotIn, int slotOut, IItemHandlerModifiable inv) {
        ItemStack filledContainer = FluidUtils.fillFluidContainer(handler, inv.getStackInSlot(slotIn), inv.getStackInSlot(slotOut), null);
        if (!filledContainer.isEmpty()) {
            if (inv.getStackInSlot(slotIn).getCount() == 1 && !FluidUtils.isFluidContainerFull(filledContainer)) {
                inv.setStackInSlot(slotIn, filledContainer.copy());
            } else {
                if (!inv.getStackInSlot(slotOut).isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)filledContainer, (ItemStack)inv.getStackInSlot(slotOut))) {
                    inv.getStackInSlot(slotOut).grow(filledContainer.getCount());
                } else {
                    inv.setStackInSlot(slotOut, filledContainer);
                }
                inv.getStackInSlot(slotIn).shrink(1);
                if (inv.getStackInSlot(slotIn).getCount() <= 0) {
                    inv.setStackInSlot(slotIn, ItemStack.EMPTY);
                }
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean fillFluidContainer(IFluidHandler handler, int slotIn, int slotOut, IntFunction<ItemStack> invGet, BiConsumer<Integer, ItemStack> invSet) {
        ItemStack filledContainer = FluidUtils.fillFluidContainer(handler, invGet.apply(slotIn), invGet.apply(slotOut), null);
        if (!filledContainer.isEmpty()) {
            if (invGet.apply(slotIn).getCount() == 1 && !FluidUtils.isFluidContainerFull(filledContainer)) {
                invSet.accept(slotIn, filledContainer.copy());
            } else {
                if (!invGet.apply(slotOut).isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)filledContainer, (ItemStack)invGet.apply(slotOut))) {
                    invGet.apply(slotOut).grow(filledContainer.getCount());
                } else {
                    invSet.accept(slotOut, filledContainer);
                }
                invGet.apply(slotIn).shrink(1);
                if (invGet.apply(slotIn).getCount() <= 0) {
                    invSet.accept(slotIn, ItemStack.EMPTY);
                }
            }
            return true;
        }
        return false;
    }

    public static ItemStack fillFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut, @Nullable Player player) {
        if (containerIn == null || containerIn.isEmpty()) {
            return ItemStack.EMPTY;
        }
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)false);
        if (result.isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)containerOut, (ItemStack)full)) {
                if (!containerOut.isEmpty() && containerOut.getCount() + full.getCount() > containerOut.getMaxStackSize()) {
                    return ItemStack.EMPTY;
                }
                result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.EMPTY;
    }

    public static boolean isFluidContainerFull(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            for (int t = 0; t < handler.getTanks(); ++t) {
                if (handler.getFluidInTank(t).getAmount() >= handler.getTankCapacity(t)) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, final IFluidHandler handler) {
        MutableObject lastNonSimulated = new MutableObject();
        MutableBoolean isInsert = new MutableBoolean();
        WrapperFluidHandler simulationWrapper = new WrapperFluidHandler(handler, (Mutable)lastNonSimulated, isInsert){
            final /* synthetic */ Mutable val$lastNonSimulated;
            final /* synthetic */ MutableBoolean val$isInsert;
            {
                this.val$lastNonSimulated = mutable;
                this.val$isInsert = mutableBoolean;
                super(handler2);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                int result = handler.fill(resource, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$lastNonSimulated.setValue((Object)resource.copyWithAmount(result));
                    this.val$isInsert.setTrue();
                }
                return result;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                FluidStack result = handler.drain(resource, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$isInsert.setFalse();
                    this.val$lastNonSimulated.setValue((Object)result.copy());
                }
                return result;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                FluidStack result = handler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$isInsert.setFalse();
                    this.val$lastNonSimulated.setValue((Object)result.copy());
                }
                return result;
            }
        };
        boolean success = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)simulationWrapper);
        if (success) {
            if (isInsert.booleanValue()) {
                handler.fill((FluidStack)lastNonSimulated.getValue(), IFluidHandler.FluidAction.EXECUTE);
            } else {
                handler.drain((FluidStack)lastNonSimulated.getValue(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return success;
    }

    public static String getBucketFraction(int amount) {
        Object ret = "";
        if (amount > 1000) {
            ret = (String)ret + amount / 1000;
            amount %= 1000;
        }
        if (amount > 0) {
            Fraction key = Fraction.getReducedFraction((int)amount, (int)1000);
            if (enableFractionDisplay && FRACTION_STRINGS.containsKey(key)) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : " ") + FRACTION_STRINGS.get(key);
            } else {
                double decimal = (double)amount / 1000.0;
                String decimalString = DECIMAL_FORMAT.format(decimal);
                ret = !((String)ret).isEmpty() ? (String)ret + decimalString.substring(1) : decimalString;
            }
        }
        return ret;
    }

    static {
        FRACTION_STRINGS.put(Fraction.ONE_HALF, "\u00bd");
        FRACTION_STRINGS.put(Fraction.ONE_QUARTER, "\u00bc");
        FRACTION_STRINGS.put(Fraction.THREE_QUARTERS, "\u00be");
        FRACTION_STRINGS.put(Fraction.ONE_THIRD, "\u2153");
        FRACTION_STRINGS.put(Fraction.TWO_THIRDS, "\u2154");
        FRACTION_STRINGS.put(Fraction.ONE_FIFTH, "\u2155");
        FRACTION_STRINGS.put(Fraction.TWO_FIFTHS, "\u2156");
        FRACTION_STRINGS.put(Fraction.THREE_FIFTHS, "\u2157");
        FRACTION_STRINGS.put(Fraction.FOUR_FIFTHS, "\u2158");
        FRACTION_STRINGS.put(Fraction.getFraction((int)1, (int)8), "\u215b");
        FRACTION_STRINGS.put(Fraction.getFraction((int)3, (int)8), "\u215c");
        FRACTION_STRINGS.put(Fraction.getFraction((int)1, (int)9), "\u2151");
        FRACTION_STRINGS.put(Fraction.getFraction((int)1, (int)10), "\u2152");
    }

    public static abstract class WrapperFluidHandler
    implements IFluidHandler {
        private final IFluidHandler handler;

        protected WrapperFluidHandler(IFluidHandler handler) {
            this.handler = handler;
        }

        public int getTanks() {
            return this.handler.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.handler.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.handler.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.handler.isFluidValid(tank, stack);
        }
    }
}

