/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.blockstates;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEStairsBlock;
import blusunrize.immersiveengineering.common.blocks.IEWallBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.data.DataGenUtils;
import blusunrize.immersiveengineering.data.models.IEOBJBuilder;
import blusunrize.immersiveengineering.data.models.MirroredModelBuilder;
import blusunrize.immersiveengineering.data.models.ModelProviderUtils;
import blusunrize.immersiveengineering.data.models.NongeneratedModels;
import blusunrize.immersiveengineering.data.models.SplitModelBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.loaders.ObjModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class ExtendedBlockstateProvider
extends BlockStateProvider {
    protected static final List<Vec3i> COLUMN_THREE = ImmutableList.of((Object)BlockPos.ZERO, (Object)BlockPos.ZERO.above(), (Object)BlockPos.ZERO.above(2));
    protected static final Map<ResourceLocation, String> generatedParticleTextures = new HashMap<ResourceLocation, String>();
    protected final ExistingFileHelper existingFileHelper;
    protected final NongeneratedModels innerModels;

    public ExtendedBlockstateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "immersiveengineering", exFileHelper);
        this.existingFileHelper = exFileHelper;
        this.innerModels = new NongeneratedModels(output, this.existingFileHelper);
    }

    protected String name(Supplier<? extends Block> b) {
        return this.name(b.get());
    }

    protected String name(Block b) {
        return BuiltInRegistries.BLOCK.getKey((Object)b).getPath();
    }

    public void simpleBlockAndItem(Supplier<? extends Block> b, ModelFile model) {
        this.simpleBlockAndItem(b, new ConfiguredModel(model));
    }

    protected void simpleBlockAndItem(Supplier<? extends Block> b, ConfiguredModel model) {
        this.simpleBlock(b.get(), new ConfiguredModel[]{model});
        this.itemModel(b, model.model);
    }

    public void multiBlockAndItem(Supplier<? extends Block> b, ModelFile ... models) {
        this.simpleBlock(b.get(), (ConfiguredModel[])Stream.of(models).map(ConfiguredModel::new).toArray(ConfiguredModel[]::new));
        this.itemModel(b, new ConfiguredModel((ModelFile)models[0]).model);
    }

    protected void cubeSideVertical(Supplier<? extends Block> b, ResourceLocation side, ResourceLocation vertical) {
        this.simpleBlockAndItem(b, (ModelFile)this.models().cubeBottomTop(this.name(b), side, vertical, vertical));
    }

    protected void cubeAll(Supplier<? extends Block> b, ResourceLocation texture) {
        this.cubeAll(b, texture, null);
    }

    protected void cubeAll(Supplier<? extends Block> b, ResourceLocation texture, @Nullable RenderType layer) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(this.name(b), texture);
        this.setRenderType(layer, new ModelBuilder[]{model});
        this.simpleBlockAndItem(b, (ModelFile)model);
    }

    protected void multiCubeAll(Supplier<? extends Block> b, ResourceLocation ... textures) {
        this.multiCubeAll(b, (RenderType)null, textures);
    }

    protected void multiCubeAll(Supplier<? extends Block> b, @Nullable RenderType layer, ResourceLocation ... textures) {
        BlockModelBuilder[] models = new BlockModelBuilder[textures.length];
        for (int i = 0; i < textures.length; ++i) {
            models[i] = (BlockModelBuilder)this.models().cubeAll(this.name(b) + i, textures[i]);
            this.setRenderType(layer, new ModelBuilder[]{models[i]});
        }
        this.multiBlockAndItem(b, (ModelFile[])models);
    }

    protected void multiEightCubeAll(Supplier<? extends Block> b, ResourceLocation texture) {
        ResourceLocation[] textures = new ResourceLocation[8];
        for (int i = 0; i < 8; ++i) {
            textures[i] = texture.withSuffix(Integer.toString(i));
        }
        this.multiCubeAll(b, textures);
    }

    protected void scaffold(Supplier<? extends Block> b, ResourceLocation others, ResourceLocation top) {
        this.simpleBlockAndItem(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(b), this.modLoc("block/ie_scaffolding"))).texture("side", others)).texture("bottom", others)).texture("top", top)).renderType(ModelProviderUtils.getName(RenderType.cutout())));
    }

    protected void slabFor(Supplier<? extends Block> b, ResourceLocation texture) {
        this.slabFor(b, texture, null);
    }

    protected void slabFor(Supplier<? extends Block> b, ResourceLocation texture, @Nullable RenderType layer) {
        this.slabFor(b, texture, texture, texture, layer);
    }

    protected void slabFor(Supplier<? extends Block> b, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        this.slabFor(b, side, top, bottom, null);
    }

    protected void slabFor(Supplier<? extends Block> full, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable RenderType layer) {
        SlabBlock b = (SlabBlock)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(BuiltInRegistries.BLOCK.getKey((Object)full.get()))).get();
        ModelBuilder mainModel = this.models().slab(this.name((Block)b) + "_bottom", side, bottom, top);
        ModelBuilder topModel = this.models().slabTop(this.name((Block)b) + "_top", side, bottom, top);
        ModelBuilder doubleModel = this.models().cubeBottomTop(this.name((Block)b) + "_double", side, bottom, top);
        this.setRenderType(layer, mainModel, topModel, doubleModel);
        this.slabBlock(b, (ModelFile)mainModel, (ModelFile)topModel, (ModelFile)doubleModel);
        this.itemModel(() -> b, (ModelFile)mainModel);
    }

    protected void slabForMultiEightAll(Supplier<? extends Block> b, ResourceLocation texture) {
        ResourceLocation[] textures = new ResourceLocation[8];
        for (int i = 0; i < 8; ++i) {
            textures[i] = texture.withSuffix(Integer.toString(i));
        }
        this.slabForMultiAll(b, textures);
    }

    protected void slabForMultiAll(Supplier<? extends Block> b, ResourceLocation ... textures) {
        this.slabForMultiAll(b, (RenderType)null, textures);
    }

    protected void slabForMultiAll(Supplier<? extends Block> full, @Nullable RenderType layer, ResourceLocation ... textures) {
        SlabBlock b = (SlabBlock)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(BuiltInRegistries.BLOCK.getKey((Object)full.get()))).get();
        ModelBuilder[] mainModels = new ModelBuilder[textures.length];
        ModelBuilder[] topModels = new ModelBuilder[textures.length];
        ModelBuilder[] doubleModels = new ModelBuilder[textures.length];
        for (int i = 0; i < textures.length; ++i) {
            mainModels[i] = this.models().slab(this.name((Block)b) + i + "_bottom", textures[i], textures[i], textures[i]);
            topModels[i] = this.models().slabTop(this.name((Block)b) + i + "_top", textures[i], textures[i], textures[i]);
            doubleModels[i] = this.models().cubeAll(this.name((Block)b) + i + "_double", textures[i]);
            this.setRenderType(layer, mainModels[i], topModels[i], doubleModels[i]);
        }
        this.slabBlock(b, (ModelFile[])mainModels, (ModelFile[])topModels, (ModelFile[])doubleModels);
        this.itemModel(() -> b, (ModelFile)mainModels[0]);
    }

    public void slabBlock(SlabBlock block, ModelFile[] bottom, ModelFile[] top, ModelFile[] doubleslab) {
        this.getVariantBuilder((Block)block).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM).addModels((ConfiguredModel[])Stream.of(bottom).map(ConfiguredModel::new).toArray(ConfiguredModel[]::new)).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP).addModels((ConfiguredModel[])Stream.of(top).map(ConfiguredModel::new).toArray(ConfiguredModel[]::new)).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE).addModels((ConfiguredModel[])Stream.of(doubleslab).map(ConfiguredModel::new).toArray(ConfiguredModel[]::new));
    }

    protected void stairsFor(Supplier<? extends Block> b, ResourceLocation texture) {
        this.stairsFor(b, texture, texture, texture, null);
    }

    protected void stairsFor(Supplier<? extends Block> full, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable RenderType layer) {
        IEStairsBlock b = (IEStairsBlock)((IEBlocks.BlockEntry)IEBlocks.TO_STAIRS.get(BuiltInRegistries.BLOCK.getKey((Object)full.get()))).get();
        String baseName = this.name((Block)b);
        ModelBuilder stairs = this.models().stairs(baseName, side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.setRenderType(layer, stairs, stairsInner, stairsOuter);
        this.stairsBlock((StairBlock)b, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.itemModel(() -> b, (ModelFile)stairs);
    }

    protected void stairsForMultiEightAll(Supplier<? extends Block> b, ResourceLocation texture) {
        ResourceLocation[] textures = new ResourceLocation[8];
        for (int i = 0; i < 8; ++i) {
            textures[i] = texture.withSuffix(Integer.toString(i));
        }
        this.stairsForMultiAll(b, textures);
    }

    protected void stairsForMultiAll(Supplier<? extends Block> b, ResourceLocation ... textures) {
        this.stairsForMultiAll(b, (RenderType)null, textures);
    }

    protected void stairsForMultiAll(Supplier<? extends Block> full, @Nullable RenderType layer, ResourceLocation ... textures) {
        IEStairsBlock b = (IEStairsBlock)((IEBlocks.BlockEntry)IEBlocks.TO_STAIRS.get(BuiltInRegistries.BLOCK.getKey((Object)full.get()))).get();
        ModelBuilder[] stairs = new ModelBuilder[textures.length];
        ModelBuilder[] stairsInner = new ModelBuilder[textures.length];
        ModelBuilder[] stairsOuter = new ModelBuilder[textures.length];
        for (int i = 0; i < textures.length; ++i) {
            stairs[i] = this.models().stairs(this.name((Block)b) + i, textures[i], textures[i], textures[i]);
            stairsInner[i] = this.models().stairsInner(this.name((Block)b) + i + "_inner", textures[i], textures[i], textures[i]);
            stairsOuter[i] = this.models().stairsOuter(this.name((Block)b) + i + "_outer", textures[i], textures[i], textures[i]);
            this.setRenderType(layer, stairs[i], stairsInner[i], stairsOuter[i]);
        }
        this.stairsBlock((StairBlock)b, (ModelFile[])stairs, (ModelFile[])stairsInner, (ModelFile[])stairsOuter);
        this.itemModel(() -> b, (ModelFile)stairs[0]);
    }

    public void stairsBlock(StairBlock block, ModelFile[] stairs, ModelFile[] stairsInner, ModelFile[] stairsOuter) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            boolean uvlock;
            Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
            Half half = (Half)state.getValue((Property)StairBlock.HALF);
            StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
            int yRot = (int)facing.getClockWise().toYRot();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean bl = uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            ModelFile[] files = shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter);
            ConfiguredModel[] models = new ConfiguredModel[stairs.length];
            for (int i = 0; i < stairs.length; ++i) {
                models[i] = new ConfiguredModel(files[i], half == Half.BOTTOM ? 0 : 180, yRot, uvlock);
            }
            return models;
        }, new Property[]{StairBlock.WATERLOGGED});
    }

    protected void wallForSingle(Supplier<? extends Block> full, ResourceLocation bottomTexture, ResourceLocation sideTexture, ResourceLocation topTexture) {
        IEWallBlock b = (IEWallBlock)((IEBlocks.BlockEntry)IEBlocks.TO_WALL.get(BuiltInRegistries.BLOCK.getKey((Object)full.get()))).get();
        this.wallBlock((WallBlock)b, (ModelFile)this.wallModelTopped(this.name((Block)b) + "_post", "wall_post_topped", bottomTexture, sideTexture, topTexture), (ModelFile)this.wallModelTopped(this.name((Block)b) + "_side", "wall_side_topped", bottomTexture, sideTexture, topTexture), (ModelFile)this.wallModelTopped(this.name((Block)b) + "_side_tall", "wall_side_tall_topped", bottomTexture, sideTexture, topTexture));
        this.itemModel(() -> b, (ModelFile)this.wallModelToppedInventory(this.name((Block)b), bottomTexture, sideTexture, topTexture));
    }

    protected void wallForMultiEight(Supplier<? extends Block> b, ResourceLocation bottomTexture, ResourceLocation sideTexture, ResourceLocation topTexture) {
        ResourceLocation[] bottomTextures = new ResourceLocation[8];
        ResourceLocation[] sideTextures = new ResourceLocation[8];
        ResourceLocation[] topTextures = new ResourceLocation[8];
        for (int i = 0; i < 8; ++i) {
            bottomTextures[i] = bottomTexture.withSuffix(Integer.toString(i));
            sideTextures[i] = sideTexture.withSuffix(Integer.toString(i));
            topTextures[i] = topTexture.withSuffix(Integer.toString(i));
        }
        this.wallForMultiMany(b, bottomTextures, sideTextures, topTextures);
    }

    protected void wallForMultiMany(Supplier<? extends Block> b, ResourceLocation[] bottomTextures, ResourceLocation[] sideTextures, ResourceLocation[] topTextures) {
        this.wallForMultiMany(b, null, bottomTextures, sideTextures, topTextures);
    }

    protected void wallForMultiMany(Supplier<? extends Block> full, @Nullable RenderType layer, ResourceLocation[] bottomTextures, ResourceLocation[] sideTextures, ResourceLocation[] topTextures) {
        IEWallBlock b = (IEWallBlock)((IEBlocks.BlockEntry)IEBlocks.TO_WALL.get(BuiltInRegistries.BLOCK.getKey((Object)full.get()))).get();
        ModelBuilder[] wallPost = new ModelBuilder[bottomTextures.length];
        ModelBuilder[] wallSide = new ModelBuilder[bottomTextures.length];
        ModelBuilder[] wallSideTall = new ModelBuilder[bottomTextures.length];
        for (int i = 0; i < bottomTextures.length; ++i) {
            wallPost[i] = this.wallModelTopped(this.name((Block)b) + i + "_post", "wall_post_topped", bottomTextures[i], sideTextures[i], topTextures[i]);
            wallSide[i] = this.wallModelTopped(this.name((Block)b) + i + "_side", "wall_side_topped", bottomTextures[i], sideTextures[i], topTextures[i]);
            wallSideTall[i] = this.wallModelTopped(this.name((Block)b) + i + "_side_tall", "wall_side_tall_topped", bottomTextures[i], sideTextures[i], topTextures[i]);
            this.setRenderType(layer, wallPost[i], wallSide[i], wallSideTall[i]);
        }
        this.wallBlock((WallBlock)b, (ModelFile[])wallPost, (ModelFile[])wallSide, (ModelFile[])wallSideTall);
        this.itemModel(() -> b, (ModelFile)this.wallModelToppedInventory(this.name((Block)b), bottomTextures[0], sideTextures[0], topTextures[0]));
    }

    public void wallBlock(WallBlock block, ModelFile[] posts, ModelFile[] sides, ModelFile[] sidesTall) {
        for (int i = 0; i < posts.length; ++i) {
            ModelFile side = sides[i];
            ModelFile sideTall = sidesTall[i];
            MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile(posts[i]).addModel()).condition((Property)WallBlock.UP, (Comparable[])new Boolean[]{true}).end();
            WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).getAxis().isHorizontal()).forEach(e -> {
                this.wallSidePart(builder, side, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.LOW);
                this.wallSidePart(builder, sideTall, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.TALL);
            });
        }
    }

    private void wallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, Map.Entry<Direction, Property<WallSide>> entry, WallSide height) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model).rotationY(((int)entry.getKey().toYRot() + 180) % 360).uvLock(true).addModel()).condition(entry.getValue(), (Comparable[])new WallSide[]{height});
    }

    protected void setRenderType(@Nullable RenderType type, ModelBuilder<?> ... builders) {
        if (type != null) {
            String typeName = ModelProviderUtils.getName(type);
            for (ModelBuilder<?> model : builders) {
                model.renderType(typeName);
            }
        }
    }

    protected ResourceLocation addModelsPrefix(ResourceLocation in) {
        return in.withPath("models/" + in.getPath());
    }

    protected void itemModel(Supplier<? extends Block> block, ModelFile model) {
        ((ItemModelBuilder)this.itemModels().getBuilder(this.name(block))).parent(model);
    }

    protected BlockModelBuilder wallModelTopped(String name, String type, ResourceLocation bottom, ResourceLocation side, ResourceLocation top) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, ImmersiveEngineering.rl((String)("block/" + type)))).texture("wall_bottom", bottom)).texture("wall_side", side)).texture("wall_top", top);
    }

    protected BlockModelBuilder wallModelToppedInventory(String name, ResourceLocation bottom, ResourceLocation side, ResourceLocation top) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, ImmersiveEngineering.rl((String)"block/wall_inventory_topped"))).texture("wall_bottom", bottom)).texture("wall_side", side)).texture("wall_top", top);
    }

    protected NongeneratedModels.NongeneratedModel innerObj(String loc, @Nullable RenderType layer) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj"));
        NongeneratedModels.NongeneratedModel result = this.obj(loc.substring(0, loc.length() - 4), this.modLoc(loc), this.innerModels);
        this.setRenderType(layer, result);
        return result;
    }

    protected NongeneratedModels.NongeneratedModel innerObj(String loc) {
        return this.innerObj(loc, null);
    }

    protected BlockModelBuilder obj(String loc) {
        return this.obj(loc, (RenderType)null);
    }

    protected BlockModelBuilder obj(String loc, @Nullable RenderType layer) {
        BlockModelBuilder model = (BlockModelBuilder)this.obj(loc, (ModelProvider)this.models());
        this.setRenderType(layer, new ModelBuilder[]{model});
        return model;
    }

    protected <T extends ModelBuilder<T>> T obj(String loc, ModelProvider<T> modelProvider) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj"));
        return this.obj(loc.substring(0, loc.length() - 4), this.modLoc(loc), modelProvider);
    }

    protected <T extends ModelBuilder<T>> T obj(String name, ResourceLocation model, ModelProvider<T> provider) {
        return this.obj(name, model, (Map<String, ResourceLocation>)ImmutableMap.of(), provider);
    }

    protected <T extends ModelBuilder<T>> T obj(String name, ResourceLocation model, Map<String, ResourceLocation> textures, ModelProvider<T> provider) {
        return (T)this.obj(provider.withExistingParent(name, this.mcLoc("block")), model, textures);
    }

    protected <T extends ModelBuilder<T>> T obj(T base, ResourceLocation model, Map<String, ResourceLocation> textures) {
        this.assertModelExists(model);
        ModelBuilder ret = ((ObjModelBuilder)base.customLoader(ObjModelBuilder::begin)).automaticCulling(false).modelLocation(this.addModelsPrefix(model)).flipV(true).end();
        String particleTex = DataGenUtils.getTextureFromObj(model, this.existingFileHelper);
        if (particleTex.charAt(0) == '#') {
            particleTex = textures.get(particleTex.substring(1)).toString();
        }
        ret.texture("particle", particleTex);
        generatedParticleTextures.put(ret.getLocation(), particleTex);
        for (Map.Entry<String, ResourceLocation> e : textures.entrySet()) {
            ret.texture(e.getKey(), e.getValue());
        }
        return (T)ret;
    }

    protected BlockModelBuilder splitModel(String name, NongeneratedModels.NongeneratedModel model, List<Vec3i> parts, boolean dynamic) {
        BlockModelBuilder result = (BlockModelBuilder)((SplitModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block"))).customLoader(SplitModelBuilder::begin)).innerModel(model).parts(parts).dynamic(dynamic).end();
        this.addParticleTextureFrom(result, (ModelFile)model);
        return result;
    }

    protected ModelFile split(NongeneratedModels.NongeneratedModel baseModel, List<Vec3i> parts, boolean dynamic) {
        return this.splitModel(baseModel.getLocation().getPath() + "_split", baseModel, parts, dynamic);
    }

    protected ModelFile split(NongeneratedModels.NongeneratedModel baseModel, List<Vec3i> parts) {
        return this.split(baseModel, parts, false);
    }

    protected ModelFile splitDynamic(NongeneratedModels.NongeneratedModel baseModel, List<Vec3i> parts) {
        return this.split(baseModel, parts, true);
    }

    protected void addParticleTextureFrom(BlockModelBuilder result, ModelFile model) {
        String particles = generatedParticleTextures.get(model.getLocation());
        if (particles != null) {
            result.texture("particle", particles);
            generatedParticleTextures.put(result.getLocation(), particles);
        }
    }

    protected ConfiguredModel emptyWithParticles(String name, String particleTexture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/ie_empty"))).texture("particle", particleTexture);
        generatedParticleTextures.put(this.modLoc(name), particleTexture);
        return new ConfiguredModel((ModelFile)model);
    }

    public void assertModelExists(ResourceLocation name) {
        String suffix = name.getPath().contains(".") ? "" : ".json";
        Preconditions.checkState((boolean)this.existingFileHelper.exists(name, PackType.CLIENT_RESOURCES, suffix, "models"), (Object)("Model \"" + String.valueOf(name) + "\" does not exist"));
    }

    protected IEOBJBuilder<BlockModelBuilder> ieObjBuilder(String loc) {
        return this.ieObjBuilder(ExtendedBlockstateProvider.getAutoNameIEOBJ(loc), this.modLoc(loc));
    }

    protected IEOBJBuilder<BlockModelBuilder> ieObjBuilder(String name, ResourceLocation model) {
        return this.ieObjBuilder(name, model, (ModelProvider)this.models());
    }

    protected <T extends ModelBuilder<T>> IEOBJBuilder<T> ieObjBuilder(String loc, ModelProvider<T> modelProvider) {
        return this.ieObjBuilder(ExtendedBlockstateProvider.getAutoNameIEOBJ(loc), this.modLoc(loc), modelProvider);
    }

    private static String getAutoNameIEOBJ(String loc) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj.ie"));
        return loc.substring(0, loc.length() - 7);
    }

    protected <T extends ModelBuilder<T>> IEOBJBuilder<T> ieObjBuilder(String name, ResourceLocation model, ModelProvider<T> modelProvider) {
        String particle = DataGenUtils.getTextureFromObj(model, this.existingFileHelper);
        generatedParticleTextures.put(this.modLoc(name), particle);
        return ((IEOBJBuilder)modelProvider.withExistingParent(name, this.mcLoc("block")).texture("particle", particle).customLoader(IEOBJBuilder::begin)).modelLocation(this.addModelsPrefix(model));
    }

    protected <T extends ModelBuilder<T>> T mirror(NongeneratedModels.NongeneratedModel inner, ModelProvider<T> provider) {
        return (T)((MirroredModelBuilder)provider.getBuilder(inner.getLocation().getPath() + "_mirrored").customLoader(MirroredModelBuilder::begin)).inner(inner).end();
    }

    protected int getAngle(Direction dir, int offset) {
        return (int)((dir.toYRot() + (float)offset) % 360.0f);
    }

    protected void createHorizontalRotatedBlock(Supplier<? extends Block> block, ModelFile model) {
        this.createHorizontalRotatedBlock(block, (VariantBlockStateBuilder.PartialBlockstate $) -> model, List.of());
    }

    protected void createHorizontalRotatedBlock(Supplier<? extends Block> block, ModelFile model, int offsetRotY) {
        this.createRotatedBlock(block, (VariantBlockStateBuilder.PartialBlockstate $) -> model, (Property<Direction>)IEProperties.FACING_HORIZONTAL, List.of(), 0, offsetRotY);
    }

    protected void createHorizontalRotatedBlock(Supplier<? extends Block> block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, List<Property<?>> additionalProps) {
        this.createRotatedBlock(block, model, (Property<Direction>)IEProperties.FACING_HORIZONTAL, additionalProps, 0, 180);
    }

    protected void createAllRotatedBlock(Supplier<? extends Block> block, ModelFile model) {
        this.createAllRotatedBlock(block, $ -> model, List.of());
    }

    protected void createAllRotatedBlock(Supplier<? extends Block> block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, List<Property<?>> additionalProps) {
        this.createRotatedBlock(block, model, (Property<Direction>)IEProperties.FACING_ALL, additionalProps, 90, 0);
    }

    protected void createRotatedBlock(Supplier<? extends Block> block, ModelFile model, Property<Direction> facing, List<Property<?>> additionalProps, int offsetRotX, int offsetRotY) {
        this.createRotatedBlock(block, (VariantBlockStateBuilder.PartialBlockstate $) -> model, facing, additionalProps, offsetRotX, offsetRotY);
    }

    protected void createRotatedBlock(Supplier<? extends Block> block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, Property<Direction> facing, List<Property<?>> additionalProps, int offsetRotX, int offsetRotY) {
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(block.get());
        ExtendedBlockstateProvider.forEachState(stateBuilder.partialState(), additionalProps, state -> {
            ModelFile modelLoc = (ModelFile)model.apply((VariantBlockStateBuilder.PartialBlockstate)state);
            for (Direction d : facing.getPossibleValues()) {
                int y;
                int x;
                switch (d) {
                    case UP: {
                        x = 90;
                        y = 0;
                        break;
                    }
                    case DOWN: {
                        x = -90;
                        y = 0;
                        break;
                    }
                    default: {
                        y = this.getAngle(d, offsetRotY);
                        x = 0;
                    }
                }
                state.with(facing, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel(modelLoc, x + offsetRotX, y, false)});
            }
        });
    }

    protected static String getName(RenderStateShard state) {
        try {
            Field f = RenderStateShard.class.getDeclaredField("name");
            f.setAccessible(true);
            return (String)f.get(state);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Comparable<T>> void forEach(VariantBlockStateBuilder.PartialBlockstate base, Property<T> prop, List<Property<?>> remaining, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        for (Comparable value : prop.getPossibleValues()) {
            ExtendedBlockstateProvider.forEachState(base, remaining, map -> {
                map = map.with(prop, value);
                out.accept((VariantBlockStateBuilder.PartialBlockstate)map);
            });
        }
    }

    public static void forEachState(VariantBlockStateBuilder.PartialBlockstate base, List<Property<?>> props, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        if (props.size() > 0) {
            List<Property<?>> remaining = props.subList(1, props.size());
            Property<?> main = props.get(0);
            ExtendedBlockstateProvider.forEach(base, main, remaining, out);
        } else {
            out.accept(base);
        }
    }
}

