/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.PlayerUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.common.entities.SkyhookUserData;
import blusunrize.immersiveengineering.common.network.MessageSkyhookSync;
import blusunrize.immersiveengineering.common.register.IEDataAttachments;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEStats;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class SkylineHookEntity
extends Entity {
    public static final double GRAVITY = 10.0;
    private static final double MAX_SPEED = 2.5;
    private static final double LIMIT_SPEED = 0.25;
    public static final double MOVE_SPEED_HOR = 0.25;
    public static final double MOVE_SPEED_VERT = 0.1;
    private Connection connection;
    public ConnectionPoint start;
    public double linePos;
    public double horizontalSpeed;
    private double angle;
    public double friction = 0.99;
    public InteractionHand hand;
    private boolean limitSpeed;
    private float slopeModifier;
    private static final EntityDataAccessor<Float> SLOPE_MODIFIER = SynchedEntityData.defineId(SkylineHookEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final Set<BlockPos> ignoreCollisions = new HashSet<BlockPos>();

    public SkylineHookEntity(EntityType<SkylineHookEntity> type, Level world) {
        super(type, world);
    }

    public SkylineHookEntity(Level world, Connection connection, ConnectionPoint start, double linePos, InteractionHand hand, double horSpeed, boolean limitSpeed, float slopeModifier) {
        this((EntityType<SkylineHookEntity>)((EntityType)IEEntityTypes.SKYLINE_HOOK.get()), world);
        this.hand = hand;
        this.limitSpeed = limitSpeed;
        this.slopeModifier = slopeModifier;
        this.setSlopeModifier(slopeModifier);
        this.setConnectionAndPos(connection, start, linePos, horSpeed);
        Vec3 motion = this.getDeltaMovement();
        float f1 = Mth.sqrt((float)((float)(motion.x * motion.x + motion.z * motion.z)));
        this.setYRot((float)(Math.atan2(motion.z, motion.x) * 180.0 / Math.PI) + 90.0f);
        this.setXRot((float)(Math.atan2(f1, motion.y) * 180.0 / Math.PI) - 90.0f);
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
    }

    public void setConnectionAndPos(Connection c, ConnectionPoint start, double linePos, double speed) {
        this.linePos = linePos;
        this.horizontalSpeed = speed;
        this.connection = c;
        this.start = start;
        Vec3 pos = this.connection.getPoint(this.linePos, start).add(Vec3.atLowerCornerOf((Vec3i)start.position()));
        this.moveTo(pos.x, pos.y, pos.z, this.getYRot(), this.getXRot());
        if (!this.connection.getCatenaryData().isVertical()) {
            this.angle = Math.atan2(this.connection.getCatenaryData().getDeltaZ(), this.connection.getCatenaryData().getDeltaX());
        }
        this.ignoreCollisions.clear();
        LocalWireNetwork net = GlobalWireNetwork.getNetwork(this.level()).getLocalNet(start);
        IImmersiveConnectable iicStart = net.getConnector(start);
        IImmersiveConnectable iicEnd = net.getConnector(c.getOtherEnd(start));
        if (iicStart != null && iicEnd != null) {
            this.ignoreCollisions.addAll(iicStart.getIgnored(iicEnd));
            this.ignoreCollisions.addAll(iicEnd.getIgnored(iicStart));
        }
    }

    private float getSlopeModifier() {
        return ((Float)this.entityData.get(SLOPE_MODIFIER)).floatValue();
    }

    private void setSlopeModifier(float slopeModifier) {
        this.entityData.set(SLOPE_MODIFIER, (Object)Float.valueOf(slopeModifier));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SLOPE_MODIFIER, (Object)Float.valueOf(1.0f));
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public void tick() {
        ServerPlayer serverPlayer;
        double dz;
        double dy;
        double dx;
        int distTrvl;
        double inLineDirection;
        if (this.tickCount == 1 && this.level().isClientSide) {
            ImmersiveEngineering.proxy.startSkyhookSound(this);
        }
        Player player = null;
        List list = this.getPassengers();
        if (!list.isEmpty() && list.get(0) instanceof Player) {
            player = (Player)list.get(0);
        }
        if (this.connection == null || player == null || this.hand != null && player.getItemInHand(this.hand).getItem() != IEItems.Misc.SKYHOOK.asItem()) {
            if (!this.level().isClientSide) {
                this.discard();
            }
            return;
        }
        if (this.tickCount % 5 == 0 && !this.level().isClientSide) {
            this.sendUpdatePacketTo(player);
        }
        PlayerUtils.resetFloatingState((Entity)player);
        boolean moved = false;
        if (this.connection.getCatenaryData().isVertical()) {
            inLineDirection = (double)(-player.zza) * Math.sin(Math.toRadians(player.getXRot())) * Math.signum(this.connection.getCatenaryData().getDeltaY()) * this.getStartSignum();
        } else {
            float forward = player.zza;
            double strafing = player.xxa;
            double playerAngle = Math.toRadians(player.getYRot()) + 1.5707963267948966;
            double angleToLine = playerAngle - this.angle;
            inLineDirection = (Math.cos(angleToLine) * (double)forward + Math.sin(angleToLine) * strafing) * this.getStartSignum();
        }
        if (inLineDirection != 0.0) {
            double slope = this.connection.getSlope(this.linePos, this.start);
            double slopeInDirection = Math.signum(inLineDirection) * slope;
            double speed = 0.1;
            double slopeFactor = 1.0;
            if (!this.connection.getCatenaryData().isVertical()) {
                double lambda = Math.atan(slopeInDirection) / 1.5707963267948966;
                speed = lambda * 0.1 + (1.0 - lambda) * 0.25;
                slopeFactor = 1.0 / (Math.sqrt(1.0 + slope * slope) * (double)this.getSlopeModifier());
            }
            if (slopeInDirection > -0.1) {
                this.horizontalSpeed = (3.0 * this.horizontalSpeed + inLineDirection * speed * slopeFactor) / 4.0;
                moved = true;
            }
        }
        ConnectionPoint switchingAtPos = null;
        if (!moved) {
            double deltaVHor;
            if (this.connection.getCatenaryData().isVertical()) {
                deltaVHor = -10.0 * Math.signum(this.connection.getCatenaryData().getDeltaY() * this.getStartSignum());
            } else {
                double realLinePos = this.connection.transformPosition(this.linePos, this.start);
                double param = (realLinePos * this.getHorizontalLength() - this.connection.getCatenaryData().offsetX()) / this.connection.getCatenaryData().scale();
                double pos = Math.exp(param);
                double neg = 1.0 / pos;
                double cosh = (pos + neg) / 2.0;
                double sinh = (pos - neg) / 2.0;
                double vSquared = this.horizontalSpeed * this.horizontalSpeed * cosh * cosh * 20.0 * 20.0;
                deltaVHor = -sinh / (cosh * cosh) * (10.0 + vSquared / (this.connection.getCatenaryData().scale() * cosh));
                if (this.connection.getEndB().equals(this.start)) {
                    deltaVHor *= -1.0;
                }
            }
            this.horizontalSpeed += deltaVHor / 400.0;
        }
        if (this.limitSpeed) {
            double max;
            double totSpeed = this.getSpeed();
            double d = max = this.limitSpeed ? 0.25 : 2.5;
            if (totSpeed > max) {
                this.horizontalSpeed *= max / totSpeed;
            }
        }
        double horSpeedToUse = this.horizontalSpeed;
        if (this.horizontalSpeed > 0.0) {
            double distToEnd = this.getHorizontalLength() * (1.0 - this.linePos);
            if (this.horizontalSpeed > distToEnd) {
                switchingAtPos = this.connection.getOtherEnd(this.start);
                horSpeedToUse = distToEnd;
            }
        } else {
            double distToStart = -this.getHorizontalLength() * this.linePos;
            if (this.horizontalSpeed < distToStart) {
                switchingAtPos = this.start;
                horSpeedToUse = distToStart;
            }
        }
        this.horizontalSpeed *= this.friction;
        this.linePos += horSpeedToUse / this.getHorizontalLength();
        Vec3 pos = this.connection.getPoint(this.linePos, this.start).add(Vec3.atLowerCornerOf((Vec3i)this.start.position()));
        this.setDeltaMovement(pos.x - this.getX(), pos.z - this.getZ(), pos.y - this.getY());
        if (!this.isValidPosition(pos.x, pos.y, pos.z, (LivingEntity)player)) {
            this.discard();
            return;
        }
        this.setPos(pos.x, pos.y, pos.z);
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        float f1 = Mth.sqrt((float)((float)(motion.x * motion.x + motion.z * motion.z)));
        this.setYRot((float)(Math.atan2(motion.z, motion.x) * 180.0 / Math.PI) + 90.0f);
        this.setXRot((float)(Math.atan2(f1, motion.y) * 180.0 / Math.PI) - 90.0f);
        this.xRotO = this.getXRot() - Mth.wrapDegrees((float)(this.getXRot() - this.xRotO));
        this.yRotO = this.getYRot() - Mth.wrapDegrees((float)(this.getYRot() - this.yRotO));
        this.setXRot(this.xRotO + (this.getXRot() - this.xRotO) * 0.2f);
        this.setYRot(this.yRotO + (this.getYRot() - this.yRotO) * 0.2f);
        if (this.isInWater()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - motion.x * (double)f3, this.getY() - motion.y * (double)f3, this.getZ() - motion.z * (double)f3, motion.x, motion.y, motion.z);
            }
        }
        if ((distTrvl = Math.round(Mth.sqrt((float)((float)((dx = this.getX() - this.xo) * dx + (dy = this.getY() - this.yo) * dy + (dz = this.getZ() - this.zo) * dz))) * 100.0f)) > 0) {
            player.awardStat((ResourceLocation)IEStats.SKYHOOK_DISTANCE.value(), distTrvl);
        }
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).getStats().getValue(Stats.CUSTOM, (Object)((ResourceLocation)IEStats.SKYHOOK_DISTANCE.value())) > 100000) {
            Utils.unlockIEAdvancement(player, "tools/skyhook_distance");
        }
        this.setPos(this.getX(), this.getY(), this.getZ());
        if (switchingAtPos != null) {
            this.switchConnection(switchingAtPos, player, horSpeedToUse);
        }
    }

    private void sendUpdatePacketTo(Player player) {
        if (player instanceof ServerPlayer) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new MessageSkyhookSync(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void switchConnection(ConnectionPoint posForSwitch, Player player, double lastHorSpeed) {
        Optional<Object> line = Optional.empty();
        LocalWireNetwork net = GlobalWireNetwork.getNetwork(this.level()).getLocalNet(posForSwitch);
        Collection<Connection> possible = net.getConnections(posForSwitch);
        if (possible != null) {
            Vec3 look = player.getLookAngle();
            line = possible.stream().filter(c -> !c.equals(this.connection) && !c.isInternal()).max(Comparator.comparingDouble(c -> {
                double factor = posForSwitch.equals(c.getEndA()) ? 1.0 : -1.0;
                return c.getCatenaryData().delta().normalize().dot(look) * factor;
            }));
        }
        if (line.isPresent()) {
            Connection newCon = (Connection)line.get();
            double oldSpeedPerHor = this.getSpeedPerHor(this.connection, posForSwitch, 0.0);
            double newSpeedPerHor = this.getSpeedPerHor(newCon, posForSwitch, 0.0);
            double horConversionFactor = oldSpeedPerHor / newSpeedPerHor;
            this.setConnectionAndPos(newCon, posForSwitch, Math.abs(this.horizontalSpeed - lastHorSpeed) * horConversionFactor, Math.abs(this.horizontalSpeed) * horConversionFactor);
            this.sendUpdatePacketTo(player);
        } else {
            this.discard();
        }
    }

    private double getSpeedPerHor(Connection connection, ConnectionPoint start, double pos) {
        if (connection.getCatenaryData().isVertical()) {
            return 1.0;
        }
        double slope = connection.getSlope(pos, start);
        return Math.sqrt(slope * slope + 1.0) * (double)this.getSlopeModifier();
    }

    public boolean isValidPosition(double x, double y, double z, @Nonnull LivingEntity player) {
        double tolerance = this.connection.getCatenaryData().isVertical() ? 5.0 : 10.0;
        double radius = player.getBbWidth() / 2.0f;
        double height = player.getBbHeight();
        Vec3 offset = this.getPassengerRidingPosition((Entity)player);
        AABB playerBB = new AABB(x - radius, y, z - radius, x + radius, y + height, z + radius).move(offset);
        double playerHeight = playerBB.maxY - playerBB.minY;
        AABB feet = new AABB(playerBB.minX, playerBB.minY, playerBB.minZ, playerBB.maxX, playerBB.minY + 0.05 * playerHeight, playerBB.maxZ);
        List<VoxelShape> shapes = SkylineHelper.getCollisionBoxes((Entity)player, playerBB, this.level(), this.ignoreCollisions);
        double totalCollisionVolume = 0.0;
        double totalCollisionArea = 0.0;
        VoxelShape playerShape = Shapes.create((AABB)playerBB);
        double playerVolume = this.getVolume(playerShape);
        double playerArea = playerVolume / playerHeight;
        VoxelShape feetShape = Shapes.create((AABB)feet);
        for (VoxelShape shape : shapes) {
            VoxelShape intersection = Shapes.joinUnoptimized((VoxelShape)playerShape, (VoxelShape)shape, (BooleanOp)BooleanOp.AND);
            if ((totalCollisionVolume += this.getVolume(intersection)) * tolerance > playerVolume) {
                return false;
            }
            if (this.connection.getCatenaryData().isVertical() || !Shapes.joinIsNotEmpty((VoxelShape)feetShape, (VoxelShape)shape, (BooleanOp)BooleanOp.AND)) continue;
            VoxelShape feetIntersectShape = Shapes.joinUnoptimized((VoxelShape)feetShape, (VoxelShape)shape, (BooleanOp)BooleanOp.AND);
            for (AABB feetIntersect : feetIntersectShape.toAabbs()) {
                totalCollisionArea += (feetIntersect.maxX - feetIntersect.minX) * (feetIntersect.maxZ - feetIntersect.minZ);
            }
            if (!(totalCollisionArea > 0.5 * playerArea)) continue;
            return false;
        }
        return true;
    }

    private double getVolume(VoxelShape shape) {
        return shape.toAabbs().stream().mapToDouble(box -> (box.maxX - box.minX) * (box.maxY - box.minY) * (box.maxZ - box.minZ)).sum();
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        List list = this.getPassengers();
        return list.isEmpty() ? null : (LivingEntity)list.get(0);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean isInvisible() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public Vec3 getPassengerAttachmentPoint(Entity rider, EntityDimensions size, float p_296362_) {
        return new Vec3(0.0, (double)(size.height() - 2.0f), 0.0);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putFloat("slopeModifier", this.slopeModifier);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.slopeModifier = nbt.getFloat("slopeModifier");
        this.setSlopeModifier(this.slopeModifier);
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        this.discard();
        return true;
    }

    public boolean isControlledByLocalInstance() {
        return false;
    }

    private void handleDismount(Entity passenger) {
        ItemStack held;
        Vec3 passengerPosition = this.getPassengerRidingPosition(passenger);
        passenger.teleportTo(passengerPosition.x, passengerPosition.y, passengerPosition.z);
        passenger.setDeltaMovement(this.getDeltaMovement());
        if (this.getDeltaMovement().y < 0.0) {
            passenger.fallDistance = SkylineHelper.fallDistanceFromSpeed(this.getDeltaMovement().y);
            passenger.setOnGround(false);
        }
        ((SkyhookUserData)passenger.getData(IEDataAttachments.SKYHOOK_USER.get())).release();
        if (this.hand != null && passenger instanceof Player && (held = ((Player)passenger).getItemInHand(this.hand)).getItem() == IEItems.Misc.SKYHOOK.asItem()) {
            ((Player)passenger).getCooldowns().addCooldown(IEItems.Misc.SKYHOOK.asItem(), 10);
        }
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (!this.level().isClientSide) {
            ApiUtils.addFutureServerTask(this.level(), () -> this.handleDismount(passenger));
        } else {
            ApiUtils.addFutureServerTask(this.level(), () -> this.handleDismount(passenger), true);
        }
    }

    public void absMoveTo(double x, double y, double z, float yaw, float pitch) {
    }

    public Connection getConnection() {
        return this.connection;
    }

    public double getSpeed() {
        if (this.connection == null) {
            return 0.0;
        }
        if (this.connection.getCatenaryData().isVertical()) {
            return Math.abs(this.horizontalSpeed);
        }
        double slope = this.connection.getSlope(this.linePos, this.start);
        return Math.abs(this.horizontalSpeed) * Math.sqrt(1.0 + slope * slope) * (double)this.getSlopeModifier();
    }

    private double getHorizontalLength() {
        if (this.connection.getCatenaryData().isVertical()) {
            return Math.abs(this.connection.getCatenaryData().getDeltaY());
        }
        return this.connection.getCatenaryData().horLength();
    }

    private double getStartSignum() {
        if (this.start.equals(this.connection.getEndA())) {
            return 1.0;
        }
        return -1.0;
    }
}

