/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AlloyRecipe
extends IESerializableRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<AlloyRecipe>> SERIALIZER;
    public static final CachedRecipeList<AlloyRecipe> RECIPES;
    public final IngredientWithSize input0;
    public final IngredientWithSize input1;
    public final TagOutput output;
    public final int time;

    public AlloyRecipe(TagOutput output, IngredientWithSize input0, IngredientWithSize input1, int time) {
        super(output, IERecipeTypes.ALLOY);
        this.output = output;
        this.input0 = input0;
        this.input1 = input1;
        this.time = time;
    }

    protected IERecipeSerializer<AlloyRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return this.output.get();
    }

    public boolean matches(ItemStack input0, ItemStack input1) {
        if (this.input0.test(input0) && this.input1.test(input1)) {
            return true;
        }
        return this.input0.test(input1) && this.input1.test(input0);
    }

    public static AlloyRecipe findRecipe(Level level, ItemStack input0, ItemStack input1, @Nullable AlloyRecipe hint) {
        if (input0.isEmpty() || input1.isEmpty()) {
            return null;
        }
        if (hint != null && hint.matches(input0, input1)) {
            return hint;
        }
        for (RecipeHolder<AlloyRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((AlloyRecipe)recipe.value()).matches(input0, input1)) continue;
            return (AlloyRecipe)recipe.value();
        }
        return null;
    }

    static {
        RECIPES = new CachedRecipeList<AlloyRecipe>(IERecipeTypes.ALLOY);
    }
}

