/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.tags;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.fluids.IEFluidBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class IEBlockTags
extends BlockTagsProvider {
    public IEBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existing) {
        super(output, lookupProvider, "immersiveengineering", existing);
    }

    /*
     * WARNING - void declaration
     */
    protected void addTags(HolderLookup.Provider p_256380_) {
        void var5_21;
        this.tag(BlockTags.CROPS).add((Object)IEBlocks.Misc.HEMP_PLANT.get());
        this.tag(BlockTags.FENCES).add((Object)IEBlocks.MetalDecoration.ALU_FENCE.get()).add((Object)IEBlocks.MetalDecoration.STEEL_FENCE.get()).add((Object)IEBlocks.WoodenDecoration.TREATED_FENCE.get());
        this.tag(BlockTags.FENCE_GATES).add((Object)IEBlocks.MetalDecoration.ALU_FENCE_GATE.get()).add((Object)IEBlocks.MetalDecoration.STEEL_FENCE_GATE.get()).add((Object)IEBlocks.WoodenDecoration.TREATED_FENCE_GATE.get());
        this.tag(BlockTags.WOODEN_FENCES).add((Object)IEBlocks.WoodenDecoration.TREATED_FENCE.get());
        this.tag(BlockTags.DOORS).add((Object)IEBlocks.MetalDecoration.STEEL_DOOR.get()).add((Object)IEBlocks.WoodenDecoration.DOOR.get()).add((Object)IEBlocks.WoodenDecoration.DOOR_FRAMED.get());
        this.tag(BlockTags.WOODEN_DOORS).add((Object)IEBlocks.WoodenDecoration.DOOR.get()).add((Object)IEBlocks.WoodenDecoration.DOOR_FRAMED.get());
        this.tag(BlockTags.TRAPDOORS).add((Object)IEBlocks.MetalDecoration.STEEL_TRAPDOOR.get()).add((Object)IEBlocks.WoodenDecoration.TRAPDOOR.get()).add((Object)IEBlocks.WoodenDecoration.TRAPDOOR_FRAMED.get());
        this.tag(BlockTags.WOODEN_TRAPDOORS).add((Object)IEBlocks.WoodenDecoration.TRAPDOOR.get()).add((Object)IEBlocks.WoodenDecoration.TRAPDOOR_FRAMED.get());
        this.registerSigns(IEBlocks.WoodenDecoration.SIGN, IEBlocks.MetalDecoration.STEEL_SIGN, IEBlocks.MetalDecoration.ALU_SIGN);
        this.tag(BlockTags.PLANKS).add((Object)IEBlocks.WoodenDecoration.FIBERBOARD.get());
        this.tag(IETags.fencesSteel).add((Object)IEBlocks.MetalDecoration.STEEL_FENCE.get());
        this.tag(IETags.fencesAlu).add((Object)IEBlocks.MetalDecoration.ALU_FENCE.get());
        this.tag(IETags.clayBlock).add((Object)Blocks.CLAY);
        this.tag(IETags.glowstoneBlock).add((Object)Blocks.GLOWSTONE);
        this.tag(IETags.copperBlocks).add((Object[])new Block[]{Blocks.COPPER_BLOCK, Blocks.EXPOSED_COPPER, Blocks.WEATHERED_COPPER, Blocks.OXIDIZED_COPPER}).add((Object[])new Block[]{Blocks.WAXED_COPPER_BLOCK, Blocks.WAXED_EXPOSED_COPPER, Blocks.WAXED_WEATHERED_COPPER, Blocks.WAXED_OXIDIZED_COPPER});
        this.tag(IETags.cutCopperBlocks).add((Object[])new Block[]{Blocks.CUT_COPPER, Blocks.EXPOSED_CUT_COPPER, Blocks.WEATHERED_CUT_COPPER, Blocks.OXIDIZED_CUT_COPPER}).add((Object[])new Block[]{Blocks.WAXED_CUT_COPPER, Blocks.WAXED_EXPOSED_CUT_COPPER, Blocks.WAXED_WEATHERED_CUT_COPPER, Blocks.WAXED_OXIDIZED_CUT_COPPER});
        this.tag(IETags.cutCopperStairs).add((Object[])new Block[]{Blocks.CUT_COPPER_STAIRS, Blocks.EXPOSED_CUT_COPPER_STAIRS, Blocks.WEATHERED_CUT_COPPER_STAIRS, Blocks.OXIDIZED_CUT_COPPER_STAIRS}).add((Object[])new Block[]{Blocks.WAXED_CUT_COPPER_STAIRS, Blocks.WAXED_EXPOSED_CUT_COPPER_STAIRS, Blocks.WAXED_WEATHERED_CUT_COPPER_STAIRS, Blocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS});
        this.tag(IETags.cutCopperSlabs).add((Object[])new Block[]{Blocks.CUT_COPPER_SLAB, Blocks.EXPOSED_CUT_COPPER_SLAB, Blocks.WEATHERED_CUT_COPPER_SLAB, Blocks.OXIDIZED_CUT_COPPER_SLAB}).add((Object[])new Block[]{Blocks.WAXED_CUT_COPPER_SLAB, Blocks.WAXED_EXPOSED_CUT_COPPER_SLAB, Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB, Blocks.WAXED_OXIDIZED_CUT_COPPER_SLAB});
        for (IEBlocks.BlockEntry b : IEBlocks.MetalDecoration.METAL_LADDER.values()) {
            this.tag(BlockTags.CLIMBABLE).add((Object)b.get());
        }
        for (EnumMetals enumMetals : EnumMetals.values()) {
            IETags.MetalTags tags = IETags.getTagsFor((EnumMetals)enumMetals);
            if (!enumMetals.isVanillaMetal()) {
                this.tag(tags.storage).add((Object)((IEBlocks.BlockEntry)IEBlocks.Metals.STORAGE.get(enumMetals)).get());
                this.tag(Tags.Blocks.STORAGE_BLOCKS).addTag(tags.storage);
                if (enumMetals.shouldAddOre()) {
                    Preconditions.checkNotNull((Object)tags.ore);
                    this.tag(tags.ore).add((Object)((IEBlocks.BlockEntry)IEBlocks.Metals.ORES.get(enumMetals)).get()).add((Object)((IEBlocks.BlockEntry)IEBlocks.Metals.DEEPSLATE_ORES.get(enumMetals)).get());
                    this.tag(Tags.Blocks.ORES).addTag(tags.ore);
                    Preconditions.checkNotNull((Object)tags.rawBlock);
                    this.tag(tags.rawBlock).add((Object)((IEBlocks.BlockEntry)IEBlocks.Metals.RAW_ORES.get(enumMetals)).get());
                    this.tag(Tags.Blocks.STORAGE_BLOCKS).addTag(tags.rawBlock);
                    this.tag(Tags.Blocks.ORES_IN_GROUND_STONE).add((Object)((IEBlocks.BlockEntry)IEBlocks.Metals.ORES.get(enumMetals)).get());
                    this.tag(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE).add((Object)((IEBlocks.BlockEntry)IEBlocks.Metals.DEEPSLATE_ORES.get(enumMetals)).get());
                    this.tag(Tags.Blocks.ORE_RATES_SINGULAR).add((Object)((IEBlocks.BlockEntry)IEBlocks.Metals.ORES.get(enumMetals)).get()).add((Object)((IEBlocks.BlockEntry)IEBlocks.Metals.DEEPSLATE_ORES.get(enumMetals)).get());
                }
            }
            this.tag(tags.sheetmetal).add((Object)((IEBlocks.BlockEntry)IEBlocks.Metals.SHEETMETAL.get(enumMetals)).get());
            this.tag(IETags.sheetmetals).addTag(tags.sheetmetal);
            this.tag(IETags.sheetmetalSlabs).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(((IEBlocks.BlockEntry)IEBlocks.Metals.SHEETMETAL.get(enumMetals)).getId())).get());
        }
        for (EnumMetals enumMetals : DyeColor.values()) {
            this.tag(IETags.sheetmetals).add((Object)((IEBlocks.BlockEntry)IEBlocks.MetalDecoration.COLORED_SHEETMETAL.get(enumMetals)).get());
            this.tag(IETags.sheetmetalSlabs).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(((IEBlocks.BlockEntry)IEBlocks.MetalDecoration.COLORED_SHEETMETAL.get(enumMetals)).getId())).get());
        }
        for (EnumMetals enumMetals : TreatedWoodStyles.values()) {
            this.tag(IETags.treatedWood).add((Object)((IEBlocks.BlockEntry)IEBlocks.WoodenDecoration.TREATED_WOOD.get(enumMetals)).get());
            this.tag(IETags.treatedWoodSlab).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(((IEBlocks.BlockEntry)IEBlocks.WoodenDecoration.TREATED_WOOD.get(enumMetals)).getId())).get());
        }
        for (EnumMetals enumMetals : MetalScaffoldingType.values()) {
            this.tag(IETags.scaffoldingSteel).add((Object)((IEBlocks.BlockEntry)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(enumMetals)).get());
            this.tag(IETags.scaffoldingAlu).add((Object)((IEBlocks.BlockEntry)IEBlocks.MetalDecoration.ALU_SCAFFOLDING.get(enumMetals)).get());
        }
        for (IEBlocks.BlockEntry entry : IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.values()) {
            this.tag(IETags.scaffoldingSteelStair).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_STAIRS.get(entry.getId())).get());
            this.tag(IETags.scaffoldingSteelSlab).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(entry.getId())).get());
        }
        for (IEBlocks.BlockEntry entry : IEBlocks.MetalDecoration.ALU_SCAFFOLDING.values()) {
            this.tag(IETags.scaffoldingAluStair).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_STAIRS.get(entry.getId())).get());
            this.tag(IETags.scaffoldingAluSlab).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(entry.getId())).get());
        }
        this.tag(IETags.coalCokeBlock).add((Object)IEBlocks.StoneDecoration.COKE.get());
        this.tag(Tags.Blocks.GRAVELS).add((Object)IEBlocks.StoneDecoration.SLAG_GRAVEL.get());
        this.tag(BlockTags.FLOWER_POTS).add((Object)IEBlocks.Misc.POTTED_HEMP.get());
        this.tag(BlockTags.WITHER_IMMUNE).add((Object)IEBlocks.StoneDecoration.CONCRETE_REINFORCED.get()).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE_REINFORCED.getId())).get()).add((Object)IEBlocks.StoneDecoration.CONCRETE_REINFORCED_TILE.get()).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE_REINFORCED_TILE.getId())).get()).add((Object)IEBlocks.MetalDecoration.REINFORCED_WINDOW.get());
        this.tag(BlockTags.SNOW_LAYER_CANNOT_SURVIVE_ON).add((Object)IEBlocks.WoodenDevices.WATERMILL.get()).add((Object)IEBlocks.WoodenDevices.WINDMILL.get());
        this.tag(BlockTags.BAMBOO_PLANTABLE_ON).add((Object)IEBlocks.StoneDecoration.SLAG_GRAVEL.get()).add((Object)IEBlocks.StoneDecoration.GRIT_SAND.get());
        this.tag(BlockTags.SCULK_REPLACEABLE).add((Object)IEBlocks.StoneDecoration.SLAG_GRAVEL.get()).add((Object)IEBlocks.StoneDecoration.GRIT_SAND.get());
        this.tag(BlockTags.AZALEA_ROOT_REPLACEABLE).add((Object)IEBlocks.StoneDecoration.SLAG_GRAVEL.get()).add((Object)IEBlocks.StoneDecoration.GRIT_SAND.get());
        this.tag(BlockTags.DEAD_BUSH_MAY_PLACE_ON).add((Object)IEBlocks.StoneDecoration.GRIT_SAND.get());
        IEBlocks.BlockEntry[] concreteBlocks = new IEBlocks.BlockEntry[]{IEBlocks.StoneDecoration.CONCRETE, IEBlocks.StoneDecoration.CONCRETE_TILE, IEBlocks.StoneDecoration.CONCRETE_SPRAYED, IEBlocks.StoneDecoration.CONCRETE_THREE_QUARTER, IEBlocks.StoneDecoration.CONCRETE_SHEET, IEBlocks.StoneDecoration.CONCRETE_QUARTER, IEBlocks.StoneDecoration.CONCRETE_LEADED, IEBlocks.StoneDecoration.CONCRETE_REINFORCED, IEBlocks.StoneDecoration.CONCRETE_REINFORCED_TILE};
        IEBlocks.BlockEntry[] blockEntryArray = concreteBlocks;
        int n = blockEntryArray.length;
        boolean bl = false;
        while (var5_21 < n) {
            IEBlocks.BlockEntry entry = blockEntryArray[var5_21];
            this.tag(IETags.concreteForFeet).add((Object)entry.get());
            IEBlocks.BlockEntry shaped = (IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(entry.getId());
            if (shaped != null) {
                this.tag(IETags.concreteForFeet).add((Object)shaped.get());
            }
            if ((shaped = (IEBlocks.BlockEntry)IEBlocks.TO_STAIRS.get(entry.getId())) != null) {
                this.tag(IETags.concreteForFeet).add((Object)shaped.get());
            }
            ++var5_21;
        }
        this.tag(IETags.teleportBlocking).add((Object)IEBlocks.StoneDecoration.CONCRETE_LEADED.get()).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE_LEADED.getId())).get()).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_STAIRS.get(IEBlocks.StoneDecoration.CONCRETE_LEADED.getId())).get());
        this.registerHammerMineable();
        this.registerRockcutterMineable();
        this.registerGrindingDiskMineable();
        this.registerPickaxeMineable();
        this.registerAxeMineable();
        this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object)IEBlocks.WoodenDecoration.SAWDUST.get()).add((Object)IEBlocks.StoneDecoration.SLAG_GRAVEL.get()).add((Object)IEBlocks.StoneDecoration.GRIT_SAND.get());
        this.tag(IETags.wirecutterHarvestable).add((Object)IEBlocks.MetalDevices.RAZOR_WIRE.get());
        this.tag(IETags.drillHarvestable).addTag(BlockTags.MINEABLE_WITH_SHOVEL).addTag(BlockTags.MINEABLE_WITH_PICKAXE);
        this.tag(IETags.buzzsawTreeBlacklist).addOptionalTag(ResourceLocation.fromNamespaceAndPath((String)"dynamictrees", (String)"branches")).addOptionalTag(ResourceLocation.fromNamespaceAndPath((String)"dynamictrees", (String)"leaves"));
        this.tag(IETags.surveyToolTargets).addTag(Tags.Blocks.STONES).add((Object)Blocks.DRIPSTONE_BLOCK).add((Object)Blocks.CALCITE).add((Object)Blocks.SANDSTONE).add((Object)Blocks.RED_SANDSTONE).addTag(BlockTags.DIRT).remove((Object)Blocks.MOSS_BLOCK).addTag(Tags.Blocks.GRAVELS).addTag(Tags.Blocks.SANDS).add((Object)Blocks.CLAY).add((Object)Blocks.TERRACOTTA).add((Object)Blocks.WHITE_TERRACOTTA).add((Object)Blocks.LIGHT_GRAY_TERRACOTTA).add((Object)Blocks.GRAY_TERRACOTTA).add((Object)Blocks.BROWN_TERRACOTTA).add((Object)Blocks.RED_TERRACOTTA).add((Object)Blocks.ORANGE_TERRACOTTA).add((Object)Blocks.YELLOW_TERRACOTTA).addTag(Tags.Blocks.NETHERRACKS).add((Object)Blocks.BASALT).add((Object)Blocks.BLACKSTONE).addTag(BlockTags.NYLIUM).add((Object)Blocks.SOUL_SAND).add((Object)Blocks.SOUL_SOIL).add((Object)Blocks.END_STONE);
        this.checkAllRegisteredForBreaking();
        for (IEBlocks.BlockEntry treatedWood : IEBlocks.WoodenDecoration.TREATED_WOOD.values()) {
            this.tag(BlockTags.WOODEN_SLABS).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(treatedWood.getId())).get());
            this.tag(BlockTags.WOODEN_STAIRS).add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_STAIRS.get(treatedWood.getId())).get());
        }
        for (IEBlocks.BlockEntry slab : IEBlocks.TO_SLAB.values()) {
            this.tag(BlockTags.SLABS).add((Object)slab.get());
        }
        for (IEBlocks.BlockEntry stairs : IEBlocks.TO_STAIRS.values()) {
            this.tag(BlockTags.STAIRS).add((Object)stairs.get());
        }
        for (IEBlocks.BlockEntry walls : IEBlocks.TO_WALL.values()) {
            this.tag(BlockTags.WALLS).add((Object)walls.get());
        }
        this.tag(IETags.incorrectDropsSteel).addTag(BlockTags.INCORRECT_FOR_IRON_TOOL);
        this.tag(TagUtils.createBlockWrapper((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tconstruct", (String)"harvestable/stackable"))).add((Object)IEBlocks.Misc.HEMP_PLANT.get());
        this.tag(TagUtils.createBlockWrapper((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chiselsandbits", (String)"chiselable/forced"))).add((Object)IEBlocks.StoneDecoration.INSULATING_GLASS.get()).add((Object)IEBlocks.WoodenDevices.WOODEN_BARREL.get()).add((Object)IEBlocks.WoodenDevices.TURNTABLE.get()).add((Object)IEBlocks.WoodenDevices.CRATE.get()).add((Object)IEBlocks.WoodenDevices.REINFORCED_CRATE.get()).add((Object)IEBlocks.WoodenDevices.ITEM_BATCHER.get()).add((Object)IEBlocks.WoodenDevices.FLUID_SORTER.get()).add((Object)IEBlocks.WoodenDevices.SORTER.get()).add((Object)IEBlocks.MetalDevices.CAPACITOR_LV.get()).add((Object)IEBlocks.MetalDevices.CAPACITOR_MV.get()).add((Object)IEBlocks.MetalDevices.CAPACITOR_HV.get()).add((Object)IEBlocks.MetalDevices.CAPACITOR_CREATIVE.get()).add((Object)IEBlocks.MetalDevices.BARREL.get()).add((Object)IEBlocks.MetalDevices.FURNACE_HEATER.get()).add((Object)IEBlocks.MetalDevices.DYNAMO.get()).add((Object)IEBlocks.MetalDevices.THERMOELECTRIC_GEN.get());
    }

    private void registerHammerMineable() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(IETags.hammerHarvestable);
        IEBlocks.MetalDecoration.METAL_LADDER.values().forEach(b -> tag.add((Object)b.get()));
        tag.addTag(IETags.scaffoldingSteel);
        tag.addTag(IETags.scaffoldingAlu);
        tag.add((Object)IEBlocks.StoneDecoration.CONCRETE_SPRAYED.get()).add((Object)IEBlocks.Cloth.STRIP_CURTAIN.get());
        for (Holder regObject : IEBlocks.REGISTER.getEntries()) {
            Block block = (Block)regObject.value();
            if (!(block instanceof ConnectorBlock) && !(block instanceof ConveyorBlock)) continue;
            tag.add((Object)block);
        }
        tag.remove((Object)IEBlocks.MetalDevices.RAZOR_WIRE.get());
        tag.add((Object)IEBlocks.Connectors.REDSTONE_SWITCHBOARD.get());
    }

    private void registerRockcutterMineable() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(IETags.rockcutterHarvestable);
        tag.addTag(Tags.Blocks.COBBLESTONES);
        tag.addTag(Tags.Blocks.STONES);
        tag.addTag(Tags.Blocks.SANDSTONE_BLOCKS);
        tag.addTag(Tags.Blocks.ORES);
        tag.add((Object[])new Block[]{Blocks.CALCITE, Blocks.DRIPSTONE_BLOCK, Blocks.POINTED_DRIPSTONE});
        tag.addTag(Tags.Blocks.NETHERRACKS);
        tag.add((Object[])new Block[]{Blocks.BASALT, Blocks.SMOOTH_BASALT});
        tag.add((Object)Blocks.BLACKSTONE);
        tag.add((Object)Blocks.END_STONE);
        tag.add((Object[])new Block[]{Blocks.OBSIDIAN, Blocks.CRYING_OBSIDIAN});
        tag.add((Object)Blocks.BONE_BLOCK);
        tag.addTag(Tags.Blocks.GLASS_BLOCKS);
        tag.addTag(Tags.Blocks.GLASS_PANES);
        tag.addTag(BlockTags.ICE);
        tag.add((Object[])new Block[]{Blocks.AMETHYST_BLOCK, Blocks.BUDDING_AMETHYST, Blocks.AMETHYST_CLUSTER, Blocks.LARGE_AMETHYST_BUD, Blocks.MEDIUM_AMETHYST_BUD, Blocks.SMALL_AMETHYST_BUD});
        tag.add((Object)Blocks.GLOWSTONE);
        tag.add((Object)Blocks.SEA_LANTERN);
        tag.add((Object)Blocks.GILDED_BLACKSTONE);
        tag.addTag(BlockTags.CORAL_BLOCKS);
        tag.add((Object[])new Block[]{Blocks.DEAD_BRAIN_CORAL_BLOCK, Blocks.DEAD_BUBBLE_CORAL_BLOCK, Blocks.DEAD_FIRE_CORAL_BLOCK, Blocks.DEAD_HORN_CORAL_BLOCK, Blocks.DEAD_TUBE_CORAL_BLOCK});
        tag.addTag(Tags.Blocks.CHESTS_ENDER);
        tag.add((Object[])new Block[]{Blocks.SCULK, Blocks.SCULK_CATALYST, Blocks.SCULK_SENSOR, Blocks.CALIBRATED_SCULK_SENSOR});
    }

    private void registerGrindingDiskMineable() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(IETags.grindingDiskHarvestable);
        tag.addTag(Tags.Blocks.STORAGE_BLOCKS);
        tag.addTag(IETags.sheetmetals);
        for (EnumMetals metal : EnumMetals.values()) {
            if (metal.isVanillaMetal()) continue;
            tag.add((Object)((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(((IEBlocks.BlockEntry)IEBlocks.Metals.STORAGE.get(metal)).getId())).get());
        }
        tag.addTag(IETags.sheetmetalSlabs);
        tag.remove((Object)Blocks.AMETHYST_BLOCK, (Object[])new Block[]{Blocks.QUARTZ_BLOCK, Blocks.LAPIS_BLOCK, Blocks.REDSTONE_BLOCK, Blocks.DIAMOND_BLOCK, Blocks.EMERALD_BLOCK, Blocks.COAL_BLOCK});
        tag.remove(Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER, new TagKey[]{Tags.Blocks.STORAGE_BLOCKS_RAW_IRON, Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD});
        for (IEBlocks.BlockEntry raw_storage : IEBlocks.Metals.RAW_ORES.values()) {
            tag.remove((Object)raw_storage.get());
        }
        tag.addTag(IETags.copperBlocks);
        tag.addTag(IETags.cutCopperBlocks);
        tag.addTag(IETags.cutCopperSlabs);
        tag.addTag(IETags.cutCopperStairs);
        tag.add((Object[])new Block[]{Blocks.ANVIL, Blocks.CHIPPED_ANVIL, Blocks.DAMAGED_ANVIL});
        tag.add((Object[])new Block[]{Blocks.CHAIN, Blocks.IRON_BARS, Blocks.IRON_DOOR, Blocks.IRON_TRAPDOOR, Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE, Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE, Blocks.HOPPER, Blocks.CAULDRON, Blocks.LAVA_CAULDRON, Blocks.WATER_CAULDRON, Blocks.POWDER_SNOW_CAULDRON, Blocks.LIGHTNING_ROD});
        tag.addTag(IETags.scaffoldingSteel);
        tag.addTag(IETags.scaffoldingAlu);
        tag.add((Object[])new Block[]{IEBlocks.MetalDecoration.LANTERN.get(), IEBlocks.MetalDecoration.CAGELAMP.get(), IEBlocks.MetalDecoration.STEEL_DOOR.get(), IEBlocks.MetalDecoration.STEEL_TRAPDOOR.get(), IEBlocks.MetalDecoration.REINFORCED_WINDOW.get()});
        tag.add((Object[])new Block[]{IEBlocks.MetalDecoration.ALU_FENCE.get(), IEBlocks.MetalDecoration.ALU_POST.get(), IEBlocks.MetalDecoration.ALU_WALLMOUNT.get(), IEBlocks.MetalDecoration.ALU_SLOPE.get(), IEBlocks.MetalDecoration.ALU_CATWALK.get(), IEBlocks.MetalDecoration.ALU_CATWALK_STAIRS.get(), IEBlocks.MetalDecoration.ALU_WINDOW.get()});
        tag.add((Object[])new Block[]{IEBlocks.MetalDecoration.STEEL_FENCE.get(), IEBlocks.MetalDecoration.STEEL_POST.get(), IEBlocks.MetalDecoration.STEEL_WALLMOUNT.get(), IEBlocks.MetalDecoration.STEEL_SLOPE.get(), IEBlocks.MetalDecoration.STEEL_CATWALK.get(), IEBlocks.MetalDecoration.STEEL_CATWALK_STAIRS.get(), IEBlocks.MetalDecoration.STEEL_WINDOW.get()});
        IEBlocks.MetalDecoration.METAL_LADDER.values().forEach(entry -> tag.add((Object)entry.get()));
        IEBlocks.MetalDevices.CHUTES.values().forEach(entry -> tag.add((Object)entry.get()));
        IEBlocks.MetalDevices.DYED_CHUTES.values().forEach(entry -> tag.add((Object)entry.get()));
        tag.add((Object[])new Block[]{IEBlocks.MetalDevices.BARREL.get(), IEBlocks.MetalDevices.FLUID_PUMP.get(), IEBlocks.MetalDevices.FLUID_PIPE.get(), IEBlocks.MetalDevices.FLUID_PLACER.get(), IEBlocks.MetalDevices.PIPE_VALVE.get()});
        tag.add((Object[])new Block[]{IEBlocks.MetalDevices.BLAST_FURNACE_PREHEATER.get(), IEBlocks.MetalDevices.FURNACE_HEATER.get(), IEBlocks.MetalDevices.DYNAMO.get(), IEBlocks.MetalDevices.THERMOELECTRIC_GEN.get(), IEBlocks.MetalDevices.ELECTRIC_LANTERN.get(), IEBlocks.MetalDevices.SAMPLE_DRILL.get(), IEBlocks.MetalDevices.FLOODLIGHT.get(), IEBlocks.MetalDevices.ELECTROMAGNET.get()});
        tag.add((Object[])new Block[]{IEBlocks.Connectors.CONNECTOR_STRUCTURAL.get(), IEBlocks.Connectors.TRANSFORMER.get(), IEBlocks.Connectors.TRANSFORMER_HV.get(), IEBlocks.Connectors.BREAKER_SWITCH.get(), IEBlocks.Connectors.REDSTONE_BREAKER.get(), IEBlocks.Connectors.CURRENT_TRANSFORMER.get(), IEBlocks.Connectors.POST_TRANSFORMER.get()});
        tag.add((Object[])new Block[]{IEBlocks.MetalDecoration.LV_COIL.get(), IEBlocks.MetalDecoration.MV_COIL.get(), IEBlocks.MetalDecoration.MV_COIL.get()});
        tag.add((Object[])new Block[]{IEBlocks.MetalDecoration.ENGINEERING_RS.get(), IEBlocks.MetalDecoration.ENGINEERING_LIGHT.get(), IEBlocks.MetalDecoration.ENGINEERING_HEAVY.get(), IEBlocks.MetalDecoration.ENGINEERING_RESONANZ.get(), IEBlocks.MetalDecoration.RADIATOR.get(), IEBlocks.MetalDecoration.GENERATOR.get()});
        tag.add((Object[])new Block[]{IEMultiblocks.CRUSHER.getBlock(), IEMultiblocks.SAWMILL.getBlock(), IEMultiblocks.ARC_FURNACE.getBlock(), IEMultiblocks.ASSEMBLER.getBlock(), IEMultiblocks.AUTO_WORKBENCH.getBlock(), IEMultiblocks.BOTTLING_MACHINE.getBlock(), IEMultiblocks.BUCKET_WHEEL.getBlock(), IEMultiblocks.DIESEL_GENERATOR.getBlock(), IEMultiblocks.EXCAVATOR.getBlock(), IEMultiblocks.FERMENTER.getBlock(), IEMultiblocks.LIGHTNING_ROD.getBlock(), IEMultiblocks.METAL_PRESS.getBlock(), IEMultiblocks.MIXER.getBlock(), IEMultiblocks.REFINERY.getBlock(), IEMultiblocks.SHEETMETAL_TANK.getBlock(), IEMultiblocks.SILO.getBlock(), IEMultiblocks.SQUEEZER.getBlock(), IEMultiblocks.RADIO_TOWER.getBlock(), IEMultiblocks.CHUNK_LOADER.getBlock()});
    }

    private void registerAxeMineable() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(BlockTags.MINEABLE_WITH_AXE);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.WoodenDevices.CRAFTING_TABLE, IEBlocks.WoodenDevices.WORKBENCH, IEBlocks.WoodenDevices.BLUEPRINT_SHELF, IEBlocks.WoodenDevices.CIRCUIT_TABLE, IEBlocks.WoodenDevices.GUNPOWDER_BARREL, IEBlocks.WoodenDevices.WOODEN_BARREL, IEBlocks.WoodenDevices.TURNTABLE, IEBlocks.WoodenDevices.CRATE, IEBlocks.WoodenDevices.REINFORCED_CRATE, IEBlocks.WoodenDevices.SORTER, IEBlocks.WoodenDevices.ITEM_BATCHER, IEBlocks.WoodenDevices.FLUID_SORTER, IEBlocks.WoodenDevices.WINDMILL, IEBlocks.WoodenDevices.WATERMILL, IEBlocks.WoodenDevices.TREATED_WALLMOUNT, IEBlocks.WoodenDevices.LOGIC_UNIT, IEBlocks.WoodenDevices.MACHINE_INTERFACE, IEBlocks.WoodenDecoration.TREATED_FENCE, IEBlocks.WoodenDecoration.TREATED_FENCE_GATE, IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING, IEBlocks.WoodenDecoration.TREATED_POST, IEBlocks.WoodenDecoration.SAWDUST, IEBlocks.WoodenDecoration.FIBERBOARD, IEBlocks.WoodenDecoration.WINDOW, IEBlocks.WoodenDecoration.CATWALK, IEBlocks.WoodenDecoration.CATWALK_STAIRS, IEBlocks.WoodenDecoration.DOOR, IEBlocks.WoodenDecoration.DOOR_FRAMED, IEBlocks.WoodenDecoration.TRAPDOOR, IEBlocks.WoodenDecoration.TRAPDOOR_FRAMED, IEBlocks.Cloth.SHADER_BANNER, IEBlocks.Cloth.SHADER_BANNER_WALL);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.WoodenDecoration.SIGN.getEntries());
        for (IEBlocks.BlockEntry treatedWood : IEBlocks.WoodenDecoration.TREATED_WOOD.values()) {
            this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, treatedWood);
        }
    }

    private void registerMineable(IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> tag, MultiblockRegistration<?> ... entries) {
        for (MultiblockRegistration<?> entry : entries) {
            tag.add((Object)((Block)entry.block().get()));
        }
    }

    private <T extends Block> void registerMineable(IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> tag, Map<?, IEBlocks.BlockEntry<T>> entries) {
        this.registerMineable(tag, new ArrayList(entries.values()));
    }

    private void registerMineable(IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> tag, IEBlocks.BlockEntry<?> ... entries) {
        this.registerMineable(tag, Arrays.asList(entries));
    }

    private void registerMineable(IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> tag, List<IEBlocks.BlockEntry<?>> entries) {
        entries.sort(Comparator.comparing(IEBlocks.BlockEntry::getId));
        for (IEBlocks.BlockEntry<?> entry : entries) {
            IEBlocks.BlockEntry wall;
            IEBlocks.BlockEntry stairs;
            tag.add((Object)entry.get());
            IEBlocks.BlockEntry slab = (IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(entry.getId());
            if (slab != null) {
                tag.add((Object)slab.get());
            }
            if ((stairs = (IEBlocks.BlockEntry)IEBlocks.TO_STAIRS.get(entry.getId())) != null) {
                tag.add((Object)stairs.get());
            }
            if ((wall = (IEBlocks.BlockEntry)IEBlocks.TO_WALL.get(entry.getId())) == null) continue;
            tag.add((Object)wall.get());
        }
    }

    private void registerPickaxeMineable() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(BlockTags.MINEABLE_WITH_PICKAXE);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEMultiblockLogic.COKE_OVEN, IEMultiblockLogic.BLAST_FURNACE, IEMultiblockLogic.ALLOY_SMELTER, IEMultiblockLogic.ADV_BLAST_FURNACE, IEMultiblockLogic.METAL_PRESS, IEMultiblockLogic.CRUSHER, IEMultiblockLogic.SAWMILL, IEMultiblockLogic.TANK, IEMultiblockLogic.SILO, IEMultiblockLogic.ASSEMBLER, IEMultiblockLogic.AUTO_WORKBENCH, IEMultiblockLogic.BOTTLING_MACHINE, IEMultiblockLogic.SQUEEZER, IEMultiblockLogic.FERMENTER, IEMultiblockLogic.REFINERY, IEMultiblockLogic.DIESEL_GENERATOR, IEMultiblockLogic.EXCAVATOR, IEMultiblockLogic.BUCKET_WHEEL, IEMultiblockLogic.ARC_FURNACE, IEMultiblockLogic.LIGHTNING_ROD, IEMultiblockLogic.MIXER, IEMultiblockLogic.CHUNK_LOADER);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.StoneDecoration.COKEBRICK, IEBlocks.StoneDecoration.BLASTBRICK, IEBlocks.StoneDecoration.BLASTBRICK_REINFORCED, IEBlocks.StoneDecoration.SLAG_BRICK, IEBlocks.StoneDecoration.CLINKER_BRICK, IEBlocks.StoneDecoration.CLINKER_BRICK_QUOIN, IEBlocks.StoneDecoration.CLINKER_BRICK_SILL, IEBlocks.StoneDecoration.COKE, IEBlocks.StoneDecoration.HEMPCRETE, IEBlocks.StoneDecoration.HEMPCRETE_BRICK, IEBlocks.StoneDecoration.HEMPCRETE_BRICK_CRACKED, IEBlocks.StoneDecoration.HEMPCRETE_CHISELED, IEBlocks.StoneDecoration.HEMPCRETE_PILLAR, IEBlocks.StoneDecoration.CONCRETE, IEBlocks.StoneDecoration.CONCRETE_BRICK, IEBlocks.StoneDecoration.CONCRETE_BRICK_CRACKED, IEBlocks.StoneDecoration.CONCRETE_CHISELED, IEBlocks.StoneDecoration.CONCRETE_PILLAR, IEBlocks.StoneDecoration.CONCRETE_TILE, IEBlocks.StoneDecoration.CONCRETE_LEADED, IEBlocks.StoneDecoration.CONCRETE_REINFORCED, IEBlocks.StoneDecoration.CONCRETE_REINFORCED_TILE, IEBlocks.StoneDecoration.INSULATING_GLASS, IEBlocks.StoneDecoration.SLAG_GLASS, IEBlocks.StoneDecoration.CONCRETE_SPRAYED, IEBlocks.StoneDecoration.ALLOYBRICK, IEBlocks.StoneDecoration.CONCRETE_SHEET, IEBlocks.StoneDecoration.CONCRETE_QUARTER, IEBlocks.StoneDecoration.CONCRETE_THREE_QUARTER, IEBlocks.StoneDecoration.CORESAMPLE, IEBlocks.StoneDecoration.DUROPLAST, IEBlocks.MetalDevices.RAZOR_WIRE, IEBlocks.MetalDevices.TOOLBOX, IEBlocks.MetalDevices.CAPACITOR_LV, IEBlocks.MetalDevices.CAPACITOR_MV, IEBlocks.MetalDevices.CAPACITOR_HV, IEBlocks.MetalDevices.CAPACITOR_CREATIVE, IEBlocks.MetalDevices.BARREL, IEBlocks.MetalDevices.FLUID_PUMP, IEBlocks.MetalDevices.FLUID_PLACER, IEBlocks.MetalDevices.BLAST_FURNACE_PREHEATER, IEBlocks.MetalDevices.FURNACE_HEATER, IEBlocks.MetalDevices.DYNAMO, IEBlocks.MetalDevices.THERMOELECTRIC_GEN, IEBlocks.MetalDevices.ELECTRIC_LANTERN, IEBlocks.MetalDevices.CHARGING_STATION, IEBlocks.MetalDevices.FLUID_PIPE, IEBlocks.MetalDevices.SAMPLE_DRILL, IEBlocks.MetalDevices.TESLA_COIL, IEBlocks.MetalDevices.FLOODLIGHT, IEBlocks.MetalDevices.TURRET_CHEM, IEBlocks.MetalDevices.TURRET_GUN, IEBlocks.MetalDevices.CLOCHE, IEBlocks.MetalDevices.ELECTROMAGNET, IEBlocks.MetalDevices.PIPE_VALVE, IEBlocks.MetalDecoration.LV_COIL, IEBlocks.MetalDecoration.MV_COIL, IEBlocks.MetalDecoration.HV_COIL, IEBlocks.MetalDecoration.ENGINEERING_RS, IEBlocks.MetalDecoration.ENGINEERING_HEAVY, IEBlocks.MetalDecoration.ENGINEERING_LIGHT, IEBlocks.MetalDecoration.ENGINEERING_RESONANZ, IEBlocks.MetalDecoration.GENERATOR, IEBlocks.MetalDecoration.RADIATOR, IEBlocks.MetalDecoration.STEEL_FENCE, IEBlocks.MetalDecoration.STEEL_FENCE_GATE, IEBlocks.MetalDecoration.ALU_FENCE, IEBlocks.MetalDecoration.ALU_FENCE_GATE, IEBlocks.MetalDecoration.STEEL_WALLMOUNT, IEBlocks.MetalDecoration.ALU_WALLMOUNT, IEBlocks.MetalDecoration.STEEL_POST, IEBlocks.MetalDecoration.ALU_POST, IEBlocks.MetalDecoration.LANTERN, IEBlocks.MetalDecoration.CAGELAMP, IEBlocks.MetalDecoration.STEEL_SLOPE, IEBlocks.MetalDecoration.ALU_SLOPE, IEBlocks.MetalDecoration.STEEL_WINDOW, IEBlocks.MetalDecoration.ALU_WINDOW, IEBlocks.MetalDecoration.REINFORCED_WINDOW, IEBlocks.MetalDecoration.STEEL_CATWALK, IEBlocks.MetalDecoration.STEEL_CATWALK_STAIRS, IEBlocks.MetalDecoration.ALU_CATWALK, IEBlocks.MetalDecoration.ALU_CATWALK_STAIRS, IEBlocks.MetalDecoration.STEEL_DOOR, IEBlocks.MetalDecoration.STEEL_TRAPDOOR, IEBlocks.Connectors.CONNECTOR_STRUCTURAL, IEBlocks.Connectors.TRANSFORMER, IEBlocks.Connectors.POST_TRANSFORMER, IEBlocks.Connectors.TRANSFORMER_HV, IEBlocks.Connectors.BREAKER_SWITCH, IEBlocks.Connectors.REDSTONE_BREAKER, IEBlocks.Connectors.CURRENT_TRANSFORMER, IEBlocks.Connectors.CONNECTOR_REDSTONE, IEBlocks.Connectors.CONNECTOR_PROBE, IEBlocks.Connectors.CONNECTOR_BUNDLED, IEBlocks.Connectors.REDSTONE_STATE_CELL, IEBlocks.Connectors.REDSTONE_TIMER, IEBlocks.Connectors.REDSTONE_SWITCHBOARD, IEBlocks.Connectors.SIREN, IEBlocks.Connectors.FEEDTHROUGH);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.Metals.SHEETMETAL);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDecoration.COLORED_SHEETMETAL);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDecoration.METAL_LADDER);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDecoration.STEEL_SCAFFOLDING);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDecoration.ALU_SCAFFOLDING);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDecoration.STEEL_SIGN.getEntries());
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDecoration.ALU_SIGN.getEntries());
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDecoration.WARNING_SIGNS);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDevices.CHUTES);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDevices.DYED_CHUTES);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.Connectors.ENERGY_CONNECTORS);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)tag, IEBlocks.MetalDevices.CONVEYORS);
        this.setOreMiningLevel(EnumMetals.COPPER, Tiers.STONE);
        this.setOreMiningLevel(EnumMetals.ALUMINUM, Tiers.STONE);
        this.setOreMiningLevel(EnumMetals.LEAD, Tiers.IRON);
        this.setOreMiningLevel(EnumMetals.SILVER, Tiers.IRON);
        this.setOreMiningLevel(EnumMetals.NICKEL, Tiers.IRON);
        this.setOreMiningLevel(EnumMetals.URANIUM, Tiers.IRON);
        this.setStorageMiningLevel(EnumMetals.COPPER, Tiers.STONE);
        this.setStorageMiningLevel(EnumMetals.ALUMINUM, Tiers.STONE);
        this.setStorageMiningLevel(EnumMetals.LEAD, Tiers.IRON);
        this.setStorageMiningLevel(EnumMetals.SILVER, Tiers.IRON);
        this.setStorageMiningLevel(EnumMetals.NICKEL, Tiers.IRON);
        this.setStorageMiningLevel(EnumMetals.URANIUM, Tiers.IRON);
        this.setStorageMiningLevel(EnumMetals.CONSTANTAN, Tiers.IRON);
        this.setStorageMiningLevel(EnumMetals.ELECTRUM, Tiers.IRON);
        this.setStorageMiningLevel(EnumMetals.STEEL, Tiers.IRON);
    }

    private void setOreMiningLevel(EnumMetals metal, Tiers level) {
        IEBlocks.BlockEntry ore = (IEBlocks.BlockEntry)IEBlocks.Metals.ORES.get(metal);
        IEBlocks.BlockEntry deepslateOre = (IEBlocks.BlockEntry)IEBlocks.Metals.DEEPSLATE_ORES.get(metal);
        IEBlocks.BlockEntry rawOre = (IEBlocks.BlockEntry)IEBlocks.Metals.RAW_ORES.get(metal);
        this.setMiningLevel((Supplier<Block>)ore, level);
        this.setMiningLevel((Supplier<Block>)deepslateOre, level);
        this.setMiningLevel((Supplier<Block>)rawOre, level);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)this.tag(BlockTags.MINEABLE_WITH_PICKAXE), ore, deepslateOre, rawOre);
    }

    private void setStorageMiningLevel(EnumMetals metal, Tiers level) {
        IEBlocks.BlockEntry storage = (IEBlocks.BlockEntry)IEBlocks.Metals.STORAGE.get(metal);
        this.setMiningLevel((Supplier<Block>)storage, level);
        this.registerMineable((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>)this.tag(BlockTags.MINEABLE_WITH_PICKAXE), storage);
    }

    private void setMiningLevel(Supplier<Block> block, Tiers level) {
        TagKey tag = switch (level) {
            case Tiers.STONE -> BlockTags.NEEDS_STONE_TOOL;
            case Tiers.IRON -> BlockTags.NEEDS_IRON_TOOL;
            case Tiers.DIAMOND -> BlockTags.NEEDS_DIAMOND_TOOL;
            default -> throw new IllegalArgumentException("No tag available for " + level.name());
        };
        this.tag(tag).add((Object)block.get());
    }

    private void registerSigns(IEBlocks.SignHolder ... signs) {
        for (IEBlocks.SignHolder holder : signs) {
            this.tag(BlockTags.STANDING_SIGNS).add((Object)holder.sign().get());
            this.tag(BlockTags.WALL_SIGNS).add((Object)holder.wall().get());
            this.tag(BlockTags.CEILING_HANGING_SIGNS).add((Object)holder.hanging().get());
            this.tag(BlockTags.WALL_HANGING_SIGNS).add((Object)holder.wallHanging().get());
        }
    }

    private void checkAllRegisteredForBreaking() {
        ImmutableList knownHarvestTags = ImmutableList.of((Object)BlockTags.MINEABLE_WITH_AXE, (Object)BlockTags.MINEABLE_WITH_PICKAXE, (Object)BlockTags.MINEABLE_WITH_SHOVEL, (Object)IETags.wirecutterHarvestable, (Object)IETags.hammerHarvestable);
        Set harvestable = knownHarvestTags.stream().map(x$0 -> this.tag((TagKey)x$0)).map(TagsProvider.TagAppender::getInternalBuilder).flatMap(b -> b.build().stream()).map(Object::toString).map(ResourceLocation::tryParse).filter(Objects::nonNull).collect(Collectors.toSet());
        Set knownNonHarvestable = Stream.of(IEBlocks.Cloth.BALLOON, IEBlocks.Cloth.CUSHION, IEBlocks.Misc.FAKE_LIGHT, IEBlocks.Misc.POTTED_HEMP, IEBlocks.Misc.HEMP_PLANT).map(IEBlocks.BlockEntry::getId).collect(Collectors.toSet());
        Set registered = IEBlocks.REGISTER.getEntries().stream().map(Holder::value).filter(b -> !(b instanceof IEFluidBlock)).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).filter(name -> !knownNonHarvestable.contains(name)).collect(Collectors.toSet());
        Sets.SetView notHarvestable = Sets.difference(registered, harvestable);
        if (!notHarvestable.isEmpty()) {
            notHarvestable.forEach(rl -> IELogger.logger.error("Not harvestable: {}", rl));
            throw new RuntimeException();
        }
    }
}

