/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.resources;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.data.recipes.IERecipeProvider;
import blusunrize.immersiveengineering.data.resources.SecondaryOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public enum RecipeMetals {
    IRON("iron", true, true, new SecondaryOutput(IETags.getDust((String)"nickel"), 0.1f)),
    GOLD("gold", true, true, new SecondaryOutput[0]),
    COPPER("copper", true, true, new SecondaryOutput(IETags.getDust((String)"gold"), 0.1f)),
    ALUMINUM("aluminum", true, true, new SecondaryOutput[0]),
    LEAD("lead", true, true, new SecondaryOutput(IETags.getDust((String)"silver"), 0.1f)),
    SILVER("silver", true, true, new SecondaryOutput(IETags.getDust((String)"lead"), 0.1f)),
    NICKEL("nickel", true, true, new SecondaryOutput(IETags.getDust((String)"platinum"), 0.1f)),
    URANIUM("uranium", true, true, new SecondaryOutput(IETags.getDust((String)"lead"), 0.1f)),
    CONSTANTAN("constantan", true, new AlloyProperties(2, new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot), new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).ingot))),
    ELECTRUM("electrum", true, new AlloyProperties(2, new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.GOLD).ingot), new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).ingot))),
    STEEL("steel", true, false, new SecondaryOutput[0]),
    TIN("tin", false, true, new SecondaryOutput[0]),
    ZINC("zinc", false, true, new SecondaryOutput[0]),
    PLATINUM("platinum", false, true, new SecondaryOutput(IETags.getDust((String)"nickel"), 0.1f)),
    TUNGSTEN("tungsten", false, true, new SecondaryOutput[0]),
    OSMIUM("osmium", false, true, new SecondaryOutput[0]),
    COBALT("cobalt", false, true, new SecondaryOutput[0]),
    ARDITE("ardite", false, true, new SecondaryOutput[0]),
    BRONZE("bronze", false, new AlloyProperties(4, new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot, 3), new IngredientWithSize(TagUtils.createItemWrapper((ResourceLocation)IETags.getIngot((String)"tin")))).addConditions(IERecipeProvider.getTagCondition(IETags.getIngot((String)"tin")))),
    BRASS("brass", false, new AlloyProperties(2, new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot), new IngredientWithSize(TagUtils.createItemWrapper((ResourceLocation)IETags.getIngot((String)"zinc")))).addConditions(IERecipeProvider.getTagCondition(IETags.getIngot((String)"zinc")))),
    INVAR("invar", false, new AlloyProperties(3, new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot, 2), new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).ingot))),
    ROSE_GOLD("rose_gold", false, new AlloyProperties(4, new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot, 3), new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.GOLD).ingot))),
    MANYULLYN("manyullyn", false, new AlloyProperties(4, new IngredientWithSize(TagUtils.createItemWrapper((ResourceLocation)IETags.getIngot((String)"cobalt")), 3), new IngredientWithSize(Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}))).addConditions(IERecipeProvider.getTagCondition(IETags.getIngot((String)"cobalt"))));

    private final String name;
    private final boolean isNative;
    private final TagKey<Item> ingot;
    private final TagKey<Item> dust;
    private final TagKey<Item> ore;
    private final TagKey<Item> rawOre;
    private final TagKey<Item> rawBlock;
    private final AlloyProperties alloyProperties;
    private final SecondaryOutput[] secondaryOutputs;

    private RecipeMetals(String name, boolean isNative, boolean hasOre, AlloyProperties alloyProperties, SecondaryOutput ... secondaryOutputs) {
        this.name = name;
        this.ingot = TagUtils.createItemWrapper((ResourceLocation)IETags.getIngot((String)name));
        this.dust = TagUtils.createItemWrapper((ResourceLocation)IETags.getDust((String)name));
        this.isNative = isNative;
        this.ore = !hasOre ? null : TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)name));
        this.rawOre = !hasOre ? null : TagUtils.createItemWrapper((ResourceLocation)IETags.getRawOre((String)name));
        this.rawBlock = !hasOre ? null : TagUtils.createItemWrapper((ResourceLocation)IETags.getRawBlock((String)name));
        this.alloyProperties = alloyProperties;
        this.secondaryOutputs = secondaryOutputs;
    }

    private RecipeMetals(String name, boolean isNative, boolean hasOre, SecondaryOutput ... secondaryOutputs) {
        this(name, isNative, hasOre, (AlloyProperties)null, secondaryOutputs);
    }

    private RecipeMetals(String name, boolean isNative, AlloyProperties alloyProperties) {
        this(name, isNative, false, alloyProperties, new SecondaryOutput[0]);
    }

    public String getName() {
        return this.name;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public TagKey<Item> getIngot() {
        return this.ingot;
    }

    public TagKey<Item> getDust() {
        return this.dust;
    }

    public TagKey<Item> getOre() {
        return this.ore;
    }

    public TagKey<Item> getRawOre() {
        return this.rawOre;
    }

    public TagKey<Item> getRawBlock() {
        return this.rawBlock;
    }

    public AlloyProperties getAlloyProperties() {
        return this.alloyProperties;
    }

    public SecondaryOutput[] getSecondaryOutputs() {
        return this.secondaryOutputs;
    }

    public static class AlloyProperties {
        private final int outputSize;
        private final IngredientWithSize[] alloyIngredients;
        private final List<ICondition> conditions = new ArrayList<ICondition>();

        AlloyProperties(int outputSize, IngredientWithSize ... alloyIngredients) {
            this.outputSize = outputSize;
            this.alloyIngredients = alloyIngredients;
        }

        public AlloyProperties addConditions(ICondition ... conditions) {
            Collections.addAll(this.conditions, conditions);
            return this;
        }

        public int getOutputSize() {
            return this.outputSize;
        }

        public IngredientWithSize[] getAlloyIngredients() {
            return this.alloyIngredients;
        }

        public List<ICondition> getConditions() {
            return this.conditions;
        }

        public boolean isSimple() {
            return this.alloyIngredients.length == 2;
        }
    }
}

