/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.data.recipes.builder.BaseHelpers;
import blusunrize.immersiveengineering.data.recipes.builder.IERecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.common.conditions.ICondition;

public class ArcFurnaceRecipeBuilder
extends IERecipeBuilder<ArcFurnaceRecipeBuilder>
implements BaseHelpers.ItemInput<ArcFurnaceRecipeBuilder>,
BaseHelpers.ItemOutput<ArcFurnaceRecipeBuilder> {
    private IngredientWithSize input;
    private final List<IngredientWithSize> additives = new ArrayList<IngredientWithSize>();
    private final List<TagOutput> output = new ArrayList<TagOutput>();
    private final List<StackWithChance> secondaries = new ArrayList<StackWithChance>();
    private TagOutput slag = TagOutput.EMPTY;
    private int energy;
    private int time;

    private ArcFurnaceRecipeBuilder() {
    }

    public static ArcFurnaceRecipeBuilder builder() {
        return new ArcFurnaceRecipeBuilder();
    }

    @Override
    public ArcFurnaceRecipeBuilder input(IngredientWithSize ingredient) {
        this.input = ingredient;
        return this;
    }

    @Override
    public ArcFurnaceRecipeBuilder output(TagOutput output) {
        this.output.add(output);
        return this;
    }

    public ArcFurnaceRecipeBuilder additive(IngredientWithSize ingredient) {
        this.additives.add(ingredient);
        return this;
    }

    public ArcFurnaceRecipeBuilder additive(TagKey<Item> additive) {
        return this.additive(new IngredientWithSize(additive));
    }

    public ArcFurnaceRecipeBuilder slag(TagKey<Item> item, int count) {
        this.slag = new TagOutput(item, count);
        return this;
    }

    public ArcFurnaceRecipeBuilder setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public ArcFurnaceRecipeBuilder setTime(int time) {
        this.time = time;
        return this;
    }

    public ArcFurnaceRecipeBuilder secondary(TagKey<Item> ingot, float chance, ICondition ... conditions) {
        this.secondaries.add(new StackWithChance(new TagOutput(ingot), chance, conditions));
        return this;
    }

    public void build(RecipeOutput out, ResourceLocation name) {
        ArcFurnaceRecipe recipe = new ArcFurnaceRecipe(new TagOutputList(this.output), this.slag, this.secondaries, this.time, this.energy, this.input, this.additives);
        out.accept(name, (Recipe)recipe, null, this.getConditions());
    }
}

