/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.models;

import blusunrize.immersiveengineering.client.utils.ModelUtils;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.math.Transformation;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.common.util.TransformationHelper;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TransformationMap {
    private final Map<ItemDisplayContext, ItemTransform> transforms = new EnumMap<ItemDisplayContext, ItemTransform>(ItemDisplayContext.class);

    public static Vector3f toXYZDegrees(Quaternionf q) {
        float iSq = q.x * q.x;
        float jSq = q.y * q.y;
        float kSq = q.z * q.z;
        float angleX = (float)Math.atan2(2.0f * (q.w * q.x - q.y * q.z), 1.0f - 2.0f * (iSq + jSq));
        float sinOfY = 2.0f * (q.w * q.y + q.x * q.z);
        float angleY = (double)Math.abs(sinOfY) >= 0.999999 ? Math.copySign(1.5707964f, sinOfY) : (float)Math.asin(sinOfY);
        float angleZ = (float)Math.atan2(2.0f * (q.w * q.z - q.y * q.x), 1.0f - 2.0f * (jSq + kSq));
        Preconditions.checkState((boolean)Float.isFinite(angleX), (Object)q);
        Preconditions.checkState((boolean)Float.isFinite(angleY), (Object)q);
        Preconditions.checkState((boolean)Float.isFinite(angleZ), (Object)q);
        Vector3f result = new Vector3f(angleX, angleY, angleZ);
        result.mul(57.295776f);
        return result;
    }

    public void addFromJson(String json) {
        Gson GSON = new GsonBuilder().registerTypeAdapter(Transformation.class, (Object)new TransformationHelper.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).create();
        JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
        Optional<String> type = Optional.ofNullable(obj.remove("type")).map(JsonElement::getAsString);
        boolean vanilla = type.map("vanilla"::equals).orElse(false);
        EnumMap<ItemDisplayContext, Transformation> transforms = new EnumMap<ItemDisplayContext, Transformation>(ItemDisplayContext.class);
        for (ItemDisplayContext perspective : ItemDisplayContext.values()) {
            Transformation transform;
            String key = perspective.getSerializedName();
            JsonObject forType = obj.getAsJsonObject(key);
            obj.remove(key);
            if (forType == null) {
                key = this.alternateName(perspective);
                forType = obj.getAsJsonObject(key);
                obj.remove(key);
            }
            if (forType != null) {
                if (vanilla) {
                    ItemTransform vanillaTransform = (ItemTransform)GSON.fromJson((JsonElement)forType, ItemTransform.class);
                    transform = ModelUtils.fromItemTransform((ItemTransform)vanillaTransform, (boolean)false);
                } else {
                    transform = this.readMatrix(forType, GSON);
                    if (type.map("no_corner_offset"::equals).orElse(false).booleanValue()) {
                        transform = transform.blockCornerToCenter();
                    }
                }
            } else {
                transform = Transformation.identity();
            }
            transforms.put(perspective, transform);
        }
        Transformation baseTransform = obj.size() > 0 ? this.readMatrix(obj, GSON) : Transformation.identity();
        for (Map.Entry e : transforms.entrySet()) {
            Transformation transform = TransformationMap.composeForgeLike((Transformation)e.getValue(), baseTransform);
            if (transform.isIdentity()) continue;
            Vector3f translation = new Vector3f((Vector3fc)transform.getTranslation());
            translation.mul(16.0f);
            this.transforms.put((ItemDisplayContext)e.getKey(), new ItemTransform(TransformationMap.toXYZDegrees(transform.getLeftRotation()), translation, transform.getScale(), TransformationMap.toXYZDegrees(transform.getRightRotation())));
        }
    }

    private static Transformation composeForgeLike(Transformation a, Transformation b) {
        if (a.isIdentity()) {
            return b;
        }
        if (b.isIdentity()) {
            return a;
        }
        Matrix4f m = a.getMatrix();
        m.mul((Matrix4fc)b.getMatrix());
        return new Transformation(m);
    }

    private Transformation readMatrix(JsonObject json, Gson GSON) {
        if (!json.has("origin")) {
            json.addProperty("origin", "corner");
        }
        return (Transformation)GSON.fromJson((JsonElement)json, Transformation.class);
    }

    private String alternateName(ItemDisplayContext type) {
        return type.name().toLowerCase(Locale.US);
    }

    public JsonObject toJson() {
        JsonObject ret = new JsonObject();
        for (Map.Entry<ItemDisplayContext, ItemTransform> entry : this.transforms.entrySet()) {
            this.add(ret, entry.getKey(), entry.getValue());
        }
        return ret;
    }

    private void add(JsonObject main, ItemDisplayContext type, ItemTransform trsr) {
        JsonObject result = new JsonObject();
        if (!trsr.translation.equals((Object)ItemTransform.Deserializer.DEFAULT_TRANSLATION)) {
            result.add("translation", (JsonElement)TransformationMap.toJson(trsr.translation));
        }
        if (!trsr.rotation.equals((Object)ItemTransform.Deserializer.DEFAULT_ROTATION)) {
            result.add("rotation", (JsonElement)TransformationMap.toJson(trsr.rotation));
        }
        if (!trsr.scale.equals((Object)ItemTransform.Deserializer.DEFAULT_SCALE)) {
            result.add("scale", (JsonElement)TransformationMap.toJson(trsr.scale));
        }
        if (!trsr.rightRotation.equals((Object)ItemTransform.Deserializer.DEFAULT_ROTATION)) {
            result.add("right_rotation", (JsonElement)TransformationMap.toJson(trsr.rightRotation));
        }
        main.add(type.getSerializedName(), (JsonElement)result);
    }

    private static JsonArray toJson(Vector3f v) {
        JsonArray ret = new JsonArray();
        ret.add((Number)Float.valueOf(v.x()));
        ret.add((Number)Float.valueOf(v.y()));
        ret.add((Number)Float.valueOf(v.z()));
        return ret;
    }
}

