/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.items.ShaderItem;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.register.IEBannerPatterns;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.IEShaders;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class Language
extends LanguageProvider {
    final ExistingFileHelper existingFileHelper;
    private final ResourceLocation baseLangFile;

    public Language(PackOutput output, ExistingFileHelper existingFileHelper, String locale) {
        super(output, "immersiveengineering", locale);
        this.existingFileHelper = existingFileHelper;
        this.baseLangFile = IEApi.ieLoc((String)locale);
    }

    protected void addTranslations() {
        try {
            Gson gson = new Gson();
            Resource resource = this.existingFileHelper.getResource(this.baseLangFile, PackType.CLIENT_RESOURCES, ".json", "lang_base");
            BufferedReader reader = resource.openAsReader();
            JsonObject object = (JsonObject)GsonHelper.fromJson((Gson)gson, (Reader)reader, JsonObject.class);
            for (String key : object.keySet()) {
                this.add(key, object.get(key).getAsString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failure to read base language file", e);
        }
        this.addBanners();
        this.addItems();
        this.addShaders();
        this.addSigns(IEBlocks.WoodenDecoration.SIGN);
        this.addSigns(IEBlocks.MetalDecoration.STEEL_SIGN);
        this.addSigns(IEBlocks.MetalDecoration.ALU_SIGN);
        this.verify();
    }

    private void addItems() {
        this.addItem((Supplier)IEItems.Misc.SHADER_BAG.get(Rarity.COMMON), "Common Shader Grabbag");
        this.addItem((Supplier)IEItems.Misc.SHADER_BAG.get(Rarity.UNCOMMON), "Uncommon Shader Grabbag");
        this.addItem((Supplier)IEItems.Misc.SHADER_BAG.get(Rarity.RARE), "Rare Shader Grabbag");
        this.addItem((Supplier)IEItems.Misc.SHADER_BAG.get(Rarity.EPIC), "Epic Shader Grabbag");
        this.addItem((Supplier)IEItems.Misc.SHADER_BAG.get(Lib.RARITY_MASTERWORK.getValue()), "Masterwork Shader Grabbag");
        this.addBullets();
    }

    private void addShaders() {
        this.addShader(IEShaders.ROSEQUARTZ, "Rosequartz");
        this.addShader(IEShaders.ARGO, "Argo");
        this.addShader(IEShaders.SUNSTRIKE, "Sunstrike");
        this.addShader(IEShaders.LOCUS, "Locus");
        this.addShader(IEShaders.FELIX, "Felix");
        this.addShader(IEShaders.SHARKFACE, "Sharkface");
        this.addShader(IEShaders.DRAGONSBREATH, "Dragon's Breath");
        this.addShader(IEShaders.HAWK, "Hawk");
        this.addShader(IEShaders.EYAS, "Eyas");
        this.addShader(IEShaders.MAGNUM, "Magnum");
        this.addShader(IEShaders.FOX, "Fox");
        this.addShader(IEShaders.VAULTTEC, "Vault-Tec");
        this.addShader(IEShaders.SPONSOR, "Sponsor");
        this.addShader(IEShaders.MASSFUSION, "Mass Fusion");
        this.addShader(IEShaders.STORMFLOWER, "StormFlower");
        this.addShader(IEShaders.MILO, "Mil\u00f3");
        this.addShader(IEShaders.TRIDENT, "Trident");
        this.addShader(IEShaders.CHLORIS, "Chloris");
        this.addShader(IEShaders.CRESCENTROSE, "Crescent Rose");
        this.addShader(IEShaders.QROW, "Qrow");
        this.addShader(IEShaders.LUSUSNATURAE, "Lusus Naturae");
        this.addShader(IEShaders.VANGUARD, "Vanguard");
        this.addShader(IEShaders.REGAL, "Regal");
        this.addShader(IEShaders.HARROWED, "Harrowed");
        this.addShader(IEShaders.TAKEN, "Taken");
        this.addShader(IEShaders.IKELOS, "IKELOS");
        this.addShader(IEShaders.ANGELSTHESIS, "Angel's Thesis");
        this.addShader(IEShaders.SUTHERLAND, "Sutherland");
        this.addShader(IEShaders.EXIA, "Exia");
        this.addShader(IEShaders.CRIMSONLOTUS, "Crimson Lotus");
        this.addShader(IEShaders.DOMINATOR, "Dominator");
        this.addShader(IEShaders.WARBIRD, "Warbird");
        this.addShader(IEShaders.MATRIX, "Matrix");
        this.addShader(IEShaders.TWILI, "Twili");
        this.addShader(IEShaders.USURPER, "Usurper");
        this.addShader(IEShaders.ANCIENT, "Ancient");
        this.addShader(IEShaders.GLACIS, "Glacis");
        this.addShader(IEShaders.PHOENIX, "Phoenix");
        this.addShader(IEShaders.RADIANT, "Radiant");
        this.addShader(IEShaders.HOLLOW, "Hollow");
        this.addShader(IEShaders.MICROSHARK, "Microshark");
        this.addShader(IEShaders.N7, "N7");
        this.addShader(IEShaders.NORMANDY, "Normandy");
        this.addShader(IEShaders.OMNITOOL, "OmniTool");
        this.addShader(IEShaders.KINDLED, "The Kindled");
        this.addShader(IEShaders.DARKFIRE, "Dark Fire");
        this.addShader(IEShaders.ERRUPTION, "Erruption");
        this.addShader(IEShaders.WAAAGH, "WAAAGH!");
        this.addShader(IEShaders.ASTARTES, "Astartes");
        this.addShader(IEShaders.NETHERFORGED, "Netherforged");
        this.addShader(IEShaders.TRANSPRIDE, "Break the Cis-tem");
        this.addShader(IEShaders.ENBYPRIDE, "NB");
        this.addShader(IEShaders.GAYPRIDE, "Boys love Boys");
        this.addShader(IEShaders.LESBIANPRIDE, "Girls love Girls");
        this.addShader(IEShaders.BIPRIDE, "Love them both");
        this.addShader(IEShaders.ACEPRIDE, "The Ace");
    }

    private void addShader(ShaderRegistry.ShaderRegistryEntry shader, String translation) {
        this.add(ShaderItem.getShaderNameKey((ResourceLocation)shader.name), translation);
    }

    private void addBanners() {
        for (IEBannerPatterns.BannerEntry banner : IEBannerPatterns.ALL_BANNERS) {
            for (ResourceKey pattern : banner.patterns()) {
                String key = pattern.location().getPath();
                String[] keyParts = key.split("_");
                Object bannerName = Utils.toCamelCase((String)keyParts[0]);
                if (keyParts.length > 1) {
                    bannerName = (String)bannerName + " (" + Utils.toCamelCase((String)keyParts[1]) + ")";
                }
                for (DyeColor dye : DyeColor.values()) {
                    String color = dye.getSerializedName();
                    this.add("block.minecraft.banner.immersiveengineering." + key + "." + color, I18n.get((String)("color.minecraft." + color), (Object[])new Object[0]) + " " + (String)bannerName);
                }
            }
        }
    }

    private void addSigns(IEBlocks.SignHolder holder) {
        String key = holder.baseName();
        String name = Pattern.compile("(?:^|_)([a-z])").matcher(key).replaceAll(m -> " " + m.group(1).toUpperCase()).trim();
        this.add("block.immersiveengineering." + key + "_sign", name + " Sign");
        this.add("block.immersiveengineering." + key + "_wall_sign", name + " Sign");
        this.add("block.immersiveengineering." + key + "_hanging_sign", name + " Hanging Sign");
        this.add("block.immersiveengineering." + key + "_wall_hanging_sign", name + " Hanging Sign");
    }

    private void addBullets() {
        this.addBullet(IEBullets.ARMOR_PIERCING, "Armor-Piercing Cartridge");
        this.addBullet(IEBullets.BUCKSHOT, "Buckshot Cartridge");
        this.addBullet(IEBullets.CASULL, "Casull Cartridge");
        this.addBullet(IEBullets.DRAGONS_BREATH, "Dragon's Breath Cartridge");
        this.addBullet(IEBullets.FIREWORK, "Firework Cartridge");
        this.addBullet(IEBullets.FLARE, "Flare Cartridge");
        this.addBullet(IEBullets.HIGH_EXPLOSIVE, "High-Explosive Cartridge");
        this.addBullet(IEBullets.HOMING, "Homing Cartridge");
        this.addBullet(IEBullets.POTION, "Phial Cartridge");
        this.addBullet(IEBullets.SILVER, "Silver Cartridge");
        this.addBullet(IEBullets.WOLFPACK, "Wolfpack Cartridge");
    }

    private void addBullet(ResourceLocation bullet, String name) {
        this.addItem((Supplier)IEItems.Weapons.BULLETS.get(BulletHandler.getBullet((ResourceLocation)bullet)), name);
    }

    private void verify() {
        Map mapData = (Map)Preconditions.checkNotNull((Object)((Map)ObfuscationReflectionHelper.getPrivateValue(LanguageProvider.class, (Object)((Object)this), (String)"data")));
        MutableBoolean failed = new MutableBoolean();
        for (DeferredHolder item : IEItems.REGISTER.getEntries()) {
            if (item.getKey().location().getPath().startsWith("fake_icon")) continue;
            this.assertMapped(mapData, failed, ((Item)item.get()).getDescriptionId(((Item)item.get()).getDefaultInstance()));
        }
        for (ResourceLocation shader : ShaderRegistry.shaderRegistry.keySet()) {
            this.assertMapped(mapData, failed, ShaderItem.getShaderNameKey((ResourceLocation)shader));
        }
        if (failed.booleanValue()) {
            throw new RuntimeException("Missing expected translation keys!");
        }
    }

    private void assertMapped(Map<String, String> mappedValues, MutableBoolean failed, String key) {
        if (!mappedValues.containsKey(key)) {
            IELogger.logger.error("No mapping for {} found!", (Object)key);
            failed.setTrue();
        }
    }
}

