/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data;

import blusunrize.immersiveengineering.data.Advancements;
import blusunrize.immersiveengineering.data.BiomeTags;
import blusunrize.immersiveengineering.data.DynamicModels;
import blusunrize.immersiveengineering.data.EntityTypeTags;
import blusunrize.immersiveengineering.data.FluidTags;
import blusunrize.immersiveengineering.data.ItemModels;
import blusunrize.immersiveengineering.data.Language;
import blusunrize.immersiveengineering.data.StructureUpdater;
import blusunrize.immersiveengineering.data.blockstates.BlockStates;
import blusunrize.immersiveengineering.data.blockstates.ConnectorBlockStates;
import blusunrize.immersiveengineering.data.blockstates.MultiblockStates;
import blusunrize.immersiveengineering.data.dynregistry.WorldGenerationProvider;
import blusunrize.immersiveengineering.data.loot.AllLoot;
import blusunrize.immersiveengineering.data.loot.LootModifierProvider;
import blusunrize.immersiveengineering.data.manual.ManualDataGenerator;
import blusunrize.immersiveengineering.data.recipes.CompostMapProvider;
import blusunrize.immersiveengineering.data.recipes.RootRecipeProvider;
import blusunrize.immersiveengineering.data.tags.IEBlockTags;
import blusunrize.immersiveengineering.data.tags.IEItemTags;
import blusunrize.immersiveengineering.data.tags.MovableTags;
import blusunrize.immersiveengineering.data.tags.PoiTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="immersiveengineering", bus=EventBusSubscriber.Bus.MOD)
public class IEDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        ExistingFileHelper exHelper = event.getExistingFileHelper();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        if (event.includeServer()) {
            IEBlockTags blockTags = new IEBlockTags(output, lookup, exHelper);
            gen.addProvider(true, (DataProvider)blockTags);
            gen.addProvider(true, (DataProvider)new IEItemTags(output, lookup, blockTags.contentsGetter(), exHelper));
            gen.addProvider(true, (DataProvider)new FluidTags(output, lookup, exHelper));
            gen.addProvider(true, (DataProvider)new MovableTags(output, lookup, exHelper));
            gen.addProvider(true, (DataProvider)new PoiTags(output, lookup, exHelper));
            gen.addProvider(true, (DataProvider)new EntityTypeTags(output, lookup, exHelper));
            gen.addProvider(true, (DataProvider)new BiomeTags(output, lookup, exHelper));
            gen.addProvider(true, (DataProvider)new RootRecipeProvider(output, lookup));
            gen.addProvider(true, (DataProvider)new AllLoot(output, lookup));
            gen.addProvider(true, (DataProvider)new BlockStates(output, exHelper));
            gen.addProvider(true, (DataProvider)new CompostMapProvider(output, lookup));
            MultiblockStates multiblocks = new MultiblockStates(output, exHelper);
            gen.addProvider(true, (DataProvider)multiblocks);
            gen.addProvider(true, (DataProvider)new ConnectorBlockStates(output, exHelper));
            gen.addProvider(true, (DataProvider)new ItemModels(output, exHelper, multiblocks));
            gen.addProvider(true, (DataProvider)new Advancements(output, lookup, exHelper));
            gen.addProvider(true, (DataProvider)new StructureUpdater("structure/multiblocks", "immersiveengineering", exHelper, output));
            gen.addProvider(true, (DataProvider)new StructureUpdater("structure/village", "immersiveengineering", exHelper, output));
            gen.addProvider(true, (DataProvider)new DynamicModels(multiblocks, output, exHelper));
            gen.addProvider(true, (DataProvider)new LootModifierProvider(output, lookup));
            gen.addProvider(true, (DataProvider)new Language(output, exHelper, "en_us"));
            for (DataProvider provider : WorldGenerationProvider.makeProviders(output, lookup, exHelper)) {
                gen.addProvider(true, provider);
            }
            ManualDataGenerator.addProviders(gen, exHelper);
        }
    }
}

