/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.apache.commons.io.IOUtils;

public class DataGenUtils {
    private static final Pattern MTLLIB = Pattern.compile("^mtllib\\s+(.*)$", 8);
    private static final Pattern USEMTL = Pattern.compile("^usemtl\\s+(.*)$", 8);
    private static final Pattern NEWMTL = Pattern.compile("^newmtl\\s+(.*)$", 8);
    private static final Pattern MAP_KD = Pattern.compile("^map_Kd\\s+(.*)$", 8);

    public static String getTextureFromObj(ResourceLocation obj, ExistingFileHelper helper) {
        try {
            String prefix = "models";
            if (obj.getPath().startsWith("models/")) {
                prefix = "";
            }
            Resource objResource = helper.getResource(obj, PackType.CLIENT_RESOURCES, "", prefix);
            InputStream objStream = objResource.open();
            String fullObj = IOUtils.toString((InputStream)objStream, (Charset)StandardCharsets.US_ASCII);
            String libLoc = DataGenUtils.findFirstOccurrenceGroup(MTLLIB, fullObj);
            String libName = DataGenUtils.findFirstOccurrenceGroup(USEMTL, fullObj);
            ResourceLocation libRL = DataGenUtils.relative(obj, libLoc);
            return DataGenUtils.getMTLTexture(libRL, libName, helper);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMTLTexture(ResourceLocation mtl, String materialName, ExistingFileHelper helper) {
        try {
            Resource mtlResource = helper.getResource(mtl, PackType.CLIENT_RESOURCES, "", "models");
            String fullMtl = IOUtils.toString((InputStream)mtlResource.open(), (Charset)StandardCharsets.US_ASCII);
            Matcher materialMatcher = NEWMTL.matcher(fullMtl);
            while (materialMatcher.find() && !materialMatcher.group(1).equals(materialName)) {
            }
            int materialStart = materialMatcher.start();
            int materialEnd = materialMatcher.find() ? materialMatcher.start() : fullMtl.length();
            String material = fullMtl.substring(materialStart, materialEnd);
            return DataGenUtils.findFirstOccurrenceGroup(MAP_KD, material);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String findFirstOccurrenceGroup(Pattern pattern, String input) {
        Matcher matcher = pattern.matcher(input);
        Preconditions.checkArgument((boolean)matcher.find());
        return matcher.group(1);
    }

    private static ResourceLocation relative(ResourceLocation base, String relativePath) {
        String basePath = base.getPath();
        String lastDir = basePath.substring(0, basePath.lastIndexOf(47) + 1);
        return base.withPath(lastDir + relativePath);
    }
}

