/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class IEOreFeature
extends Feature<IEOreFeatureConfig> {
    public IEOreFeature() {
        super(IEOreFeatureConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<IEOreFeatureConfig> ctx) {
        IEOreFeatureConfig config = (IEOreFeatureConfig)ctx.config();
        OreConfiguration vanillaConfig = new OreConfiguration(config.targetList, config.getSize(), (float)config.getAirExposure());
        return Feature.ORE.place(new FeaturePlaceContext(Optional.empty(), ctx.level(), ctx.chunkGenerator(), ctx.random(), ctx.origin(), (FeatureConfiguration)vanillaConfig));
    }

    public record IEOreFeatureConfig(List<OreConfiguration.TargetBlockState> targetList, IEServerConfig.Ores.VeinType type) implements FeatureConfiguration
    {
        public static final Codec<IEOreFeatureConfig> CODEC = RecordCodecBuilder.create(app -> app.group((App)Codec.list((Codec)OreConfiguration.TargetBlockState.CODEC).fieldOf("targets").forGetter(cfg -> cfg.targetList), (App)IEServerConfig.Ores.VeinType.CODEC.fieldOf("type").forGetter(cfg -> cfg.type)).apply((Applicative)app, IEOreFeatureConfig::new));

        public int getSize() {
            return (Integer)IEServerConfig.ORES.ores.get((Object)((Object)this.type)).veinSize.get();
        }

        public double getAirExposure() {
            return (Double)IEServerConfig.ORES.ores.get((Object)((Object)this.type)).airExposure.get();
        }
    }
}

