/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items.bullets;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.ShieldDisablingHandler;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.items.bullets.FireworkBullet;
import blusunrize.immersiveengineering.common.items.bullets.FlareBullet;
import blusunrize.immersiveengineering.common.items.bullets.HomingBullet;
import blusunrize.immersiveengineering.common.items.bullets.PotionBullet;
import blusunrize.immersiveengineering.common.items.bullets.WolfpackBullet;
import blusunrize.immersiveengineering.common.items.bullets.WolfpackPartBullet;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import com.google.common.base.Supplier;
import com.mojang.datafixers.util.Unit;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ModConfigSpec;

public class IEBullets {
    public static final ResourceLocation CASULL = IEApi.ieLoc("casull");
    public static final ResourceLocation ARMOR_PIERCING = IEApi.ieLoc("armor_piercing");
    public static final ResourceLocation BUCKSHOT = IEApi.ieLoc("buckshot");
    public static final ResourceLocation HIGH_EXPLOSIVE = IEApi.ieLoc("he");
    public static final ResourceLocation SILVER = IEApi.ieLoc("silver");
    public static final ResourceLocation DRAGONS_BREATH = IEApi.ieLoc("dragons_breath");
    public static final ResourceLocation POTION = IEApi.ieLoc("potion");
    public static final ResourceLocation FLARE = IEApi.ieLoc("flare");
    public static final ResourceLocation FIREWORK = IEApi.ieLoc("firework");
    public static final ResourceLocation HOMING = IEApi.ieLoc("homing");
    public static final ResourceLocation WOLFPACK = IEApi.ieLoc("wolfpack");
    public static final ResourceLocation WOLFPACK_PART = IEApi.ieLoc("wolfpack_part");
    public static final BulletHandler.IBullet<Color4> FLARE_TYPE = new FlareBullet();

    public static void initBullets() {
        BulletHandler.registerBullet(CASULL, new BulletHandler.DamagingBullet<Unit>(BulletHandler.CodecsAndDefault.UNIT, (projectile, shooter, hit) -> IEDamageSources.causeCasullDamage((RevolvershotEntity)projectile, shooter), () -> ((ModConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Casull).get(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing.asItem().getDefaultInstance()), IEApi.ieLoc("item/bullet_casull")));
        BulletHandler.registerBullet(ARMOR_PIERCING, new BulletHandler.DamagingBullet<Unit>(BulletHandler.CodecsAndDefault.UNIT, (projectile, shooter, hit) -> IEDamageSources.causePiercingDamage((RevolvershotEntity)projectile, shooter), () -> ((ModConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_AP).get(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing.asItem().getDefaultInstance()), IEApi.ieLoc("item/bullet_armor_piercing")));
        BulletHandler.registerBullet(BUCKSHOT, new BulletHandler.DamagingBullet<Unit>(BulletHandler.CodecsAndDefault.UNIT, (projectile, shooter, hit) -> IEDamageSources.causeBuckshotDamage((RevolvershotEntity)projectile, shooter), () -> ((ModConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Buck).get(), true, false, () -> BulletHandler.emptyShell.asItem().getDefaultInstance(), new ResourceLocation[]{IEApi.ieLoc("item/bullet_buckshot")}){

            @Override
            public int getProjectileCount(Player shooter) {
                return 10;
            }

            @Override
            public void onHitTarget(Level world, HitResult rtr, @Nullable UUID shooterUUID, Entity projectile, boolean headshot, Unit bulletData) {
                LivingEntity livingTarget;
                EntityHitResult target;
                Entity entity;
                super.onHitTarget(world, rtr, shooterUUID, projectile, headshot, bulletData);
                if (rtr instanceof EntityHitResult && (entity = (target = (EntityHitResult)rtr).getEntity()) instanceof LivingEntity && (livingTarget = (LivingEntity)entity).isBlocking() && livingTarget.getRandom().nextFloat() < 0.15f) {
                    ShieldDisablingHandler.attemptDisabling(livingTarget);
                }
            }
        });
        BulletHandler.registerBullet(HIGH_EXPLOSIVE, new BulletHandler.DamagingBullet<Unit>(BulletHandler.CodecsAndDefault.UNIT, null, 0.0f, () -> BulletHandler.emptyShell.asItem().getDefaultInstance(), new ResourceLocation[]{IEApi.ieLoc("item/bullet_he")}){

            @Override
            public void onHitTarget(Level world, HitResult target, UUID shooterId, Entity projectile, boolean headshot, Unit bulletData) {
                Entity shooter = null;
                if (shooterId != null && world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    shooter = serverLevel.getEntity(shooterId);
                }
                world.explode(shooter, projectile.getX(), projectile.getY(), projectile.getZ(), 2.0f, Level.ExplosionInteraction.MOB);
            }

            @Override
            public Entity getProjectile(@Nullable Player shooter, Unit ignored, Entity projectile, boolean charged) {
                if (projectile instanceof RevolvershotEntity) {
                    ((RevolvershotEntity)projectile).setGravity(0.05f);
                    ((RevolvershotEntity)projectile).setMovementDecay(0.9f);
                }
                return projectile;
            }

            @Override
            public SoundEvent getSound() {
                return (SoundEvent)IESounds.revolverFireThump.value();
            }
        });
        BulletHandler.registerBullet(SILVER, new BulletHandler.DamagingBullet<Unit>(BulletHandler.CodecsAndDefault.UNIT, (projectile, shooter, hit) -> IEDamageSources.causeSilverDamage((RevolvershotEntity)projectile, shooter), () -> ((ModConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Silver).get(), () -> BulletHandler.emptyCasing.asItem().getDefaultInstance(), new ResourceLocation[]{IEApi.ieLoc("item/bullet_silver")}){

            @Override
            protected float getDamage(Entity hitEntity, boolean headshot) {
                float dmg = super.getDamage(hitEntity, headshot);
                if (hitEntity instanceof LivingEntity && ((LivingEntity)hitEntity).isInvertedHealAndHarm()) {
                    dmg = (float)((double)dmg * 1.5);
                }
                return dmg;
            }
        });
        BulletHandler.registerBullet(DRAGONS_BREATH, new BulletHandler.DamagingBullet<Unit>(BulletHandler.CodecsAndDefault.UNIT, (projectile, shooter, hit) -> IEDamageSources.causeDragonsbreathDamage((RevolvershotEntity)projectile, shooter), () -> ((ModConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Dragon).get(), true, true, () -> BulletHandler.emptyShell.asItem().getDefaultInstance(), new ResourceLocation[]{IEApi.ieLoc("item/bullet_dragons_breath")}){

            @Override
            public int getProjectileCount(Player shooter) {
                return 30;
            }

            @Override
            public Entity getProjectile(Player shooter, Unit ignored, Entity projectile, boolean electro) {
                ((RevolvershotEntity)projectile).setTickLimit(10);
                projectile.igniteForSeconds(3.0f);
                return projectile;
            }
        });
        BulletHandler.registerBullet(POTION, new PotionBullet());
        BulletHandler.registerBullet(FLARE, FLARE_TYPE);
        BulletHandler.registerBullet(FIREWORK, new FireworkBullet());
        BulletHandler.registerBullet(HOMING, new HomingBullet(() -> ((ModConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Homing).get(), IEApi.ieLoc("item/bullet_homing")));
        BulletHandler.registerBullet(WOLFPACK, new WolfpackBullet());
        BulletHandler.registerBullet(WOLFPACK_PART, new WolfpackPartBullet());
    }
}

