/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.models;

import blusunrize.immersiveengineering.client.models.split.SplitModelLoader;
import blusunrize.immersiveengineering.data.models.NongeneratedModels;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class SplitModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private List<Vec3i> parts;
    private NongeneratedModels.NongeneratedModel modelToSplit;
    private boolean isDynamic;

    public static <T extends ModelBuilder<T>> SplitModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new SplitModelBuilder<T>(parent, existingFileHelper);
    }

    protected SplitModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(SplitModelLoader.LOCATION, parent, existingFileHelper, false);
    }

    public SplitModelBuilder<T> parts(List<Vec3i> parts) {
        Preconditions.checkNotNull(parts);
        Preconditions.checkState((this.parts == null ? 1 : 0) != 0);
        this.parts = parts;
        return this;
    }

    public SplitModelBuilder<T> innerModel(NongeneratedModels.NongeneratedModel modelToSplit) {
        Preconditions.checkNotNull((Object)((Object)modelToSplit));
        Preconditions.checkState((this.modelToSplit == null ? 1 : 0) != 0);
        this.modelToSplit = modelToSplit;
        return this;
    }

    public SplitModelBuilder<T> dynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        json.addProperty("dynamic", Boolean.valueOf(this.isDynamic));
        json.add("inner_model", (JsonElement)this.modelToSplit.toJson());
        JsonArray partsJson = new JsonArray();
        for (Vec3i part : this.parts) {
            JsonArray posArray = new JsonArray();
            posArray.add((Number)part.getX());
            posArray.add((Number)part.getY());
            posArray.add((Number)part.getZ());
            partsJson.add((JsonElement)posArray);
        }
        json.add("split_parts", (JsonElement)partsJson);
        return json;
    }
}

