/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.loot;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.items.upgrades.ToolUpgrade;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.loot.BluprintzLootFunction;
import blusunrize.immersiveengineering.common.world.Villages;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class GeneralLoot
implements LootTableSubProvider {
    public GeneralLoot(HolderLookup.Provider p) {
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> out) {
        LootPool.Builder mainPool = LootPool.lootPool();
        mainPool.setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).add(this.createEntry((ItemLike)IEItems.Ingredients.STICK_TREATED, 20, 2, 7)).add(this.createEntry((ItemLike)IEItems.Ingredients.STICK_IRON, 10, 1, 4)).add(this.createEntry((ItemLike)IEItems.Ingredients.STICK_STEEL, 6, 1, 4)).add(this.createEntry((ItemLike)IEItems.Ingredients.STICK_ALUMINUM, 10, 1, 4)).add(this.createEntry((ItemLike)IEItems.Ingredients.HEMP_FABRIC, 10, 1, 3)).add(this.createEntry((ItemLike)IEItems.Ingredients.COAL_COKE, 10, 1, 3)).add(this.createEntry((ItemLike)IEItems.Ingredients.COMPONENT_IRON, 8, 1, 2)).add(this.createEntry((ItemLike)IEItems.Ingredients.COMPONENT_STEEL, 5, 1, 1)).add(this.createEntry((ItemLike)Items.IRON_INGOT, 10, 1, 4)).add(this.createEntry((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.COPPER), 10, 1, 4)).add(this.createEntry((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.ALUMINUM), 10, 1, 4)).add(this.createEntry((ItemLike)IEItems.Metals.NUGGETS.get(EnumMetals.LEAD), 9, 1, 4)).add(this.createEntry((ItemLike)IEItems.Metals.NUGGETS.get(EnumMetals.SILVER), 7, 1, 2)).add(this.createEntry((ItemLike)IEItems.Metals.NUGGETS.get(EnumMetals.NICKEL), 7, 1, 2)).add(this.createBlueprint("bullet", 4)).add(this.createBlueprint("specialBullet", 4)).add(this.createBlueprint("electrode", 4));
        LootTable.Builder builder = LootTable.lootTable();
        builder.withPool(mainPool);
        out.accept(GeneralLoot.key("chests/engineers_house"), builder);
        builder = LootTable.lootTable();
        builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createEntry((ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.RARE), 1, 1, 1)));
        out.accept(GeneralLoot.key("advancements/shader_rare"), builder);
        builder = LootTable.lootTable();
        builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createEntry((ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.EPIC), 1, 1, 1)));
        out.accept(GeneralLoot.key("advancements/shader_epic"), builder);
        builder = LootTable.lootTable();
        builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createEntry((ItemLike)IEItems.Misc.SHADER_BAG.get(Lib.RARITY_MASTERWORK.getValue()), 1, 1, 1)));
        out.accept(GeneralLoot.key("advancements/shader_masterwork"), builder);
        builder = LootTable.lootTable();
        builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createEntry((ItemLike)IEItems.Ingredients.STICK_TREATED)).add(this.createEntry((ItemLike)IEItems.Ingredients.STICK_IRON)).add(this.createEntry((ItemLike)IEItems.Ingredients.STICK_STEEL)));
        out.accept(GeneralLoot.key("gameplay/hero_of_the_village/" + Villages.ENGINEER.getPath()), builder);
        builder = LootTable.lootTable();
        builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createEntry((ItemLike)IEItems.Ingredients.COMPONENT_IRON)).add(this.createEntry((ItemLike)IEItems.Ingredients.COMPONENT_STEEL)));
        out.accept(GeneralLoot.key("gameplay/hero_of_the_village/" + Villages.MACHINIST.getPath()), builder);
        builder = LootTable.lootTable();
        builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createEntry((ItemLike)IEItems.Misc.FARADAY_SUIT.get(ArmorItem.Type.HELMET))).add(this.createEntry((ItemLike)IEItems.Misc.FARADAY_SUIT.get(ArmorItem.Type.CHESTPLATE))).add(this.createEntry((ItemLike)IEItems.Misc.FARADAY_SUIT.get(ArmorItem.Type.LEGGINGS))).add(this.createEntry((ItemLike)IEItems.Misc.FARADAY_SUIT.get(ArmorItem.Type.BOOTS))));
        out.accept(GeneralLoot.key("gameplay/hero_of_the_village/" + Villages.ELECTRICIAN.getPath()), builder);
        builder = LootTable.lootTable();
        builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createEntry((ItemLike)Items.WHITE_BANNER)).add(this.createEntry((ItemLike)Items.ORANGE_BANNER)).add(this.createEntry((ItemLike)Items.GREEN_BANNER)).add(this.createEntry((ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.RARE))).add(this.createEntry((ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.EPIC))));
        out.accept(GeneralLoot.key("gameplay/hero_of_the_village/" + Villages.OUTFITTER.getPath()), builder);
        builder = LootTable.lootTable();
        builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createEntry((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.SILVER))).add(this.createEntry((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.DRAGONS_BREATH))).add(this.createEntry((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.HOMING))).add(this.createEntry((ItemLike)IEItems.Misc.TOOL_UPGRADES.get(ToolUpgrade.REVOLVER_MAGAZINE))));
        out.accept(GeneralLoot.key("gameplay/hero_of_the_village/" + Villages.GUNSMITH.getPath()), builder);
    }

    private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item) {
        return LootItem.lootTableItem((ItemLike)item);
    }

    private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, int min, int max) {
        return this.createEntry(new ItemStack(item), weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)));
    }

    private LootPoolEntryContainer.Builder<?> createBlueprint(String type, int weight) {
        return this.createEntry(BlueprintCraftingRecipe.getTypedBlueprint((String)type), weight).apply((LootItemFunction.Builder)BluprintzLootFunction.builder().when(LootItemRandomChanceCondition.randomChance((float)0.125f)));
    }

    private LootPoolSingletonContainer.Builder<?> createEntry(ItemStack item, int weight) {
        LootPoolSingletonContainer.Builder ret = LootItem.lootTableItem((ItemLike)item.getItem()).setWeight(weight);
        for (TypedDataComponent component : item.getComponents()) {
            ret.apply(GeneralLoot.setComponent(component));
        }
        return ret;
    }

    private static <T> LootItemConditionalFunction.Builder<?> setComponent(TypedDataComponent<T> component) {
        return SetComponentsFunction.setComponent((DataComponentType)component.type(), (Object)component.value());
    }

    static ResourceKey<LootTable> key(String path) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)IEApi.ieLoc((String)path));
    }
}

