/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import io.netty.buffer.ByteBuf;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import org.joml.Vector3f;

public record Color4(float r, float g, float b, float a) {
    public static final Color4 WHITE = new Color4(1.0f, 1.0f, 1.0f, 1.0f);
    public static final DualCodec<ByteBuf, Color4> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.FLOAT.fieldOf("r"), Color4::r, (DualMapCodec)DualCodecs.FLOAT.fieldOf("g"), Color4::g, (DualMapCodec)DualCodecs.FLOAT.fieldOf("b"), Color4::b, (DualMapCodec)DualCodecs.FLOAT.fieldOf("a"), Color4::a, Color4::new);

    public Color4(int r, int g, int b, int a) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public static Color4 fromARGB(int rgba) {
        return new Color4(rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba & 0xFF, rgba >> 24 & 0xFF);
    }

    public static Color4 fromRGB(int rgb) {
        return new Color4(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, 255);
    }

    public static Color4 from(DyeColor dyeColor) {
        if (dyeColor == null) {
            return WHITE;
        }
        int rgb = dyeColor.getTextureDiffuseColor();
        return new Color4((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f, 1.0f);
    }

    public static Color4 load(Tag nbt) {
        return (Color4)CODECS.fromNBT(nbt);
    }

    public Tag save() {
        return CODECS.toNBT((Object)this);
    }

    public int toInt() {
        int rInt = (int)(255.0f * this.r);
        int gInt = (int)(255.0f * this.g);
        int bInt = (int)(255.0f * this.b);
        int aInt = (int)(255.0f * this.a);
        return aInt << 24 | rInt << 16 | gInt << 8 | bInt;
    }

    public Vector3f toVector3f() {
        return new Vector3f(this.r, this.g, this.b);
    }
}

