/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.shapes;

import blusunrize.immersiveengineering.api.utils.shapes.ShapeUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RefineryShapes
implements Function<BlockPos, VoxelShape> {
    public static final Function<BlockPos, VoxelShape> SHAPE_GETTER = new RefineryShapes();

    private RefineryShapes() {
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        if (posInMultiblock.getZ() % 2 == 0 && posInMultiblock.getY() == 0 && posInMultiblock.getX() % 4 == 0) {
            List<AABB> list = Utils.flipBoxes(posInMultiblock.getZ() == 0, posInMultiblock.getX() == 0, new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AABB(0.25, 0.5, 0.0, 0.5, 1.375, 0.25));
            if (new BlockPos(4, 0, 2).equals((Object)posInMultiblock)) {
                list.add(new AABB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
                list.add(new AABB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            }
            return ShapeUtils.join(list);
        }
        if (posInMultiblock.getZ() % 2 == 0 && posInMultiblock.getY() == 0 && posInMultiblock.getX() % 2 == 1) {
            return ShapeUtils.join(Utils.flipBoxes(posInMultiblock.getZ() == 0, posInMultiblock.getX() == 1, new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AABB(0.0, 0.5, 0.0, 0.25, 1.375, 0.25)));
        }
        if (posInMultiblock.getZ() < 2 && posInMultiblock.getY() > 0 && posInMultiblock.getX() % 4 == 0) {
            float maxY;
            float minZ = -0.25f;
            float maxZ = 1.25f;
            float minY = posInMultiblock.getY() == 1 ? 0.5f : -0.5f;
            float f = maxY = posInMultiblock.getY() == 1 ? 2.0f : 1.0f;
            if (posInMultiblock.getZ() == 0) {
                minZ += 1.0f;
                maxZ += 1.0f;
            }
            return Shapes.create((AABB)Utils.flipBox(false, posInMultiblock.getX() == 4, new AABB(0.5, (double)minY, (double)minZ, 2.0, (double)maxY, (double)maxZ)));
        }
        if (posInMultiblock.getZ() < 2 && posInMultiblock.getY() > 0 && posInMultiblock.getX() % 2 == 1) {
            float maxY;
            float minZ = -0.25f;
            float maxZ = 1.25f;
            float minY = posInMultiblock.getY() == 1 ? 0.5f : -0.5f;
            float f = maxY = posInMultiblock.getY() == 1 ? 2.0f : 1.0f;
            if (posInMultiblock.getZ() == 0) {
                minZ += 1.0f;
                maxZ += 1.0f;
            }
            return Shapes.create((AABB)Utils.flipBox(false, posInMultiblock.getX() == 3, new AABB(-0.5, (double)minY, (double)minZ, 1.0, (double)maxY, (double)maxZ)));
        }
        if (Set.of(new BlockPos(0, 0, 2), new BlockPos(1, 0, 2), new BlockPos(3, 0, 2)).contains(posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        if (new BlockPos(4, 1, 2).equals((Object)posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
        }
        return Shapes.block();
    }
}

