/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class IERecipeSerializer<R extends Recipe<?>>
implements RecipeSerializer<R> {
    public static final Codec<List<StackWithChance>> CHANCE_LIST_CODEC = IERecipeSerializer.makeChanceOutputCodec();
    public static final DualCodec<RegistryFriendlyByteBuf, List<StackWithChance>> CHANCE_LIST_CODECS = new DualCodec(CHANCE_LIST_CODEC, StackWithChance.STREAM_LIST);

    public static DualMapCodec<RegistryFriendlyByteBuf, TagOutput> optionalItemOutput(String name) {
        return TagOutput.CODECS.optionalFieldOf(name, (Object)TagOutput.EMPTY);
    }

    public static DualMapCodec<RegistryFriendlyByteBuf, FluidStack> optionalFluidOutput(String name) {
        return IEDualCodecs.FLUID_STACK.optionalFieldOf(name, (Object)FluidStack.EMPTY);
    }

    public abstract ItemStack getIcon();

    protected abstract DualMapCodec<RegistryFriendlyByteBuf, R> codecs();

    public final MapCodec<R> codec() {
        return this.codecs().mapCodec();
    }

    public final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
        return this.codecs().streamCodec();
    }

    protected static <S extends ByteBuf, T> DualMapCodec<S, Optional<List<T>>> maybeListOrSingle(DualCodec<S, T> singleCodec, String key) {
        DualMapCodec<S, List<T>> listOrSingle = IERecipeSerializer.listOrSingle(singleCodec, key);
        return new DualMapCodec(Codec.mapEither((MapCodec)listOrSingle.mapCodec(), (MapCodec)Codec.EMPTY).xmap(e -> (Optional)e.map(Optional::of, $ -> Optional.empty()), o -> o.isPresent() ? Either.left((Object)((List)o.get())) : Either.right((Object)Unit.INSTANCE)), listOrSingle.streamCodec().map(Optional::of, Optional::orElseThrow));
    }

    protected static <S extends ByteBuf, T> DualMapCodec<S, List<T>> listOrSingle(DualCodec<S, T> singleCodec, String key) {
        return IERecipeSerializer.listOrSingle(singleCodec, key, key);
    }

    protected static <S extends ByteBuf, T> DualMapCodec<S, List<T>> listOrSingle(DualCodec<S, T> singleCodec, String singleKey, String listKey) {
        return new DualMapCodec(Codec.mapEither((MapCodec)singleCodec.codec().fieldOf(singleKey), (MapCodec)singleCodec.codec().listOf().fieldOf(listKey)).xmap(e -> (List)e.map(List::of, Function.identity()), l -> l.size() == 1 ? Either.left(l.get(0)) : Either.right((Object)l)), singleCodec.listOf().streamCodec());
    }

    private static Codec<List<StackWithChance>> makeChanceOutputCodec() {
        final Codec baseCodec = StackWithChance.CODECS.codec().listOf();
        Decoder<List<StackWithChance>> conditionalDecoder = new Decoder<List<StackWithChance>>(){

            public <T> DataResult<Pair<List<StackWithChance>, T>> decode(DynamicOps<T> ops, T input) {
                Codec contextCodec = ConditionalOps.retrieveContext().codec();
                return baseCodec.decode(ops, input).flatMap(listAndData -> contextCodec.decode(ops, ops.emptyMap()).map(ctxAndData -> {
                    ArrayList<StackWithChance> filtered = new ArrayList<StackWithChance>();
                    for (StackWithChance stack : (List)listAndData.getFirst()) {
                        boolean matches = true;
                        for (ICondition condition : stack.conditions()) {
                            matches &= condition.test((ICondition.IContext)ctxAndData.getFirst());
                        }
                        if (!matches) continue;
                        filtered.add(stack);
                    }
                    return Pair.of(filtered, (Object)ctxAndData.getSecond());
                }));
            }
        };
        return Codec.of((Encoder)baseCodec, (Decoder)conditionalDecoder);
    }
}

