/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockBEHelperMaster;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockLevel;
import com.google.common.base.Preconditions;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;

public record MultiblockContext<State extends IMultiblockState>(MultiblockBEHelperMaster<State> masterHelper, MultiblockRegistration<State> multiblock, MultiblockLevel level) implements IMultiblockContext<State>
{
    @Override
    public State getState() {
        return this.masterHelper.getState();
    }

    @Override
    public void markMasterDirty() {
        this.masterHelper.getMasterBE().setChanged();
    }

    @Override
    public IMultiblockLevel getLevel() {
        return this.level;
    }

    @Override
    public BooleanSupplier isValid() {
        BlockEntity masterBE = this.masterHelper.getMasterBE();
        return () -> !masterBE.isRemoved();
    }

    @Override
    public void requestMasterBESync() {
        MultiblockContext.requestBESync(this.masterHelper.getMasterBE());
    }

    static void requestBESync(BlockEntity be) {
        ChunkSource chunkSource;
        Level level = be.getLevel();
        if (level != null && (chunkSource = level.getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.blockChanged(be.getBlockPos());
        }
    }

    @Override
    public void setComparatorOutputFor(BlockPos posInMultiblock, int newValue) {
        Preconditions.checkState((boolean)this.masterHelper.multiblock.hasComparatorOutput());
        int oldValue = this.masterHelper.getCurrentComparatorOutputs().put((Object)posInMultiblock, newValue);
        if (oldValue != newValue) {
            this.level.updateNeighbourForOutputSignal(posInMultiblock);
        }
    }

    @Override
    public int getRedstoneInputValue(BlockPos posInMultiblock, RelativeBlockFace side, int fallback) {
        Preconditions.checkState((boolean)this.masterHelper.multiblock.redstoneInputAware());
        BlockEntity blockEntity = this.level.getBlockEntity(posInMultiblock);
        if (blockEntity instanceof IMultiblockBE) {
            IMultiblockBE beAtPos = (IMultiblockBE)blockEntity;
            return beAtPos.getHelper().getRedstoneInput(side);
        }
        return fallback;
    }

    @Override
    public int getRedstoneInputValue(BlockPos posInMultiblock, int fallback) {
        Preconditions.checkState((boolean)this.masterHelper.multiblock.redstoneInputAware());
        BlockEntity blockEntity = this.level.getBlockEntity(posInMultiblock);
        if (!(blockEntity instanceof IMultiblockBE)) {
            return fallback;
        }
        IMultiblockBE beAtPos = (IMultiblockBE)blockEntity;
        int result = 0;
        for (RelativeBlockFace face : RelativeBlockFace.values()) {
            result = Math.max(result, beAtPos.getHelper().getRedstoneInput(face));
        }
        return result;
    }
}

