/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiButtonIE
extends Button {
    protected final ButtonTexture texture;

    public GuiButtonIE(int x, int y, int w, int h, Component name, ButtonTexture texture, IIEPressable handler) {
        super(x, y, w, h, name, (Button.OnPress)handler, DEFAULT_NARRATION);
        this.texture = texture;
    }

    private boolean isPressable(double mouseX, double mouseY) {
        return this.active && this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.width) && mouseY < (double)(this.getY() + this.height);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        Font fontrenderer = mc.font;
        this.isHovered = this.isPressable(mouseX, mouseY);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((int)770, (int)771);
        graphics.blitSprite(this.texture.get(this.isHovered), this.getX(), this.getY(), this.width, this.height);
        if (!this.getMessage().getString().isEmpty()) {
            int txtCol = 0xE0E0E0;
            if (!this.active) {
                txtCol = 0xA0A0A0;
            } else if (this.isHovered) {
                txtCol = -557004;
            }
            graphics.drawCenteredString(fontrenderer, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, txtCol);
        }
    }

    public void onPress() {
        this.onPress.onPress((Button)this);
    }

    public record ButtonTexture(ResourceLocation texture, ResourceLocation hovered) {
        public ButtonTexture {
            Preconditions.checkArgument((texture != null ? 1 : 0) != 0);
            Preconditions.checkArgument((hovered != null ? 1 : 0) != 0);
        }

        public ButtonTexture(ResourceLocation texture) {
            this(texture, texture);
        }

        public ResourceLocation get(boolean hovered) {
            return hovered ? this.hovered : this.texture;
        }
    }

    public static interface IIEPressable<B extends Button>
    extends Button.OnPress {
        public void onIEPress(B var1);

        default public void onPress(Button var1) {
            this.onIEPress(var1);
        }
    }
}

