/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WarningSignBlock
extends IEBaseBlock {
    private static final BooleanProperty GLOWING = BooleanProperty.create((String)"glowing");
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 15.0f).requiresCorrectToolForDrops().isViewBlocking((state, blockReader, pos) -> false).lightLevel(b -> (Boolean)b.getValue((Property)GLOWING) != false ? 9 : 0);
    private final WarningSignIcon icon;
    private static final CachedShapesWithTransform<Unit, Direction> SHAPES = CachedShapesWithTransform.createDirectional($ -> ImmutableList.of((Object)new AABB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.0625)));

    public WarningSignBlock(WarningSignIcon icon, BlockBehaviour.Properties properties) {
        super(properties);
        this.icon = icon;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_HORIZONTAL, BlockStateProperties.WATERLOGGED, GLOWING});
    }

    @Override
    protected BlockState getInitDefaultState() {
        return (BlockState)super.getInitDefaultState().setValue((Property)GLOWING, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)context.getHorizontalDirection());
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return SHAPES.get(Unit.INSTANCE, (Direction)state.getValue((Property)IEProperties.FACING_HORIZONTAL));
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.GLOW_INK_SAC)) {
            if (!level.isClientSide()) {
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                state = (BlockState)state.setValue((Property)GLOWING, (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, state, 3);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
                stack.consume(1, (LivingEntity)player);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public static enum WarningSignIcon implements StringRepresentable
    {
        ATTENTION(false),
        MAGNET(true),
        COLD(true),
        ELECTRIC(true),
        HOT(true),
        FIRE(true),
        FALLING(true),
        SOUND(true),
        EAR_DEFENDERS(true),
        CAT(true),
        VILLAGER(false),
        TURRET(true),
        CREEPER(false),
        SHRIEKER(false),
        WARDEN(true),
        ARROW_UP(false),
        ARROW_DOWN(false),
        ARROW_LEFT(false),
        ARROW_RIGHT(false),
        ARROW_DOUBLE_UP(false),
        ARROW_DOUBLE_DOWN(false),
        ARROW_DOUBLE_LEFT(false),
        ARROW_DOUBLE_RIGHT(false);

        private final boolean hasBanner;

        private WarningSignIcon(boolean hasBanner) {
            this.hasBanner = hasBanner;
        }

        public boolean hasBanner() {
            return this.hasBanner;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

