/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.items.upgrades.ToolUpgrade;
import blusunrize.immersiveengineering.common.register.IEBannerPatterns;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.mixin.accessors.HeroGiftsTaskAccess;
import blusunrize.immersiveengineering.mixin.accessors.TemplatePoolAccess;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.TradeWithVillagerEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class Villages {
    public static final ResourceLocation ENGINEER = ImmersiveEngineering.rl("engineer");
    public static final ResourceLocation MACHINIST = ImmersiveEngineering.rl("machinist");
    public static final ResourceLocation ELECTRICIAN = ImmersiveEngineering.rl("electrician");
    public static final ResourceLocation OUTFITTER = ImmersiveEngineering.rl("outfitter");
    public static final ResourceLocation GUNSMITH = ImmersiveEngineering.rl("gunsmith");
    private static final TradeOutline EMERALD_FOR_ITEM = (buying, priceInfo, random, maxUses, xp, priceMultiplier) -> new MerchantOffer(new ItemCost((ItemLike)buying.getItem(), priceInfo.getPrice(random)), new ItemStack((ItemLike)Items.EMERALD), maxUses, xp, priceMultiplier);
    private static final TradeOutline ONE_ITEM_FOR_EMERALDS = (selling, priceInfo, random, maxUses, xp, priceMultiplier) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, priceInfo.getPrice(random)), selling, maxUses, xp, priceMultiplier);
    private static final TradeOutline ITEMS_FOR_ONE_EMERALD = (selling, priceInfo, random, maxUses, xp, priceMultiplier) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD), selling.copyWithCount(priceInfo.getPrice(random)), maxUses, xp, priceMultiplier);

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent ev) {
        if (ev.getUpdateCause() != TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            return;
        }
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            for (String type : new String[]{"engineer", "machinist", "electrician", "gunsmith", "outfitter"}) {
                Villages.addToPool(ResourceLocation.withDefaultNamespace((String)("village/" + biome + "/houses")), ImmersiveEngineering.rl("village/houses/" + biome + "_" + type), ev.getRegistryAccess());
            }
        }
    }

    public static void init() {
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_ENGINEER.value(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/engineer"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_MACHINIST.value(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/machinist"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_ELECTRICIAN.value(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/electrician"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_OUTFITTER.value(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/outfitter"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_GUNSMITH.value(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/gunsmith"));
    }

    private static void addToPool(ResourceLocation poolId, ResourceLocation toAdd, RegistryAccess regAccess) {
        Registry registry = regAccess.registryOrThrow(Registries.TEMPLATE_POOL);
        StructureTemplatePool pool = Objects.requireNonNull((StructureTemplatePool)registry.get(poolId), poolId.getPath());
        TemplatePoolAccess poolAccess = (TemplatePoolAccess)pool;
        if (!(poolAccess.getRawTemplates() instanceof ArrayList)) {
            poolAccess.setRawTemplates(new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccess.getRawTemplates()));
        }
        SinglePoolElement addedElement = (SinglePoolElement)SinglePoolElement.single((String)toAdd.toString()).apply(StructureTemplatePool.Projection.RIGID);
        poolAccess.getRawTemplates().add((Pair<StructurePoolElement, Integer>)Pair.of((Object)addedElement, (Object)1));
        poolAccess.getTemplates().add((Object)addedElement);
    }

    public static class Registers {
        public static final DeferredRegister<PoiType> POINTS_OF_INTEREST = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"immersiveengineering");
        public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"immersiveengineering");
        public static final Holder<PoiType> POI_CRAFTINGTABLE = POINTS_OF_INTEREST.register("craftingtable", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.WoodenDevices.CRAFTING_TABLE.get())));
        public static final Holder<PoiType> POI_TURNTABLE = POINTS_OF_INTEREST.register("turntable", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.WoodenDevices.TURNTABLE.get())));
        public static final Holder<PoiType> POI_CIRCUITTABLE = POINTS_OF_INTEREST.register("circuit_table", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.WoodenDevices.CIRCUIT_TABLE.get())));
        public static final Holder<PoiType> POI_BANNER = POINTS_OF_INTEREST.register("shaderbanner", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.Cloth.SHADER_BANNER.get())));
        public static final Holder<PoiType> POI_WORKBENCH = POINTS_OF_INTEREST.register("workbench", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.WoodenDevices.WORKBENCH.get())));
        public static final Holder<VillagerProfession> PROF_ENGINEER = PROFESSIONS.register(ENGINEER.getPath(), () -> Registers.createProf(ENGINEER, POI_TURNTABLE, SoundEvents.VILLAGER_WORK_MASON));
        public static final Holder<VillagerProfession> PROF_MACHINIST = PROFESSIONS.register(MACHINIST.getPath(), () -> Registers.createProf(MACHINIST, POI_CRAFTINGTABLE, SoundEvents.VILLAGER_WORK_TOOLSMITH));
        public static final Holder<VillagerProfession> PROF_ELECTRICIAN = PROFESSIONS.register(ELECTRICIAN.getPath(), () -> Registers.createProf(ELECTRICIAN, POI_CIRCUITTABLE, (SoundEvent)IESounds.spark.value()));
        public static final Holder<VillagerProfession> PROF_OUTFITTER = PROFESSIONS.register(OUTFITTER.getPath(), () -> Registers.createProf(OUTFITTER, POI_BANNER, SoundEvents.VILLAGER_WORK_CARTOGRAPHER));
        public static final Holder<VillagerProfession> PROF_GUNSMITH = PROFESSIONS.register(GUNSMITH.getPath(), () -> Registers.createProf(GUNSMITH, POI_WORKBENCH, (SoundEvent)IESounds.revolverReload.value()));

        private static PoiType createPOI(Collection<BlockState> block) {
            return new PoiType((Set)ImmutableSet.copyOf(block), 1, 1);
        }

        private static VillagerProfession createProf(ResourceLocation name, Holder<PoiType> poi, SoundEvent sound) {
            ResourceKey poiName = (ResourceKey)poi.unwrapKey().orElseThrow();
            return new VillagerProfession(name.toString(), holder -> holder.is(poiName), holder -> holder.is(poiName), ImmutableSet.of(), ImmutableSet.of(), sound);
        }

        private static Collection<BlockState> assembleStates(Block block) {
            return block.getStateDefinition().getPossibleStates().stream().filter(blockState -> {
                if (blockState.hasProperty((Property)IEProperties.MULTIBLOCKSLAVE)) {
                    return (Boolean)blockState.getValue((Property)IEProperties.MULTIBLOCKSLAVE) == false;
                }
                return true;
            }).collect(Collectors.toList());
        }
    }

    private record PriceInterval(int min, int max) {
        int getPrice(RandomSource rand) {
            return this.min >= this.max ? this.min : this.min + rand.nextInt(this.max - this.min + 1);
        }
    }

    @FunctionalInterface
    private static interface TradeOutline {
        public MerchantOffer generateOffer(ItemStack var1, PriceInterval var2, RandomSource var3, int var4, int var5, float var6);
    }

    private static class LazyItemStack
    implements Function<Level, ItemStack> {
        private final Function<Level, ItemStack> function;
        private ItemStack instance;

        private LazyItemStack(Function<Level, ItemStack> function) {
            this.function = function;
        }

        @Override
        public ItemStack apply(Level level) {
            if (this.instance == null) {
                this.instance = this.function.apply(level);
            }
            return this.instance;
        }
    }

    private static class RevolverPieceForEmeralds {
        public static RerollingItemListing INSTANCE = RerollingItemListing.register("revolver_piece", (trader, player, random) -> {
            int part = random.nextInt(3);
            ItemStack stack = new ItemStack(part == 0 ? IEItems.Ingredients.GUNPART_BARREL : (part == 1 ? IEItems.Ingredients.GUNPART_DRUM : IEItems.Ingredients.GUNPART_HAMMER));
            float luck = player == null ? 0.0f : player.getLuck();
            RevolverItem.Perks perksTag = RevolverItem.RevolverPerk.generatePerkSet(random, luck);
            stack.set(IEDataComponents.REVOLVER_PERKS, (Object)perksTag);
            int tier = Math.max(1, RevolverItem.RevolverPerk.calculateTier(perksTag));
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5 * tier + random.nextInt(5)), stack, 1, 45, 0.25f);
        });

        private RevolverPieceForEmeralds() {
        }
    }

    private static class OreveinMapForEmeralds {
        private static final int SEARCH_RADIUS = 256;
        private static final String TRADER_SOLD_KEY = "immersiveengineering:mapped_veins";
        public static RerollingItemListing INSTANCE = RerollingItemListing.register("orevein_map", (trader, player, random) -> {
            List<MineralVein> veins;
            if (trader == null) {
                return null;
            }
            Level world = trader.getCommandSenderWorld();
            BlockPos merchantPos = trader.blockPosition();
            CompoundTag traderData = trader.getPersistentData();
            ArrayList<Long> soldMaps = new ArrayList<Long>();
            if (traderData.contains(TRADER_SOLD_KEY)) {
                for (long l : traderData.getLongArray(TRADER_SOLD_KEY)) {
                    soldMaps.add(l);
                }
            }
            if (!(veins = ExcavatorHandler.findVeinsForVillager(world, merchantPos, 256L, soldMaps)).isEmpty()) {
                int select = random.nextInt(Math.min(10, veins.size()));
                MineralVein vein = veins.get(select);
                ColumnPos veinPos = vein.getPos();
                soldMaps.add(veinPos.toLong());
                traderData.putLongArray(TRADER_SOLD_KEY, soldMaps);
                BlockPos blockPos = new BlockPos(veinPos.x(), 64, veinPos.z());
                ItemStack selling = MapItem.create((Level)world, (int)blockPos.getX(), (int)blockPos.getZ(), (byte)1, (boolean)true, (boolean)true);
                MapItem.lockMap((Level)world, (ItemStack)selling);
                MapItemSavedData.addTargetDecoration((ItemStack)selling, (BlockPos)blockPos, (String)"ie:coresample_treasure", (Holder)MapDecorationTypes.RED_X);
                selling.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.immersiveengineering.map_orevein"));
                vein.getMineral(world);
                selling.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName())))));
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8 + random.nextInt(8)), Optional.of(new ItemCost((ItemLike)Items.COMPASS)), selling, 0, 1, 30, 0.5f);
            }
            return null;
        });

        private OreveinMapForEmeralds() {
        }
    }

    public record RerollingItemListing(String functionKey) implements VillagerTrades.ItemListing
    {
        private static final String RANDOMIZED_OFFERS_KEY = "immersiveengineering:randomized_offers";
        private static final Map<String, GenerateOffer> OFFER_FUNCTIONS = new HashMap<String, GenerateOffer>();

        public static RerollingItemListing register(String key, GenerateOffer function) {
            OFFER_FUNCTIONS.put(key, function);
            return new RerollingItemListing(key);
        }

        public MerchantOffer getOffer(Entity trader, @Nonnull RandomSource random) {
            AbstractVillager villager;
            Player player = null;
            if (trader instanceof AbstractVillager && !(villager = (AbstractVillager)trader).level().isClientSide()) {
                player = villager.getTradingPlayer();
                CompoundTag traderData = trader.getPersistentData();
                CompoundTag randomizedOffers = traderData.getCompound(RANDOMIZED_OFFERS_KEY);
                int offerIndex = villager.getOffers().size();
                randomizedOffers.putString(String.valueOf(offerIndex), this.functionKey);
                traderData.put(RANDOMIZED_OFFERS_KEY, (Tag)randomizedOffers);
            }
            return OFFER_FUNCTIONS.get(this.functionKey).generateOffer(trader, player, random);
        }

        @FunctionalInterface
        public static interface GenerateOffer {
            public MerchantOffer generateOffer(Entity var1, @Nullable Player var2, @Nonnull RandomSource var3);
        }
    }

    private static class TradeListing
    implements VillagerTrades.ItemListing {
        private final TradeOutline outline;
        private final LazyItemStack lazyItem;
        private final PriceInterval priceInfo;
        private final int maxUses;
        private final int xp;
        private float priceMultiplier = 0.05f;

        public TradeListing(@Nonnull TradeOutline outline, @Nonnull Function<Level, ItemStack> item, @Nonnull PriceInterval priceInfo, int maxUses, int xp) {
            this.outline = outline;
            this.lazyItem = new LazyItemStack(item);
            this.priceInfo = priceInfo;
            this.maxUses = maxUses;
            this.xp = xp;
        }

        public TradeListing(@Nonnull TradeOutline outline, @Nonnull ItemStack itemStack, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this(outline, (Level l) -> itemStack, buyAmounts, maxUses, xp);
        }

        public TradeListing(@Nonnull TradeOutline outline, @Nonnull ItemLike item, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this(outline, new ItemStack(item), buyAmounts, maxUses, xp);
        }

        public TradeListing(@Nonnull TradeOutline outline, @Nonnull TagKey<Item> tag, @Nonnull ItemLike backup, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this(outline, (Level l) -> {
                ItemStack fromTag = l != null ? IEApi.getPreferredTagStack(l.registryAccess(), tag) : ItemStack.EMPTY;
                return fromTag.isEmpty() ? new ItemStack(backup) : fromTag;
            }, buyAmounts, maxUses, xp);
        }

        public TradeListing setMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        @Nullable
        public MerchantOffer getOffer(@Nullable Entity trader, @Nonnull RandomSource rand) {
            ItemStack buying = this.lazyItem.apply(trader != null ? trader.level() : null);
            return this.outline.generateOffer(buying, this.priceInfo, rand, this.maxUses, this.xp, this.priceMultiplier);
        }
    }

    @EventBusSubscriber(modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
    public static class Events {
        @SubscribeEvent
        public static void registerTrades(VillagerTradesEvent ev) {
            Int2ObjectMap trades = ev.getTrades();
            ResourceLocation typeName = ResourceLocation.parse((String)ev.getType().name());
            if (ENGINEER.equals((Object)typeName)) {
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.getItemTag(IETags.treatedWood), IEBlocks.WoodenDecoration.TREATED_WOOD.get((Object)TreatedWoodStyles.HORIZONTAL), new PriceInterval(4, 6), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING, new PriceInterval(5, 8), 16, 1));
                ((List)trades.get(1)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.Cloth.BALLOON, new PriceInterval(1, 3), 12, 2));
                ((List)trades.get(2)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.ironRod, IEItems.Ingredients.STICK_IRON, new PriceInterval(4, 8), 16, 10));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get((Object)MetalScaffoldingType.STANDARD), new PriceInterval(2, 4), 12, 5));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.MetalDecoration.ALU_SCAFFOLDING.get((Object)MetalScaffoldingType.STANDARD), new PriceInterval(2, 4), 12, 5));
                ((List)trades.get(3)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEItems.Misc.WIRE_COILS.get(WireType.STRUCTURE_ROPE), new PriceInterval(4, 6), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.Connectors.CONNECTOR_STRUCTURAL, new PriceInterval(4, 8), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.StoneDecoration.CONCRETE, new PriceInterval(4, 8), 8, 15));
                ((List)trades.get(3)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.StoneDecoration.CONCRETE_LEADED, new PriceInterval(4, 6), 16, 10));
                ((List)trades.get(4)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.WoodenDecoration.TREATED_POST, new PriceInterval(2, 3), 8, 20));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.StoneDecoration.INSULATING_GLASS, new PriceInterval(2, 6), 16, 10));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.StoneDecoration.DUROPLAST, new PriceInterval(2, 6), 16, 10));
                ((List)trades.get(4)).add(OreveinMapForEmeralds.INSTANCE);
                ((List)trades.get(5)).add(OreveinMapForEmeralds.INSTANCE);
            } else if (MACHINIST.equals((Object)typeName)) {
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.coalCoke, IEItems.Ingredients.COAL_COKE, new PriceInterval(8, 16), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.HAMMER, new PriceInterval(1, 3), 12, 1).setMultiplier(0.2f));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BlueprintCraftingRecipe.getTypedBlueprint("components"), new PriceInterval(6, 16), 3, 5).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, IEItems.Metals.INGOTS.get((Object)EnumMetals.STEEL), new PriceInterval(3, 6), 12, 10));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.COMPONENT_STEEL, new PriceInterval(1, 3), 12, 5));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.WATERWHEEL_SEGMENT, new PriceInterval(1, 3), 8, 10));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.TOOLBOX, new PriceInterval(6, 8), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.DRILLHEAD_IRON, new PriceInterval(20, 40), 3, 15).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.SAWBLADE, new PriceInterval(20, 40), 3, 15).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.EARMUFFS, new PriceInterval(4, 9), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.DRILLHEAD_STEEL, new PriceInterval(32, 48), 3, 30).setMultiplier(0.2f));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgrade.DRILL_LUBE), new PriceInterval(5, 10), 8, 10));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgrade.DRILL_CAPACITY), new PriceInterval(5, 10), 8, 10));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.MetalDecoration.ENGINEERING_LIGHT, new PriceInterval(1, 2), 16, 10));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgrade.DRILL_FORTUNE), new PriceInterval(5, 10), 8, 10));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BlueprintCraftingRecipe.getTypedBlueprint("electrode"), new PriceInterval(12, 24), 3, 30).setMultiplier(0.2f));
            } else if (ELECTRICIAN.equals((Object)typeName)) {
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.copperWire, IEItems.Ingredients.WIRE_COPPER, new PriceInterval(8, 16), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEItems.Misc.WIRE_COILS.get(WireType.COPPER), new PriceInterval(2, 4), 16, 1));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.WIRECUTTER, new PriceInterval(1, 3), 12, 1).setMultiplier(0.2f));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.SCREWDRIVER, new PriceInterval(1, 3), 12, 1).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.electrumWire, IEItems.Ingredients.WIRE_ELECTRUM, new PriceInterval(6, 12), 16, 5));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEItems.Misc.WIRE_COILS.get(WireType.ELECTRUM), new PriceInterval(1, 4), 16, 5));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.VOLTMETER, new PriceInterval(1, 3), 12, 5).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FARADAY_SUIT.get(ArmorItem.Type.BOOTS), new PriceInterval(5, 7), 3, 15).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FARADAY_SUIT.get(ArmorItem.Type.LEGGINGS), new PriceInterval(9, 11), 3, 15).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.aluminumWire, IEItems.Ingredients.WIRE_ALUMINUM, new PriceInterval(4, 8), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEItems.Misc.WIRE_COILS.get(WireType.STEEL), new PriceInterval(1, 2), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FARADAY_SUIT.get(ArmorItem.Type.CHESTPLATE), new PriceInterval(11, 15), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FARADAY_SUIT.get(ArmorItem.Type.HELMET), new PriceInterval(5, 7), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IEItems.Ingredients.ELECTRON_TUBE, new PriceInterval(2, 6), 16, 10));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.COMPONENT_ELECTRONIC, new PriceInterval(1, 3), 16, 15));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FLUORESCENT_TUBE, new PriceInterval(3, 6), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEBlocks.MetalDevices.TESLA_COIL, new PriceInterval(20, 32), 12, 30));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.CIRCUIT_BOARD, new PriceInterval(1, 2), 16, 5));
            } else if (OUTFITTER.equals((Object)typeName)) {
                ItemLike bag_common = IEItems.Misc.SHADER_BAG.get(Rarity.COMMON);
                ItemLike bag_uncommon = IEItems.Misc.SHADER_BAG.get(Rarity.UNCOMMON);
                ItemLike bag_rare = IEItems.Misc.SHADER_BAG.get(Rarity.RARE);
                ItemLike bag_epic = IEItems.Misc.SHADER_BAG.get(Rarity.EPIC);
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_common, new PriceInterval(1, 8), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IEItems.Ingredients.HEMP_FABRIC, new PriceInterval(8, 12), 16, 1));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_uncommon, new PriceInterval(4, 12), 16, 5));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEBannerPatterns.HAMMER.item(), new PriceInterval(10, 20), 3, 20));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEBannerPatterns.WINDMILL.item(), new PriceInterval(4, 20), 3, 20));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEBannerPatterns.ORNATE.item(), new PriceInterval(4, 20), 3, 20));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_rare, new PriceInterval(8, 16), 16, 15));
                ((List)trades.get(3)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).dust, IEItems.Metals.DUSTS.get((Object)EnumMetals.SILVER), new PriceInterval(4, 12), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_uncommon, new PriceInterval(4, 12), 8, 5));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_epic, new PriceInterval(12, 20), 3, 20));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.getTagsFor((EnumMetals)EnumMetals.GOLD).dust, IEItems.Metals.DUSTS.get((Object)EnumMetals.SILVER), new PriceInterval(4, 12), 16, 15));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_rare, new PriceInterval(8, 16), 8, 15));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_epic, new PriceInterval(16, 28), 3, 30).setMultiplier(0.2f));
            } else if (GUNSMITH.equals((Object)typeName)) {
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IEItems.Ingredients.EMPTY_CASING, new PriceInterval(6, 12), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IEItems.Ingredients.EMPTY_SHELL, new PriceInterval(6, 12), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.WOODEN_GRIP, new PriceInterval(2, 4), 1, 12).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BlueprintCraftingRecipe.getTypedBlueprint("bullet"), new PriceInterval(3, 6), 1, 25));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, BulletHandler.getBulletStack(IEBullets.CASULL), new PriceInterval(2, 4), 12, 5));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, BulletHandler.getBulletStack(IEBullets.BUCKSHOT), new PriceInterval(2, 6), 12, 5));
                ((List)trades.get(2)).add(RevolverPieceForEmeralds.INSTANCE);
                ((List)trades.get(3)).add(RevolverPieceForEmeralds.INSTANCE);
                ((List)trades.get(3)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, BulletHandler.getBulletStack(IEBullets.FLARE), new PriceInterval(1, 2), 12, 10));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BlueprintCraftingRecipe.getTypedBlueprint("specialBullet"), new PriceInterval(5, 9), 1, 30).setMultiplier(0.2f));
                ((List)trades.get(4)).add(RevolverPieceForEmeralds.INSTANCE);
                ((List)trades.get(4)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, BulletHandler.getBulletStack(IEBullets.SILVER), new PriceInterval(1, 4), 8, 15));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BulletHandler.getBulletStack(IEBullets.HIGH_EXPLOSIVE), new PriceInterval(2, 4), 8, 15));
                ((List)trades.get(5)).add(RevolverPieceForEmeralds.INSTANCE);
                ((List)trades.get(5)).add(RevolverPieceForEmeralds.INSTANCE);
                ((List)trades.get(5)).add(RevolverPieceForEmeralds.INSTANCE);
            }
        }

        @SubscribeEvent
        public static void onTrade(TradeWithVillagerEvent ev) {
            int offerIndex;
            String offerIndexS;
            AbstractVillager villager = ev.getAbstractVillager();
            CompoundTag randomizedOffers = villager.getPersistentData().getCompound("immersiveengineering:randomized_offers");
            if (randomizedOffers.contains(offerIndexS = String.valueOf(offerIndex = villager.getOffers().indexOf((Object)ev.getMerchantOffer())))) {
                System.out.println("Regenerate offer");
                RerollingItemListing.GenerateOffer offerFunction = RerollingItemListing.OFFER_FUNCTIONS.get(randomizedOffers.getString(offerIndexS));
                MerchantOffer offer = offerFunction.generateOffer((Entity)villager, ev.getEntity(), villager.getRandom());
                offer.increaseUses();
                villager.getOffers().set(offerIndex, (Object)offer);
            }
        }
    }
}

