/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.client.manual.ManualElementIECrafting;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.utils.ManualRecipeRef;
import net.minecraft.world.item.ItemStack;

public class ManualElementBlueprint
extends ManualElementIECrafting {
    public ManualElementBlueprint(ManualInstance manual, ManualRecipeRef ... stacks) {
        super(manual, stacks);
        this.recalculateCraftingRecipes();
    }

    @Override
    public void recalculateCraftingRecipes() {
        this.recipes.clear();
        this.providedItems.clear();
        for (ManualRecipeRef recipeRef : this.stacks) {
            recipeRef.forEachMatchingRecipe(IERecipeTypes.BLUEPRINT.get(), recipe -> {
                ItemStack output = recipe.output.get();
                if (recipe.inputs == null || recipe.inputs.isEmpty()) {
                    return;
                }
                int h = (int)Math.ceil((float)recipe.inputs.size() / 2.0f);
                PositionedItemStack[] pIngredients = new PositionedItemStack[recipe.inputs.size() + 2];
                for (int i = 0; i < recipe.inputs.size(); ++i) {
                    pIngredients[i] = new PositionedItemStack(recipe.inputs.get(i).getMatchingStacks(), 32 + i % 2 * 18, i / 2 * 18);
                }
                int middle = (int)((float)h / 2.0f * 18.0f);
                pIngredients[pIngredients.length - 2] = new PositionedItemStack(recipe.output.get(), 86, middle - 9);
                pIngredients[pIngredients.length - 1] = new PositionedItemStack(BlueprintCraftingRecipe.getTypedBlueprint(recipe.blueprintCategory), 8, middle - 9);
                this.recipes.add(pIngredients);
                this.arrowPositions.add(new ManualElementIECrafting.ArrowPosition(69, middle - 5));
                if (h * 18 > this.yOff) {
                    this.yOff = h * 18;
                }
                this.addProvidedItem(output);
            });
        }
    }
}

