/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class FeatureMineralVein
extends Feature<NoneFeatureConfiguration> {
    public static HashMultimap<ResourceKey<Level>, ChunkPos> veinGeneratedChunks = HashMultimap.create();

    public FeatureMineralVein() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(@Nonnull FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        ChunkPos chunkPos;
        ServerLevel realLevel;
        ResourceKey dimension;
        if (ExcavatorHandler.noiseGenerator == null) {
            ExcavatorHandler.noiseGenerator = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(1309L)), (List)ImmutableList.of((Object)0));
        }
        if (!veinGeneratedChunks.containsEntry((Object)(dimension = (realLevel = ctx.level().getLevel()).dimension()), (Object)(chunkPos = new ChunkPos(ctx.origin())))) {
            veinGeneratedChunks.put((Object)dimension, (Object)chunkPos);
            ExcavatorHandler.generatePotentialVein((Level)realLevel, ctx.level(), chunkPos, ctx.random());
            return true;
        }
        return false;
    }
}

