/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.Raytracer;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.util.fakeworld.TemplateWorld;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class Utils {
    public static final DecimalFormat NUMBERFORMAT_PREFIXED = new DecimalFormat("+#;-#");
    public static final BiMap<TagKey<Item>, DyeColor> DYES_BY_TAG = ImmutableBiMap.builder().put((Object)Tags.Items.DYES_BLACK, (Object)DyeColor.BLACK).put((Object)Tags.Items.DYES_RED, (Object)DyeColor.RED).put((Object)Tags.Items.DYES_GREEN, (Object)DyeColor.GREEN).put((Object)Tags.Items.DYES_BROWN, (Object)DyeColor.BROWN).put((Object)Tags.Items.DYES_BLUE, (Object)DyeColor.BLUE).put((Object)Tags.Items.DYES_PURPLE, (Object)DyeColor.PURPLE).put((Object)Tags.Items.DYES_CYAN, (Object)DyeColor.CYAN).put((Object)Tags.Items.DYES_LIGHT_GRAY, (Object)DyeColor.LIGHT_GRAY).put((Object)Tags.Items.DYES_GRAY, (Object)DyeColor.GRAY).put((Object)Tags.Items.DYES_PINK, (Object)DyeColor.PINK).put((Object)Tags.Items.DYES_LIME, (Object)DyeColor.LIME).put((Object)Tags.Items.DYES_YELLOW, (Object)DyeColor.YELLOW).put((Object)Tags.Items.DYES_LIGHT_BLUE, (Object)DyeColor.LIGHT_BLUE).put((Object)Tags.Items.DYES_MAGENTA, (Object)DyeColor.MAGENTA).put((Object)Tags.Items.DYES_ORANGE, (Object)DyeColor.ORANGE).put((Object)Tags.Items.DYES_WHITE, (Object)DyeColor.WHITE).build();
    private static final long UUID_BASE = 109406000905L;
    private static long UUIDAdd = 1L;

    @Nullable
    public static DyeColor getDye(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        if (stack.is(Tags.Items.DYES)) {
            for (Map.Entry entry : DYES_BY_TAG.entrySet()) {
                if (!stack.is((TagKey)entry.getKey())) continue;
                return (DyeColor)entry.getValue();
            }
        }
        return null;
    }

    public static boolean isDye(ItemStack stack) {
        return stack.is(Tags.Items.DYES);
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        FluidStack fs = stack.copyWithAmount(amount);
        if (stripPressure) {
            fs.remove(IEApiDataComponents.FLUID_PRESSURIZED);
        }
        return fs;
    }

    public static UUID generateNewUUID() {
        UUID uuid = new UUID(109406000905L, UUIDAdd);
        ++UUIDAdd;
        return uuid;
    }

    public static boolean isBlockAt(Level world, BlockPos pos, Block b) {
        return world.getBlockState(pos).getBlock() == b;
    }

    public static double generateLuckInfluencedDouble(double median, double deviation, double luck, RandomSource rng, boolean isBad, double luckScale) {
        double number = rng.nextDouble() * deviation;
        if (isBad) {
            number = -number;
        }
        number += luckScale * luck;
        number = deviation < 0.0 ? Math.max(number, deviation) : Math.min(number, deviation);
        return median + number;
    }

    public static String formatDouble(double d, String s) {
        DecimalFormat df = new DecimalFormat(s);
        return df.format(d);
    }

    public static String toScientificNotation(int value, String decimalPrecision, int useKilo) {
        float formatted;
        float f = value >= 1000000000 ? (float)value / 1.0E9f : (value >= 1000000 ? (float)value / 1000000.0f : (formatted = value >= useKilo ? (float)value / 1000.0f : (float)value));
        String notation = value >= 1000000000 ? "G" : (value >= 1000000 ? "M" : (value >= useKilo ? "K" : ""));
        return Utils.formatDouble(formatted, "0." + decimalPrecision) + notation;
    }

    public static String toCamelCase(String s) {
        return s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String getHarvestLevelName(Tier lvl) {
        if (lvl instanceof Tiers) {
            Tiers named = (Tiers)lvl;
            return named.name();
        }
        return lvl.toString();
    }

    public static String getModName(String modid) {
        return ModList.get().getModContainerById(modid).map(container -> container.getModInfo().getDisplayName()).orElse(modid);
    }

    public static <T> int findSequenceInList(List<T> list, T[] sequence, BiPredicate<T, T> equal) {
        if (list.size() <= 0 || list.size() < sequence.length) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!equal.test(sequence[0], list.get(i))) continue;
            boolean found = true;
            for (int j = 1; j < sequence.length && (found = equal.test(sequence[j], list.get(i + j))); ++j) {
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static Direction rotateFacingTowardsDir(Direction f, Direction dir) {
        if (dir == Direction.NORTH) {
            return f;
        }
        if (dir == Direction.SOUTH && f.getAxis() != Direction.Axis.Y) {
            return f.getClockWise().getClockWise();
        }
        if (dir == Direction.WEST && f.getAxis() != Direction.Axis.Y) {
            return f.getCounterClockWise();
        }
        if (dir == Direction.EAST && f.getAxis() != Direction.Axis.Y) {
            return f.getClockWise();
        }
        if (dir == Direction.DOWN && f.getAxis() != Direction.Axis.Y) {
            return DirectionUtils.rotateAround(f, Direction.Axis.X);
        }
        if (dir == Direction.UP && f.getAxis() != Direction.Axis.X) {
            return DirectionUtils.rotateAround(f, Direction.Axis.X).getOpposite();
        }
        return f;
    }

    public static Vec3 getLivingFrontPos(LivingEntity entity, double offset, double height, HumanoidArm hand, boolean useSteppedYaw, float partialTicks) {
        double offsetX = hand == HumanoidArm.LEFT ? -0.3125 : (hand == HumanoidArm.RIGHT ? 0.3125 : 0.0);
        float yaw = entity.yRotO + (entity.getYRot() - entity.yRotO) * partialTicks;
        if (useSteppedYaw) {
            yaw = entity.yBodyRotO + (entity.yBodyRot - entity.yBodyRotO) * partialTicks;
        }
        float pitch = entity.xRotO + (entity.getXRot() - entity.xRotO) * partialTicks;
        float yawCos = Mth.cos((float)(-yaw * (float)Math.PI / 180.0f - (float)Math.PI));
        float yawSin = Mth.sin((float)(-yaw * (float)Math.PI / 180.0f - (float)Math.PI));
        float pitchCos = -Mth.cos((float)(-pitch * (float)Math.PI / 180.0f));
        float pitchSin = Mth.sin((float)(-pitch * (float)Math.PI / 180.0f));
        return new Vec3(entity.getX() + offsetX * (double)yawCos + offset * (double)pitchCos * (double)yawSin, entity.getY() + offset * (double)pitchSin + height, entity.getZ() + offset * (double)pitchCos * (double)yawCos - offsetX * (double)yawSin);
    }

    public static List<LivingEntity> getTargetsInCone(Level world, Vec3 start, Vec3 dir, float spreadAngle, float truncationLength) {
        double length = dir.length();
        Vec3 dirNorm = dir.normalize();
        double radius = Math.tan(spreadAngle / 2.0f) * length;
        Vec3 endLow = start.add(dir).subtract(radius, radius, radius);
        Vec3 endHigh = start.add(dir).add(radius, radius, radius);
        AABB box = new AABB(Utils.minInArray(start.x, endLow.x, endHigh.x), Utils.minInArray(start.y, endLow.y, endHigh.y), Utils.minInArray(start.z, endLow.z, endHigh.z), Utils.maxInArray(start.x, endLow.x, endHigh.x), Utils.maxInArray(start.y, endLow.y, endHigh.y), Utils.maxInArray(start.z, endLow.z, endHigh.z));
        List list = world.getEntitiesOfClass(LivingEntity.class, box);
        list.removeIf(e -> !Utils.isPointInCone(dirNorm, radius, length, truncationLength, e.position().subtract(start)));
        return list;
    }

    public static boolean isPointInCone(Vec3 normDirection, double radius, double length, float truncationLength, Vec3 relativePoint) {
        double projectedDist = relativePoint.dot(normDirection);
        if (projectedDist < (double)truncationLength || projectedDist > length) {
            return false;
        }
        double radiusAtDist = projectedDist / length * radius;
        Vec3 orthVec = relativePoint.subtract(normDirection.scale(projectedDist));
        return orthVec.lengthSqr() < radiusAtDist * radiusAtDist;
    }

    public static boolean isPointInTriangle(Vec3 tA, Vec3 tB, Vec3 tC, Vec3 point) {
        Vec3 v0 = tC.subtract(tA);
        Vec3 v1 = tB.subtract(tA);
        Vec3 v2 = point.subtract(tA);
        return Utils.isPointInTriangle(v0, v1, v2);
    }

    private static boolean isPointInTriangle(Vec3 leg0, Vec3 leg1, Vec3 targetVec) {
        double dot00 = leg0.dot(leg0);
        double dot01 = leg0.dot(leg1);
        double dot02 = leg0.dot(targetVec);
        double dot11 = leg1.dot(leg1);
        double dot12 = leg1.dot(targetVec);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0 && v >= 0.0 && u + v < 1.0;
    }

    public static void attractEnemies(LivingEntity target, float radius) {
        Utils.attractEnemies(target, radius, null);
    }

    public static void attractEnemies(LivingEntity target, float radius, Predicate<Monster> predicate) {
        AABB aabb = new AABB(target.getX() - (double)radius, target.getY() - (double)radius, target.getZ() - (double)radius, target.getX() + (double)radius, target.getY() + (double)radius, target.getZ() + (double)radius);
        List list = target.getCommandSenderWorld().getEntitiesOfClass(Monster.class, aabb);
        for (Monster mob : list) {
            if (predicate != null && !predicate.test(mob)) continue;
            mob.setTarget(target);
            mob.lookAt((Entity)target, 180.0f, 0.0f);
        }
    }

    public static boolean isHammer(ItemStack stack) {
        return stack.is(IETags.hammers);
    }

    public static boolean isScrewdriver(ItemStack stack) {
        return stack.is(IETags.screwdrivers);
    }

    public static boolean canBlockDamageSource(LivingEntity entity, DamageSource damageSourceIn) {
        Vec3 vec3d;
        if (!damageSourceIn.is(DamageTypeTags.BYPASSES_ARMOR) && entity.isBlocking() && (vec3d = damageSourceIn.getSourcePosition()) != null) {
            Vec3 vec3d1 = entity.getViewVector(1.0f);
            Vec3 vec3d2 = vec3d.vectorTo(entity.position()).normalize();
            vec3d2 = new Vec3(vec3d2.x, 0.0, vec3d2.z);
            return vec3d2.dot(vec3d1) < 0.0;
        }
        return false;
    }

    public static Vec3 getScaledFlowVector(Level world, BlockPos pos) {
        BlockState bState = world.getBlockState(pos);
        FluidState fState = bState.getFluidState();
        return fState.getFlow((BlockGetter)world, pos).scale((double)fState.getOwnHeight());
    }

    public static double minInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double min = f[0];
        for (int i = 1; i < f.length; ++i) {
            min = Math.min(min, f[i]);
        }
        return min;
    }

    public static double maxInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double max = f[0];
        for (int i = 1; i < f.length; ++i) {
            max = Math.max(max, f[i]);
        }
        return max;
    }

    public static boolean isVecInEntityHead(LivingEntity entity, Vec3 vec) {
        if (entity.getBbHeight() / entity.getBbWidth() < 2.0f) {
            return false;
        }
        double d = vec.y - (entity.getY() + (double)entity.getEyeHeight());
        return Math.abs(d) < 0.25;
    }

    public static void unlockIEAdvancement(Player player, String name) {
        if (player instanceof ServerPlayer) {
            PlayerAdvancements advancements = ((ServerPlayer)player).getAdvancements();
            ServerAdvancementManager manager = ((ServerLevel)player.getCommandSenderWorld()).getServer().getAdvancements();
            AdvancementHolder advancement = manager.get(IEApi.ieLoc(name));
            if (advancement != null) {
                advancements.award(advancement, "code_trigger");
            }
        }
    }

    public static List<FireworkExplosion> getRandomFireworkExplosion(Random rand) {
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            int j = rand.nextInt(11) + 1;
            if (j > 2) {
                ++j;
            }
            if (j > 6) {
                j += 2;
            }
            colors[i] = DyeColor.byId((int)j).getFireworkColor();
        }
        return List.of(new FireworkExplosion(FireworkExplosion.Shape.values()[rand.nextInt(FireworkExplosion.Shape.values().length)], IntList.of((int[])colors), IntList.of((int[])colors), true, true));
    }

    public static int intFromRGBA(Vector4f rgba) {
        float[] array = new float[]{rgba.x(), rgba.y(), rgba.z(), rgba.w()};
        return Utils.intFromRGBA(array);
    }

    public static int intFromRGBA(float[] rgba) {
        int ret = (int)(255.0f * rgba[3]);
        ret = (ret << 8) + (int)(255.0f * rgba[0]);
        ret = (ret << 8) + (int)(255.0f * rgba[1]);
        ret = (ret << 8) + (int)(255.0f * rgba[2]);
        return ret;
    }

    public static Vector4f vec4fFromDye(DyeColor dyeColor) {
        if (dyeColor == null) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        int rgb = dyeColor.getTextureDiffuseColor();
        return new Vector4f((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f, 1.0f);
    }

    public static Vector4f vec4fFromInt(int argb) {
        return new Vector4f((float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb & 0xFF) / 255.0f, (float)(argb >> 24 & 0xFF) / 255.0f);
    }

    public static FluidStack drainFluidBlock(Level world, BlockPos pos, IFluidHandler.FluidAction action) {
        Block block;
        BlockState b = world.getBlockState(pos);
        FluidState f = b.getFluidState();
        if (f.isSource() && (block = b.getBlock()) instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            if (action.execute()) {
                bucketPickup.pickupBlock(null, (LevelAccessor)world, pos, b);
            }
            return new FluidStack(f.getType(), 1000);
        }
        return FluidStack.EMPTY;
    }

    public static Fluid getRelatedFluid(Level w, BlockPos pos) {
        return w.getFluidState(pos).getType();
    }

    public static boolean placeFluidBlock(Level worldIn, BlockPos posIn, FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof FlowingFluid) || fluidStack.getAmount() < 1000) {
            return false;
        }
        BlockState blockstate = worldIn.getBlockState(posIn);
        boolean flag = !blockstate.isSolid();
        boolean flag1 = blockstate.canBeReplaced();
        if (worldIn.isEmptyBlock(posIn) || flag || flag1 || blockstate.getBlock() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.getBlock()).canPlaceLiquid(null, (BlockGetter)worldIn, posIn, blockstate, fluid)) {
            if (worldIn.dimensionType().ultraWarm() && fluid.is(FluidTags.WATER)) {
                int i = posIn.getX();
                int j = posIn.getY();
                int k = posIn.getZ();
                worldIn.playSound(null, posIn, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.getBlock() instanceof LiquidBlockContainer && fluid == Fluids.WATER) {
                ((LiquidBlockContainer)blockstate.getBlock()).placeLiquid((LevelAccessor)worldIn, posIn, blockstate, ((FlowingFluid)fluid).getSource(false));
            } else {
                if (!worldIn.isClientSide && (flag || flag1) && !blockstate.liquid()) {
                    worldIn.destroyBlock(posIn, true);
                }
                worldIn.setBlock(posIn, fluid.defaultFluidState().createLegacyBlock(), 11);
            }
            fluidStack.shrink(1000);
            return true;
        }
        return false;
    }

    public static BlockState getStateFromItemStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        Block block = Block.byItem((Item)stack.getItem());
        if (block != Blocks.AIR) {
            return block.defaultBlockState();
        }
        return null;
    }

    public static ItemStack insertStackIntoInventory(IEBlockCapabilityCaches.IEBlockCapabilityCache<IItemHandler> ref, ItemStack stack, boolean simulate) {
        return Utils.insertStackIntoInventory(ref.getCapability(), stack, simulate);
    }

    public static ItemStack insertStackIntoInventory(Supplier<@Nullable IItemHandler> ref, ItemStack stack, boolean simulate) {
        return Utils.insertStackIntoInventory(ref.get(), stack, simulate);
    }

    private static ItemStack insertStackIntoInventory(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler != null && !stack.isEmpty()) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)simulate);
        }
        return stack;
    }

    public static void dropStackAtPos(Level world, DirectionalBlockPos pos, ItemStack stack) {
        Utils.dropStackAtPos(world, pos.position(), stack, pos.side());
    }

    public static void dropStackAtPos(Level world, BlockPos pos, ItemStack stack, @Nonnull Direction facing) {
        if (!stack.isEmpty()) {
            ItemEntity ei = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack.copy());
            ei.setDeltaMovement(0.075 * (double)facing.getStepX(), 0.025, 0.075 * (double)facing.getStepZ());
            world.addFreshEntity((Entity)ei);
        }
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getCapability(Capabilities.FluidHandler.ITEM) != null;
    }

    public static Optional<RecipeHolder<CraftingRecipe>> findCraftingRecipe(CraftingInput crafting, Level world) {
        return world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)crafting, world);
    }

    public static NonNullList<ItemStack> createNonNullItemStackListFromItemStack(ItemStack stack) {
        NonNullList list = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        list.set(0, (Object)stack);
        return list;
    }

    public static boolean isVecInBlock(Vec3 vec3d, BlockPos pos, BlockPos offset, double eps) {
        return vec3d.x >= (double)(pos.getX() - offset.getX()) - eps && vec3d.x <= (double)(pos.getX() - offset.getX() + 1) + eps && vec3d.y >= (double)(pos.getY() - offset.getY()) - eps && vec3d.y <= (double)(pos.getY() - offset.getY() + 1) + eps && vec3d.z >= (double)(pos.getZ() - offset.getZ()) - eps && vec3d.z <= (double)(pos.getZ() - offset.getZ() + 1) + eps;
    }

    public static Vec3 withCoordinate(Vec3 vertex, Direction.Axis axis, double value) {
        switch (axis) {
            case X: {
                return new Vec3(value, vertex.y, vertex.z);
            }
            case Y: {
                return new Vec3(vertex.x, value, vertex.z);
            }
            case Z: {
                return new Vec3(vertex.x, vertex.y, value);
            }
        }
        return vertex;
    }

    public static BlockPos rayTraceForFirst(Vec3 start, Vec3 end, Level w, Set<BlockPos> ignore) {
        Set<BlockPos> trace = Raytracer.rayTrace(start, end, w);
        for (BlockPos cc : ignore) {
            trace.remove(cc);
        }
        if (start.x != end.x) {
            trace = Utils.findMinOrMax(trace, start.x > end.x, 0);
        }
        if (start.y != end.y) {
            trace = Utils.findMinOrMax(trace, start.y > end.y, 0);
        }
        if (start.z != end.z) {
            trace = Utils.findMinOrMax(trace, start.z > end.z, 0);
        }
        if (trace.size() > 0) {
            return trace.iterator().next();
        }
        return null;
    }

    public static Set<BlockPos> findMinOrMax(Set<BlockPos> in, boolean max, int coord) {
        int curr;
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        int currMinMax = max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.getX() : (coord == 1 ? cc.getY() : cc.getY());
            if (!(max ^ curr < currMinMax)) continue;
            currMinMax = curr;
        }
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.getX() : (coord == 1 ? cc.getY() : cc.getZ());
            if (curr != currMinMax) continue;
            ret.add(cc);
        }
        return ret;
    }

    public static BlockEntity getExistingTileEntity(Level world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        if (world.hasChunkAt(pos)) {
            return world.getBlockEntity(pos);
        }
        return null;
    }

    public static void modifyInvStackSize(NonNullList<ItemStack> inv, int slot, int amount) {
        if (slot >= 0 && slot < inv.size() && !((ItemStack)inv.get(slot)).isEmpty()) {
            ((ItemStack)inv.get(slot)).grow(amount);
            if (((ItemStack)inv.get(slot)).getCount() <= 0) {
                inv.set(slot, (Object)ItemStack.EMPTY);
            }
        }
    }

    @Deprecated
    public static int calcRedstoneFromInventory(IIEInventory inv) {
        if (inv == null || inv.getInventory() == null) {
            return 0;
        }
        return Utils.calcRedstoneFromInventory(inv.getComparatedSize(), arg_0 -> inv.getInventory().get(arg_0), inv::getSlotLimit);
    }

    public static int calcRedstoneFromInventory(int maxSlot, IItemHandler inv) {
        return Utils.calcRedstoneFromInventory(maxSlot, arg_0 -> ((IItemHandler)inv).getStackInSlot(arg_0), arg_0 -> ((IItemHandler)inv).getSlotLimit(arg_0));
    }

    private static int calcRedstoneFromInventory(int maxSlot, IntFunction<ItemStack> getStack, Int2IntFunction getSlotLimit) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < maxSlot; ++j) {
            ItemStack itemstack = getStack.apply(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(getSlotLimit.get(j), itemstack.getMaxStackSize());
            ++i;
        }
        return Mth.floor((float)((f /= (float)maxSlot) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static void getDrops(BlockState state, LootContext originalCtx, Consumer<ItemStack> out) {
        ResourceKey lootKey = state.getBlock().getLootTable();
        if (lootKey == BuiltInLootTables.EMPTY) {
            return;
        }
        LootParams lootcontext = new LootParams.Builder(originalCtx.getLevel()).withOptionalParameter(LootContextParams.TOOL, (Object)((ItemStack)originalCtx.getParamOrNull(LootContextParams.TOOL))).withOptionalParameter(LootContextParams.ORIGIN, (Object)((Vec3)originalCtx.getParamOrNull(LootContextParams.ORIGIN))).withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
        ServerLevel serverworld = lootcontext.getLevel();
        LootTable loottable = serverworld.getServer().reloadableRegistries().getLootTable(lootKey);
        loottable.getRandomItems(lootcontext, out);
    }

    public static ItemStack getPickBlock(BlockState state, HitResult rtr, @Nullable Player player) {
        if (player == null) {
            return ItemStack.EMPTY;
        }
        RegistryAccess registries = player.level().registryAccess();
        LevelReader w = TemplateWorld.createSingleBlock(state, registries);
        return state.getBlock().getCloneItemStack(state, rtr, w, BlockPos.ZERO, player);
    }

    public static ItemStack getPickBlock(BlockState state) {
        return Utils.getPickBlock(state, (HitResult)new BlockHitResult(Vec3.ZERO, Direction.DOWN, BlockPos.ZERO, false), ImmersiveEngineering.proxy.getClientPlayer());
    }

    public static List<AABB> flipBoxes(boolean flipFront, boolean flipRight, List<AABB> boxes) {
        return Utils.flipBoxes(flipFront, flipRight, boxes.toArray(new AABB[0]));
    }

    public static List<AABB> flipBoxes(boolean flipFront, boolean flipRight, AABB ... boxes) {
        ArrayList<AABB> ret = new ArrayList<AABB>(boxes.length);
        for (AABB aabb : boxes) {
            ret.add(Utils.flipBox(flipFront, flipRight, aabb));
        }
        return ret;
    }

    public static AABB flipBox(boolean flipFront, boolean flipRight, AABB aabb) {
        AABB result = aabb;
        if (flipRight) {
            result = new AABB(1.0 - result.maxX, result.minY, result.minZ, 1.0 - result.minX, result.maxY, result.maxZ);
        }
        if (flipFront) {
            result = new AABB(result.minX, result.minY, 1.0 - result.maxZ, result.maxX, result.maxY, 1.0 - result.minZ);
        }
        return result;
    }

    public static FluidStack deriveFluidStack(@Nonnull ItemStack stack) {
        PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        return potionContents == null ? FluidUtils.getFluidContained(stack).orElse(FluidStack.EMPTY) : PotionFluid.getFluidStackForType(potionContents.potion(), 250, PotionFluid.PotionBottleType.fromItem((Holder<Item>)stack.getItemHolder()));
    }
}

