/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks.component;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public interface IMultiblockComponent<State> {
    default public void registerCapabilities(CapabilityRegistrar<State> register) {
    }

    default public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity collided) {
    }

    default public ItemInteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public void dropExtraItems(State state, Consumer<ItemStack> drop) {
    }

    public static interface CapabilityGetter<T, State> {
        @Nullable
        public T getCapability(State var1, CapabilityPosition var2);
    }

    public static interface CapabilityRegistrar<State> {
        public <T> void register(BlockCapability<T, @Nullable Direction> var1, CapabilityGetter<T, State> var2);

        default public <T> void registerAtBlockPos(BlockCapability<T, @Nullable Direction> capability, BlockPos atPosition, Function<State, T> getter) {
            this.register(capability, (state, position) -> Objects.equals(position.posInMultiblock(), atPosition) ? getter.apply(state) : null);
        }

        default public <T> void registerAt(BlockCapability<T, @Nullable Direction> capability, CapabilityPosition atPosition, Function<State, T> getter) {
            this.register(capability, (state, position) -> Objects.equals(position, atPosition) ? getter.apply(state) : null);
        }

        default public <T> void registerAtOrNull(BlockCapability<T, @Nullable Direction> capability, CapabilityPosition atPosition, Function<State, T> getter) {
            this.register(capability, (state, position) -> atPosition.equalsOrNullFace(position) ? getter.apply(state) : null);
        }

        default public <T> void registerEverywhere(BlockCapability<T, @Nullable Direction> capability, Function<State, T> getter) {
            this.register(capability, (state, position) -> getter.apply(state));
        }
    }

    public static interface StateWrapper<OuterState, OwnState> {
        public OwnState wrapState(OuterState var1);
    }
}

