/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items.bullets;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import com.google.common.base.Supplier;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ModConfigSpec;

public class PotionBullet
extends BulletHandler.DamagingBullet<Data> {
    public PotionBullet() {
        super(new BulletHandler.CodecsAndDefault<Data>(Data.CODECS, Data.EMPTY), (Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causePotionDamage((RevolvershotEntity)projectile, shooter), () -> ((ModConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Potion).get(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing.asItem().getDefaultInstance()), IEApi.ieLoc("item/bullet_potion"), IEApi.ieLoc("item/bullet_potion_layer"));
    }

    @Override
    public String getTranslationKey(Data potion, String baseName) {
        if (potion.contents.hasEffects()) {
            if (potion.type == PotionType.LINGERING) {
                baseName = (String)baseName + ".linger";
            } else if (potion.type == PotionType.SPLASH) {
                baseName = (String)baseName + ".splash";
            }
        }
        return baseName;
    }

    @Override
    public void onHitTarget(Level world, HitResult target, UUID shooterUUID, Entity projectile, boolean headshot, Data bulletData) {
        super.onHitTarget(world, target, shooterUUID, projectile, headshot, bulletData);
        RevolvershotEntity bullet = (RevolvershotEntity)projectile;
        if (bulletData.contents != null && bulletData.contents.hasEffects()) {
            ServerLevel serverLevel;
            Object e;
            Iterable effects = bulletData.contents.getAllEffects();
            LivingEntity shooter = null;
            if (shooterUUID != null && world instanceof ServerLevel && (e = (serverLevel = (ServerLevel)world).getEntity(shooterUUID)) instanceof LivingEntity) {
                shooter = (LivingEntity)e;
            }
            if (bulletData.type == PotionType.LINGERING) {
                AreaEffectCloud entityareaeffectcloud = new AreaEffectCloud(bullet.level(), bullet.getX(), bullet.getY(), bullet.getZ());
                entityareaeffectcloud.setOwner(shooter);
                entityareaeffectcloud.setRadius(3.0f);
                entityareaeffectcloud.setRadiusOnUse(-0.5f);
                entityareaeffectcloud.setWaitTime(10);
                entityareaeffectcloud.setRadiusPerTick(-entityareaeffectcloud.getRadius() / (float)entityareaeffectcloud.getDuration());
                entityareaeffectcloud.setPotionContents(bulletData.contents);
                for (MobEffectInstance potioneffect : effects) {
                    entityareaeffectcloud.addEffect(new MobEffectInstance(potioneffect.getEffect(), potioneffect.getDuration(), potioneffect.getAmplifier()));
                }
                bullet.level().addFreshEntity((Entity)entityareaeffectcloud);
            } else if (bulletData.type == PotionType.SPLASH) {
                List livingEntities = bullet.level().getEntitiesOfClass(LivingEntity.class, bullet.getBoundingBox().inflate(4.0, 2.0, 4.0));
                if (livingEntities != null && !livingEntities.isEmpty()) {
                    for (LivingEntity living : livingEntities) {
                        double dist;
                        if (!living.isAffectedByPotions() || !((dist = bullet.distanceToSqr((Entity)living)) < 16.0)) continue;
                        double dist2 = 1.0 - Math.sqrt(dist) / 4.0;
                        if (target instanceof EntityHitResult && living == ((EntityHitResult)target).getEntity()) {
                            dist2 = 1.0;
                        }
                        for (MobEffectInstance p : effects) {
                            if (((MobEffect)p.getEffect().value()).isInstantenous()) {
                                ((MobEffect)p.getEffect().value()).applyInstantenousEffect((Entity)bullet, (Entity)shooter, living, p.getAmplifier(), dist2);
                                continue;
                            }
                            int j = (int)(dist2 * (double)p.getDuration() + 0.5);
                            if (j <= 20) continue;
                            living.addEffect(new MobEffectInstance(p.getEffect(), j, p.getAmplifier()));
                        }
                    }
                }
            } else if (target instanceof EntityHitResult && ((EntityHitResult)target).getEntity() instanceof LivingEntity) {
                for (MobEffectInstance p : effects) {
                    if (p.getDuration() < 1) {
                        p = new MobEffectInstance(p.getEffect(), 1);
                    }
                    ((LivingEntity)((EntityHitResult)target).getEntity()).addEffect(p);
                }
            }
            world.levelEvent(2002, bullet.blockPosition(), bulletData.contents.getColor());
        }
    }

    @Override
    public void addTooltip(Data data, Item.TooltipContext world, List<Component> list, TooltipFlag flag) {
        if (data.contents.hasEffects()) {
            data.contents.addPotionTooltip(list::add, 0.25f, world.tickRate());
        }
    }

    @Override
    public Color4 getColour(Data data, int layer) {
        if (layer == 1) {
            return Color4.fromRGB(data.contents.getColor());
        }
        return Color4.WHITE;
    }

    public record Data(PotionContents contents, PotionType type) {
        public static final DualCodec<RegistryFriendlyByteBuf, Data> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.POTION_CONTENTS.fieldOf("contents"), Data::contents, (DualMapCodec)PotionType.CODECS.fieldOf("type"), Data::type, Data::new);
        public static final Data EMPTY = new Data(PotionContents.EMPTY, PotionType.DEFAULT);

        public ItemStack makePotion() {
            ItemStack potion = new ItemStack((ItemLike)(switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Items.SPLASH_POTION;
                case 1 -> Items.LINGERING_POTION;
                case 2 -> Items.POTION;
            }));
            potion.set(DataComponents.POTION_CONTENTS, (Object)this.contents);
            return potion;
        }
    }

    public static enum PotionType {
        SPLASH,
        LINGERING,
        DEFAULT;

        public static final DualCodec<ByteBuf, PotionType> CODECS;

        static {
            CODECS = IEDualCodecs.forEnum((Enum[])PotionType.values());
        }
    }
}

