/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PotionBulletFillRecipe
extends CustomRecipe {
    public PotionBulletFillRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, @Nonnull Level world) {
        boolean hasBullet = false;
        boolean hasPotion = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (this.isPotionBullet(stackInSlot)) {
                if (hasBullet) {
                    return false;
                }
                hasBullet = true;
                continue;
            }
            if (stackInSlot.getItem() instanceof PotionItem) {
                if (hasPotion) {
                    return false;
                }
                hasPotion = true;
                continue;
            }
            return false;
        }
        return hasBullet && hasPotion;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        ItemStack bullet = ItemStack.EMPTY;
        ItemStack potion = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (bullet.isEmpty() && this.isPotionBullet(stackInSlot)) {
                bullet = stackInSlot;
                continue;
            }
            if (!potion.isEmpty() || !(stackInSlot.getItem() instanceof PotionItem)) continue;
            potion = stackInSlot;
        }
        ItemStack newBullet = bullet.copyWithCount(1);
        newBullet.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)potion.get(DataComponents.POTION_CONTENTS)));
        return newBullet;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.POTION_BULLET_FILL.get();
    }

    private boolean isPotionBullet(ItemStack stack) {
        BulletItem bulletItem;
        Item item = stack.getItem();
        return item instanceof BulletItem && (bulletItem = (BulletItem)item).getType() == BulletHandler.getBullet(IEBullets.POTION);
    }
}

