/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.api.utils.shapes.ShapeUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SirenBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IBlockBounds,
IRedstoneConnector,
IEBlockInterfaces.IBlockOverlayText {
    private static final Vec3 CONNECTION_OFFSET = new Vec3(0.5, 0.875, 0.5);
    private final double RADIUS = 48.0;
    boolean active = false;
    int activeTicks = 0;
    public DyeColor redstoneChannel = DyeColor.WHITE;
    public SirenSound sound = SirenSound.SIREN;
    private static final List<AABB> BASE_SHAPE = List.of(new AABB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75), new AABB(0.25, 0.25, 0.25, 0.75, 0.75, 1.0), new AABB(0.3125, 0.75, 0.3125, 0.6875, 1.0, 0.6875));
    private static final CachedShapesWithTransform<Direction, Direction> SHAPES = new CachedShapesWithTransform<Direction, Direction>(direction -> {
        ArrayList<AABB> list = new ArrayList<AABB>(BASE_SHAPE);
        if (direction.getAxis() == Direction.Axis.Y) {
            list.add(new AABB(0.3125, 0.0, 0.3125, 0.6875, 0.25, 0.6875));
            list.add(new AABB(0.25, 0.25, 0.0, 0.75, 0.75, 0.25));
        } else {
            list.add(new AABB(0.3125, 0.1875, 0.0, 0.6875, 0.6875, 0.25));
        }
        return list;
    }, (direction, aabb) -> direction.getAxis() == Direction.Axis.Y ? aabb : ShapeUtils.transformAABB(aabb, direction));

    public SirenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.SIREN.get(), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.active) {
            if (this.activeTicks % 160 == 0) {
                this.getLevelNonnull().playSound(null, this.getPosition(), (SoundEvent)this.sound.sound.value(), SoundSource.BLOCKS, 4.0f, 1.0f);
            }
            if (this.activeTicks % 80 == 0) {
                AABB aabb = new AABB(this.getPosition()).inflate(48.0);
                List nearbyEntities = this.getLevelNonnull().getEntitiesOfClass(LivingEntity.class, aabb, entity -> entity.isAlive() && !entity.isRemoved());
                nearbyEntities.forEach(entity -> {
                    entity.getBrain().setMemory(MemoryModuleType.HEARD_BELL_TIME, (Object)this.getLevelNonnull().getGameTime());
                    if (entity.getType().is(EntityTypeTags.RAIDERS)) {
                        entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 80));
                    }
                });
            }
            ++this.activeTicks;
        } else if (this.activeTicks > 0) {
            this.activeTicks = 0;
        }
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.level.isClientSide && SafeChunkUtils.isChunkSafe((LevelAccessor)this.level, this.worldPosition)) {
            boolean oldActive = this.active;
            boolean bl = this.active = handler.getValue(this.redstoneChannel.getId()) > 0;
            if (this.active != oldActive) {
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.level.isClientSide) {
            ImmersiveEngineering.proxy.openTileScreen("siren", this);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.contains("redstoneChannel")) {
            this.redstoneChannel = DyeColor.byId((int)message.getInt("redstoneChannel"));
        }
        if (message.contains("sound")) {
            this.sound = SirenSound.BY_ORDINAL.apply(message.getInt("sound"));
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        nbt.putInt("redstoneChannel", this.redstoneChannel.getId());
        nbt.putInt("sound", this.sound.ordinal());
        nbt.putBoolean("active", this.active);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        this.redstoneChannel = DyeColor.byId((int)nbt.getInt("redstoneChannel"));
        this.sound = SirenSound.BY_ORDINAL.apply(nbt.getInt("sound"));
        this.active = nbt.getBoolean("active");
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        return CONNECTION_OFFSET;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        Direction f = this.getFacing();
        return SHAPES.get(f, f);
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE_NO_DOWN;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (!Utils.isScrewdriver(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return null;
        }
        return new Component[]{Component.translatable((String)"desc.immersiveengineering.info.redstoneChannel", (Object[])new Object[]{I18n.get((String)("color.minecraft." + this.redstoneChannel.getName()), (Object[])new Object[0])})};
    }

    public static enum SirenSound {
        SIREN(IESounds.siren),
        KLAXON(IESounds.klaxon),
        BUZZER(IESounds.buzzer);

        private static final IntFunction<SirenSound> BY_ORDINAL;
        private final Holder<SoundEvent> sound;

        private SirenSound(Holder<SoundEvent> sound) {
            this.sound = sound;
        }

        public Component getComponent() {
            return Component.translatable((String)("gui.immersiveengineering.config.siren.sound." + this.name().toLowerCase(Locale.ENGLISH)));
        }

        static {
            BY_ORDINAL = ByIdMap.continuous(Enum::ordinal, (Object[])SirenSound.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

