/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.manual.icon;

import blusunrize.immersiveengineering.data.manual.ManualDataGenerator;
import blusunrize.immersiveengineering.data.manual.icon.ExtendedModelManager;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.datafix.DataFixers;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import sun.misc.Unsafe;

public class MinecraftInstanceManager {
    private static final MinecraftInstanceManager INSTANCE = new MinecraftInstanceManager();
    private boolean isInitialized = false;

    public static MinecraftInstanceManager getInstance() {
        return INSTANCE;
    }

    private MinecraftInstanceManager() {
    }

    void initialize(ExistingFileHelper helper, PackOutput output) {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.createMinecraft();
        this.initializeTimer();
        this.initializeRenderSystem();
        this.initializeWindow();
        ReloadableResourceManager resourceManager = ManualDataGenerator.makeFullResourceManager(PackType.CLIENT_RESOURCES, output, helper);
        this.initializeResourceManager(resourceManager);
        this.initializeTextureManager((ResourceManager)resourceManager);
        this.initializeBlockColors();
        this.initializeItemColors();
        this.initializeModelManager();
        this.initializeItemRenderer();
        this.initializeBlockRenderDispatcher();
        this.initializeGameRenderer((ResourceManager)resourceManager);
        this.initializeDataFixer();
        this.initializeGameSettings();
        this.initializeRenderTarget();
        try {
            ObfuscationReflectionHelper.findMethod(GameRenderer.class, (String)"reloadShaders", (Class[])new Class[]{ResourceProvider.class}).invoke((Object)Minecraft.getInstance().gameRenderer, resourceManager);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void createMinecraft() {
        ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, null, (Object)MinecraftInstanceManager.allocateUnsafe(Minecraft.class), (String)"instance");
    }

    private void initializeWindow() {
        Window window = MinecraftInstanceManager.allocateUnsafe(Window.class);
        ObfuscationReflectionHelper.setPrivateValue(Window.class, (Object)window, (Object)240, (String)"height");
        ObfuscationReflectionHelper.setPrivateValue(Window.class, (Object)window, (Object)320, (String)"width");
        window.setWidth(320);
        window.setHeight(240);
        MinecraftInstanceManager.setMCField("window", window);
    }

    private static <T> T allocateUnsafe(Class<T> type) {
        try {
            Unsafe unsafe = (Unsafe)ObfuscationReflectionHelper.getPrivateValue(Unsafe.class, null, (String)"theUnsafe");
            return (T)Objects.requireNonNull(unsafe).allocateInstance(type);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeTimer() {
        MinecraftInstanceManager.setMCField("timer", new DeltaTracker.Timer(20.0f, 0L, i -> i));
    }

    private void initializeRenderSystem() {
        RenderSystem.initRenderThread();
    }

    private void initializeResourceManager(ReloadableResourceManager resourceManager) {
        MinecraftInstanceManager.setMCField("resourceManager", resourceManager);
    }

    private void initializeTextureManager(ResourceManager resourceManager) {
        TextureManager textureManager = new TextureManager(resourceManager);
        MinecraftInstanceManager.setMCField("textureManager", textureManager);
    }

    private void initializeBlockColors() {
        MinecraftInstanceManager.setMCField("blockColors", BlockColors.createDefault());
    }

    private void initializeItemColors() {
        MinecraftInstanceManager.setMCField("itemColors", ItemColors.createDefault((BlockColors)Minecraft.getInstance().getBlockColors()));
    }

    private void initializeModelManager() {
        ExtendedModelManager modelManager = new ExtendedModelManager(Minecraft.getInstance().getTextureManager(), Minecraft.getInstance().getBlockColors(), 0);
        MinecraftInstanceManager.setMCField("modelManager", (Object)modelManager);
    }

    private void initializeItemRenderer() {
        EntityModelSet entityModelSet = new EntityModelSet();
        entityModelSet.onResourceManagerReload(null);
        BlockEntityRenderDispatcher dispatcher = new BlockEntityRenderDispatcher(null, entityModelSet, () -> Minecraft.getInstance().getBlockRenderer(), () -> Minecraft.getInstance().getItemRenderer(), () -> Minecraft.getInstance().getEntityRenderDispatcher());
        dispatcher.onResourceManagerReload(null);
        BlockEntityWithoutLevelRenderer beNoLevelRenderer = new BlockEntityWithoutLevelRenderer(dispatcher, entityModelSet);
        beNoLevelRenderer.onResourceManagerReload(null);
        ItemRenderer itemRenderer = new ItemRenderer(Minecraft.getInstance(), Minecraft.getInstance().getTextureManager(), Minecraft.getInstance().getModelManager(), Minecraft.getInstance().getItemColors(), beNoLevelRenderer);
        MinecraftInstanceManager.setMCField("itemRenderer", itemRenderer);
    }

    private void initializeBlockRenderDispatcher() {
        BlockRenderDispatcher blockRendererDispatcher = new BlockRenderDispatcher(Minecraft.getInstance().getModelManager().getBlockModelShaper(), Minecraft.getInstance().getItemRenderer().getBlockEntityRenderer(), Minecraft.getInstance().getBlockColors());
        MinecraftInstanceManager.setMCField("blockRenderer", blockRendererDispatcher);
    }

    private void initializeGameRenderer(ResourceManager resourceManager) {
        Tesselator.init();
        GameRenderer gameRenderer = new GameRenderer(Minecraft.getInstance(), new ItemInHandRenderer(Minecraft.getInstance(), null, Minecraft.getInstance().getItemRenderer()), resourceManager, new RenderBuffers(1));
        MinecraftInstanceManager.setMCField("gameRenderer", gameRenderer);
    }

    private void initializeDataFixer() {
        MinecraftInstanceManager.setMCField("fixerUpper", DataFixers.getDataFixer());
    }

    private void initializeGameSettings() {
        Options gameSettings = new Options(Minecraft.getInstance(), new File("./"));
        MinecraftInstanceManager.setMCField("options", gameSettings);
    }

    private void initializeRenderTarget() {
        MinecraftInstanceManager.setMCField("mainRenderTarget", new MainTarget(400, 400));
    }

    private static void setMCField(String name, Object value) {
        ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, (Object)Minecraft.getInstance(), (Object)value, (String)name);
    }
}

