/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.loot;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.common.blocks.generic.PostBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.SawdustBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.loot.BEDropLootEntry;
import blusunrize.immersiveengineering.common.util.loot.ConveyorCoverLootFunction;
import blusunrize.immersiveengineering.common.util.loot.DropInventoryLootEntry;
import blusunrize.immersiveengineering.common.util.loot.PropertyCountLootFunction;
import blusunrize.immersiveengineering.common.util.loot.WindmillLootFunction;
import blusunrize.immersiveengineering.data.loot.GeneralLoot;
import blusunrize.immersiveengineering.data.loot.LootUtils;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class BlockLoot
implements LootTableSubProvider {
    private final Set<ResourceKey<LootTable>> generatedTables = new HashSet<ResourceKey<LootTable>>();
    private BiConsumer<ResourceKey<LootTable>, LootTable.Builder> out;
    private final HolderLookup.Provider provider;

    public BlockLoot(HolderLookup.Provider p) {
        this.provider = p;
    }

    private ResourceKey<LootTable> toTableLoc(ResourceLocation in) {
        return GeneralLoot.key("blocks/" + in.getPath());
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> out) {
        this.out = out;
        this.registerHemp();
        this.register((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_SPRAYED, LootTable.lootTable());
        this.register((Supplier<? extends Block>)IEBlocks.WoodenDevices.WINDMILL, LootTable.lootTable().withPool(this.createPoolBuilder().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)IEBlocks.WoodenDevices.WINDMILL).apply(WindmillLootFunction.builder()))));
        AlternativesEntry.Builder tileOrInv = AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{BEDropLootEntry.builder().when(ExplosionCondition.survivesExplosion()), DropInventoryLootEntry.builder()});
        this.register((Supplier<? extends Block>)IEBlocks.WoodenDevices.CRATE, LootPool.lootPool().add((LootPoolEntryContainer.Builder)tileOrInv));
        this.register((Supplier<? extends Block>)IEBlocks.WoodenDevices.REINFORCED_CRATE, this.tileDrop());
        this.register((Supplier<? extends Block>)IEBlocks.WoodenDevices.SORTER, this.tileDrop());
        this.register((Supplier<? extends Block>)IEBlocks.WoodenDevices.FLUID_SORTER, this.tileDrop());
        this.register((Supplier<? extends Block>)IEBlocks.StoneDecoration.CORESAMPLE, this.tileDrop());
        this.register((Supplier<? extends Block>)IEBlocks.MetalDevices.TOOLBOX, this.tileDrop());
        this.register((Supplier<? extends Block>)IEBlocks.Cloth.SHADER_BANNER, this.singleItem((ItemLike)Items.WHITE_BANNER));
        this.register((Supplier<? extends Block>)IEBlocks.Cloth.SHADER_BANNER_WALL, this.singleItem((ItemLike)Items.WHITE_BANNER));
        this.register((Supplier<? extends Block>)IEBlocks.Cloth.STRIP_CURTAIN, this.tileDrop());
        for (IEBlocks.BlockEntry cap : ImmutableList.of((Object)IEBlocks.MetalDevices.CAPACITOR_LV, (Object)IEBlocks.MetalDevices.CAPACITOR_MV, (Object)IEBlocks.MetalDevices.CAPACITOR_HV, (Object)IEBlocks.MetalDevices.CAPACITOR_CREATIVE)) {
            this.register((Supplier<? extends Block>)cap, this.tileDrop());
        }
        this.register((Supplier<? extends Block>)IEBlocks.Connectors.FEEDTHROUGH, this.tileDrop());
        this.register((Supplier<? extends Block>)IEBlocks.MetalDevices.TURRET_CHEM, this.tileDrop());
        this.register((Supplier<? extends Block>)IEBlocks.MetalDevices.TURRET_GUN, this.tileDrop(), this.dropInv());
        this.register((Supplier<? extends Block>)IEBlocks.WoodenDevices.WOODEN_BARREL, this.tileDrop());
        this.register((Supplier<? extends Block>)IEBlocks.WoodenDevices.LOGIC_UNIT, this.tileDrop());
        this.register((Supplier<? extends Block>)IEBlocks.MetalDevices.BARREL, this.tileDrop());
        this.registerDoor((Supplier<? extends Block>)IEBlocks.WoodenDecoration.DOOR);
        this.registerDoor((Supplier<? extends Block>)IEBlocks.WoodenDecoration.DOOR_FRAMED);
        this.registerDoor((Supplier<? extends Block>)IEBlocks.MetalDecoration.STEEL_DOOR);
        this.registerPost((Supplier<? extends Block>)IEBlocks.WoodenDecoration.TREATED_POST);
        this.registerPost((Supplier<? extends Block>)IEBlocks.MetalDecoration.STEEL_POST);
        this.registerPost((Supplier<? extends Block>)IEBlocks.MetalDecoration.ALU_POST);
        this.registerMultiblocks();
        this.registerSelfDropping((Supplier<? extends Block>)IEBlocks.WoodenDevices.CRAFTING_TABLE, this.dropInv());
        this.registerSelfDropping((Supplier<? extends Block>)IEBlocks.WoodenDevices.WORKBENCH, this.dropInv());
        this.registerSelfDropping((Supplier<? extends Block>)IEBlocks.WoodenDevices.BLUEPRINT_SHELF, this.dropInv());
        this.registerSelfDropping((Supplier<? extends Block>)IEBlocks.WoodenDevices.CIRCUIT_TABLE, this.dropInv());
        this.registerSelfDropping((Supplier<? extends Block>)IEBlocks.WoodenDevices.ITEM_BATCHER, this.dropInv());
        this.registerSelfDropping((Supplier<? extends Block>)IEBlocks.MetalDevices.CLOCHE, this.dropInv());
        this.registerSelfDropping((Supplier<? extends Block>)IEBlocks.MetalDevices.CHARGING_STATION, this.dropInv());
        this.registerSlabs();
        this.registerSawdust();
        for (IEBlocks.BlockEntry entry : IEBlocks.MetalDevices.CONVEYORS.values()) {
            ConveyorBlock block = (ConveyorBlock)entry.get();
            this.register((Supplier<? extends Block>)entry, this.singleItem((ItemLike)block).apply(ConveyorCoverLootFunction.builder()));
        }
        for (EnumMetals metal : EnumMetals.values()) {
            if (!metal.shouldAddOre()) continue;
            this.registerOre(metal);
        }
        this.registerAllRemainingAsDefault();
    }

    private void registerMultiblocks() {
        this.registerMultiblock(IEMultiblockLogic.COKE_OVEN);
        this.registerMultiblock(IEMultiblockLogic.BLAST_FURNACE);
        this.registerMultiblock(IEMultiblockLogic.ALLOY_SMELTER);
        this.registerMultiblock(IEMultiblockLogic.ADV_BLAST_FURNACE);
        this.registerMultiblock(IEMultiblockLogic.METAL_PRESS);
        this.registerMultiblock(IEMultiblockLogic.CRUSHER);
        this.registerMultiblock(IEMultiblockLogic.SAWMILL);
        this.registerMultiblock(IEMultiblockLogic.TANK);
        this.registerMultiblock(IEMultiblockLogic.SILO);
        this.registerMultiblock(IEMultiblockLogic.ASSEMBLER);
        this.registerMultiblock(IEMultiblockLogic.AUTO_WORKBENCH);
        this.registerMultiblock(IEMultiblockLogic.BOTTLING_MACHINE);
        this.registerMultiblock(IEMultiblockLogic.SQUEEZER);
        this.registerMultiblock(IEMultiblockLogic.FERMENTER);
        this.registerMultiblock(IEMultiblockLogic.REFINERY);
        this.registerMultiblock(IEMultiblockLogic.DIESEL_GENERATOR);
        this.registerMultiblock(IEMultiblockLogic.EXCAVATOR);
        this.registerMultiblock(IEMultiblockLogic.BUCKET_WHEEL);
        this.registerMultiblock(IEMultiblockLogic.ARC_FURNACE);
        this.registerMultiblock(IEMultiblockLogic.LIGHTNING_ROD);
        this.registerMultiblock(IEMultiblockLogic.MIXER);
    }

    private void registerSlabs() {
        for (IEBlocks.BlockEntry slab : IEBlocks.TO_SLAB.values()) {
            LootItemConditionalFunction.Builder doubleSlabFunction = SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when(this.propertyIs((Supplier<? extends Block>)slab, (Property)SlabBlock.TYPE, (Comparable<T> & StringRepresentable)SlabType.DOUBLE));
            LootTable.Builder lootBuilder = LootTable.lootTable().withPool(this.singleItem((ItemLike)slab).apply((LootItemFunction.Builder)doubleSlabFunction));
            this.register((Supplier<? extends Block>)slab, lootBuilder);
        }
    }

    private void registerAllRemainingAsDefault() {
        for (IEBlocks.BlockEntry b : IEBlocks.BlockEntry.ALL_ENTRIES) {
            if (this.generatedTables.contains(this.toTableLoc(b.getId()))) continue;
            this.registerSelfDropping((Supplier<? extends Block>)b, new LootPool.Builder[0]);
        }
    }

    private void registerMultiblock(MultiblockRegistration<?> registration) {
        this.registerMultiblock(registration.block());
    }

    private void registerMultiblock(Supplier<? extends Block> b) {
        this.register(b, this.dropInv(), this.dropOriginalBlock());
    }

    private LootPool.Builder dropInv() {
        return this.createPoolBuilder().add((LootPoolEntryContainer.Builder)DropInventoryLootEntry.builder());
    }

    private LootPool.Builder tileDrop() {
        return this.createPoolBuilder().add((LootPoolEntryContainer.Builder)BEDropLootEntry.builder());
    }

    private LootPool.Builder dropOriginalBlock() {
        return this.createPoolBuilder().add(LootUtils.getMultiblockDropBuilder());
    }

    private void register(Supplier<? extends Block> b, LootPool.Builder ... pools) {
        LootTable.Builder builder = LootTable.lootTable();
        for (LootPool.Builder pool : pools) {
            builder.withPool(pool);
        }
        this.register(b, builder);
    }

    private void register(Supplier<? extends Block> b, LootTable.Builder table) {
        this.register(BuiltInRegistries.BLOCK.getKey((Object)b.get()), table);
    }

    private void register(ResourceLocation name, LootTable.Builder table) {
        ResourceKey<LootTable> loc = this.toTableLoc(name);
        if (!this.generatedTables.add(loc)) {
            throw new IllegalStateException("Duplicate loot table " + String.valueOf(name));
        }
        this.out.accept(loc, table.setParamSet(LootContextParamSets.BLOCK));
    }

    private void registerSelfDropping(Supplier<? extends Block> b, LootPool.Builder ... pool) {
        LootPool.Builder[] withSelf = Arrays.copyOf(pool, pool.length + 1);
        withSelf[withSelf.length - 1] = this.singleItem((ItemLike)b.get());
        this.register(b, withSelf);
    }

    private LootTable.Builder dropProvider(ItemLike in) {
        return LootTable.lootTable().withPool(this.singleItem(in));
    }

    private LootPool.Builder singleItem(ItemLike in) {
        return this.createPoolBuilder().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)in));
    }

    private LootPool.Builder createPoolBuilder() {
        return LootPool.lootPool().when(ExplosionCondition.survivesExplosion());
    }

    private void registerHemp() {
        LootTable.Builder ret = LootTable.lootTable().withPool(this.singleItem((ItemLike)IEItems.Misc.HEMP_SEEDS));
        ret.withPool(this.binBonusLootPool((ItemLike)IEItems.Ingredients.HEMP_FIBER, (ResourceKey<Enchantment>)Enchantments.FORTUNE, 0.5f, 3).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)IEBlocks.Misc.HEMP_PLANT.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)HempBlock.AGE, 4))));
        ret.withPool(this.binBonusLootPool((ItemLike)IEItems.Ingredients.HEMP_FIBER, (ResourceKey<Enchantment>)Enchantments.FORTUNE, 0.625f, 3).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)IEBlocks.Misc.HEMP_PLANT.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)HempBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))));
        this.register((Supplier<? extends Block>)IEBlocks.Misc.HEMP_PLANT, ret);
    }

    private void registerOre(EnumMetals metal) {
        this.registerOre(metal, (IEBlocks.BlockEntry)IEBlocks.Metals.ORES.get(metal));
        this.registerOre(metal, (IEBlocks.BlockEntry)IEBlocks.Metals.DEEPSLATE_ORES.get(metal));
    }

    private void registerOre(EnumMetals metal, IEBlocks.BlockEntry<?> oreBlock) {
        HolderLookup.RegistryLookup enchantments = this.provider.lookupOrThrow(Registries.ENCHANTMENT);
        IEItems.ItemRegObject rawOre = (IEItems.ItemRegObject)IEItems.Metals.RAW_ORES.get(metal);
        LootTable.Builder ret = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem(oreBlock).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantments.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1)))))))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)rawOre).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()))));
        this.register((Supplier<? extends Block>)oreBlock, ret);
    }

    private void registerDoor(Supplier<? extends Block> b) {
        LootPool.Builder ret = this.createPoolBuilder().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)b.get())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))));
        this.register(b, ret);
    }

    private void registerPost(Supplier<? extends Block> b) {
        LootPool.Builder ret = this.createPoolBuilder().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)b.get())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PostBlock.HORIZONTAL_OFFSET, (Comparable)PostBlock.HorizontalOffset.NONE))));
        this.register(b, ret);
    }

    private void registerSawdust() {
        LootTable.Builder ret = LootTable.lootTable().withPool(this.singleItem((ItemLike)IEBlocks.WoodenDecoration.SAWDUST)).apply((LootItemFunction.Builder)new PropertyCountLootFunction.Builder(SawdustBlock.LAYERS.getName()));
        this.register((Supplier<? extends Block>)IEBlocks.WoodenDecoration.SAWDUST, ret);
    }

    private LootPool.Builder binBonusLootPool(ItemLike item, ResourceKey<Enchantment> ench, float prob, int extra) {
        HolderLookup.RegistryLookup enchantments = this.provider.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createPoolBuilder().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)enchantments.getOrThrow(ench), (float)prob, (int)extra));
    }

    private <T extends Comparable<T> & StringRepresentable> LootItemCondition.Builder propertyIs(Supplier<? extends Block> b, Property<T> prop, T value) {
        return LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(prop, value));
    }
}

