/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.lib.manual.ManualEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record ManualUnlockToast(Optional<AdvancementToast> originalToast, List<ManualEntry> entries) implements Toast
{
    private static final ResourceLocation BACKGROUND_SPRITE = IEApi.ieLoc("hud/toast_manual");
    private static final Component HEADLINE = Component.literal((String)"Manual Entry Unlocked!");

    public int height() {
        return 48 + this.originalToast.map(Toast::height).orElse(0);
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        guiGraphics.pose().pushPose();
        this.originalToast.ifPresent(toast -> {
            toast.render(guiGraphics, toastComponent, timeSinceLastVisible);
            guiGraphics.pose().translate(0.0f, (float)toast.height(), 0.0f);
        });
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), 48);
        guiGraphics.drawString(toastComponent.getMinecraft().font, HEADLINE, 32, 6, 16220212, false);
        guiGraphics.renderFakeItem(IEItems.Tools.MANUAL.asItem().getDefaultInstance(), 7, 8);
        if (!this.entries.isEmpty()) {
            int iEntry = (int)(timeSinceLastVisible / 300L % (long)this.entries.size());
            guiGraphics.drawString(toastComponent.getMinecraft().font, this.entries.get(iEntry).getTitle(), 32, 18, 0x555555, false);
        }
        guiGraphics.pose().popPose();
        if ((double)timeSinceLastVisible >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier()) {
            return Toast.Visibility.HIDE;
        }
        return Toast.Visibility.SHOW;
    }
}

