/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.ClientBlockEntityScreen;
import blusunrize.immersiveengineering.client.gui.RedstoneConnectorScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiSelectBox;
import blusunrize.immersiveengineering.common.blocks.metal.SirenBlockEntity;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.network.PacketDistributor;

public class SirenScreen
extends ClientBlockEntityScreen<SirenBlockEntity> {
    private GuiButtonBoolean[] colorButtons;

    public SirenScreen(SirenBlockEntity tileEntity, Component title) {
        super(tileEntity, title);
        this.xSize = 118;
        this.ySize = 120;
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        this.colorButtons = new GuiButtonBoolean[16];
        for (int i = 0; i < this.colorButtons.length; ++i) {
            DyeColor color = DyeColor.byId((int)i);
            this.colorButtons[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtons, this.guiLeft + 4 + i % 4 * 14, this.guiTop + 22 + i / 4 * 14, () -> ((SirenBlockEntity)this.blockEntity).redstoneChannel == color, color, btn -> this.sendConfig("redstoneChannel", color.getId()));
            this.addRenderableWidget((GuiEventListener)this.colorButtons[i]);
        }
        this.addRenderableWidget((GuiEventListener)new GuiSelectBox<SirenBlockEntity.SirenSound>(this.guiLeft + 64, this.guiTop + 22, 50, SirenBlockEntity.SirenSound::values, () -> ((SirenBlockEntity)this.blockEntity).sound.ordinal(), SirenBlockEntity.SirenSound::getComponent, box -> this.sendConfig("sound", box.getClickedState())));
    }

    public void sendConfig(String key, int value) {
        CompoundTag message = new CompoundTag();
        message.putInt(key, value);
        ((SirenBlockEntity)this.blockEntity).receiveMessageFromClient(message);
        PacketDistributor.sendToServer((CustomPacketPayload)new MessageBlockEntitySync(this.blockEntity, message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        for (int i = 0; i < this.colorButtons.length; ++i) {
            if (!this.colorButtons[i].isHovered()) continue;
            tooltip.add(Component.translatable((String)"gui.immersiveengineering.config.redstone_color"));
            tooltip.add(TextUtils.applyFormat((Component)Component.translatable((String)("color.minecraft." + DyeColor.byId((int)i).getName())), ChatFormatting.GRAY));
        }
        if (!tooltip.isEmpty()) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (ClientUtils.mc().options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

