/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.upgrade.Cooldown;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.client.BlockOverlayUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.RevolverScreen;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.SpacerComponent;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.MessageRequestEnergyUpdate;
import blusunrize.immersiveengineering.common.network.MessageRequestRedstoneUpdate;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;

@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=EventBusSubscriber.Bus.MOD)
public class ItemOverlayUtils {
    @SubscribeEvent
    public static void register(RegisterGuiLayersEvent ev) {
        ev.registerBelow(VanillaGuiLayers.DEBUG_OVERLAY, Lib.GuiLayers.ITEMS, ItemOverlayUtils::renderItemOverlays);
    }

    public static void renderItemOverlays(GuiGraphics graphics, DeltaTracker delta) {
        LocalPlayer player = ClientUtils.mc().player;
        if (player == null) {
            return;
        }
        int scaledWidth = ClientUtils.mc().getWindow().getGuiScaledWidth();
        int scaledHeight = ClientUtils.mc().getWindow().getGuiScaledHeight();
        for (InteractionHand hand : InteractionHand.values()) {
            if (player.getItemInHand(hand).isEmpty()) continue;
            ItemStack equipped = player.getItemInHand(hand);
            if (equipped.is(IEItems.Tools.VOLTMETER.asItem()) || equipped.getItem() instanceof IWireCoil) {
                ItemOverlayUtils.renderWireCoilOverlay(graphics, equipped, (Player)player, scaledWidth, scaledHeight);
            } else if (equipped.getItem() == IEItems.Misc.FLUORESCENT_TUBE.get()) {
                ItemOverlayUtils.renderFluorescentTubeOverlay(graphics, equipped, scaledWidth, scaledHeight);
            } else if (equipped.getItem() instanceof RevolverItem || equipped.getItem() instanceof SpeedloaderItem) {
                ItemOverlayUtils.renderRevolverOverlay(graphics, scaledWidth, scaledHeight, (Player)player, hand, equipped);
            } else if (equipped.getItem() instanceof RailgunItem) {
                ItemOverlayUtils.renderRailgunOverlay(graphics, scaledWidth, scaledHeight, (Player)player, hand, equipped);
            } else if (equipped.getItem() instanceof DrillItem) {
                ItemOverlayUtils.renderDrillOverlay(graphics, scaledWidth, scaledHeight, (Player)player, hand, equipped);
            } else if (equipped.getItem() instanceof BuzzsawItem) {
                ItemOverlayUtils.renderBuzzsawOverlay(graphics, scaledWidth, scaledHeight, (Player)player, hand, equipped);
            } else if (equipped.getItem() instanceof ChemthrowerItem) {
                ItemOverlayUtils.renderChemthrowerOverlay(graphics, scaledWidth, scaledHeight, (Player)player, hand, equipped);
            } else if (equipped.getItem() instanceof IEShieldItem) {
                ItemOverlayUtils.renderShieldOverlay(graphics, scaledWidth, scaledHeight, (Player)player, hand, equipped);
            }
            if (equipped.getItem() != IEItems.Tools.VOLTMETER.get()) continue;
            ItemOverlayUtils.renderVoltmeterOverlay(graphics, (Player)player, scaledWidth, scaledHeight);
        }
    }

    private static void renderWireCoilOverlay(GuiGraphics graphics, ItemStack equipped, Player player, int scaledWidth, int scaledHeight) {
        int max;
        HitResult rtr;
        double d;
        if (!equipped.has(IEApiDataComponents.WIRE_LINK)) {
            return;
        }
        WireLink link = (WireLink)equipped.get(IEApiDataComponents.WIRE_LINK);
        BlockPos pos = link.cp().position();
        String s = I18n.get((String)"desc.immersiveengineering.info.attachedTo", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()});
        int col = WireType.ELECTRUM.getColour(null);
        if (equipped.getItem() instanceof IWireCoil && (d = (rtr = ClientUtils.mc().hitResult) instanceof BlockHitResult ? ((BlockHitResult)rtr).getBlockPos().distSqr((Vec3i)pos) : player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) > (double)((max = ((IWireCoil)equipped.getItem()).getWireType(equipped).getMaxLength()) * max)) {
            col = 0xDD3333;
        }
        graphics.drawCenteredString(ClientUtils.font(), s, scaledWidth / 2, scaledHeight - 20 - ItemOverlayUtils.leftHeight(), col);
    }

    private static void renderFluorescentTubeOverlay(GuiGraphics graphics, ItemStack equipped, int scaledWidth, int scaledHeight) {
        int color = FluorescentTubeItem.getRGBInt(equipped, 1.0f);
        String s = I18n.get((String)"desc.immersiveengineering.info.colour", (Object[])new Object[0]) + "#" + FontUtils.hexColorString(color);
        graphics.drawCenteredString(ClientUtils.font(), s, scaledWidth / 2, scaledHeight - 20 - ItemOverlayUtils.leftHeight(), FluorescentTubeItem.getRGBInt(equipped, 1.0f));
    }

    public static void renderRevolverOverlay(GuiGraphics graphics, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        NonNullList<ItemStack> bullets = ((IEItemInterfaces.IBulletContainer)equipped.getItem()).getBullets(equipped);
        if (bullets != null) {
            int bulletAmount = ((IEItemInterfaces.IBulletContainer)equipped.getItem()).getBulletCount(equipped);
            HumanoidArm side = ItemUtils.getLivingHand((LivingEntity)player, hand);
            boolean right = side == HumanoidArm.RIGHT;
            float dx = right ? (float)(scaledWidth - 32 - 48) : 48.0f;
            float dy = scaledHeight - 64;
            PoseStack transform = graphics.pose();
            transform.pushPose();
            transform.translate(dx, dy, 0.0f);
            transform.scale(0.5f, 0.5f, 1.0f);
            RevolverScreen.drawExternalGUI(bullets, bulletAmount, graphics);
            transform.popPose();
        }
    }

    public static void renderRailgunOverlay(GuiGraphics graphics, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        int duration = 72000 - (player.isUsingItem() && player.getUsedItemHand() == hand ? player.getUseItemRemainingTicks() : 0);
        int chargeTime = RailgunItem.getChargeTime(equipped);
        int chargeLevel = duration < 72000 ? Math.min(99, (int)((float)duration / (float)chargeTime * 100.0f)) : 0;
        float scale = 1.5f;
        boolean boundLeft = player.getMainArm() == HumanoidArm.RIGHT == (hand == InteractionHand.OFF_HAND);
        int dx = boundLeft ? 24 : scaledWidth - 24 - 64;
        int dy = scaledHeight - 16;
        PoseStack transform = graphics.pose();
        transform.pushPose();
        transform.translate((float)dx, (float)dy, 0.0f);
        graphics.blitSprite(IEApi.ieLoc("hud/railgun_base"), 0, -32, 64, 32);
        ItemStack ammo = RailgunItem.findAmmo(equipped, player);
        if (!ammo.isEmpty()) {
            GuiHelper.renderItemWithOverlayIntoGUI(graphics, ammo, 6, -22, player.level());
        }
        transform.translate(30.0, -27.5, 0.0);
        transform.scale(scale, scale, 1.0f);
        String chargeTxt = chargeLevel < 10 ? "0 " + chargeLevel : chargeLevel / 10 + " " + chargeLevel % 10;
        graphics.drawString(ClientUtils.font(), chargeTxt, 0, 0, -557004, true);
        transform.popPose();
    }

    public static void renderFluidTankOverlay(GuiGraphics graphics, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped, boolean renderFluidUse, BiConsumer<GuiGraphics, IFluidHandlerItem> additionalRender) {
        PoseStack transform = graphics.pose();
        float dx = scaledWidth - 16;
        float dy = scaledHeight;
        transform.pushPose();
        transform.translate(dx, dy, 0.0f);
        graphics.blitSprite(IEApi.ieLoc("hud/gauge_full_empty"), -24, -68, 31, 62);
        transform.translate(-23.0f, -37.0f, 0.0f);
        IFluidHandlerItem handler = (IFluidHandlerItem)equipped.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler != null) {
            int capacity = -1;
            if (handler.getTanks() > 0) {
                capacity = handler.getTankCapacity(0);
            }
            if (capacity > 0) {
                FluidStack fuel = handler.getFluidInTank(0);
                int amount = fuel.getAmount();
                if (renderFluidUse && player.isUsingItem() && player.getUsedItemHand() == hand) {
                    int use = player.getTicksUsingItem();
                    amount -= use * (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
                }
                float cap = capacity;
                float angle = 83.0f - (float)(166 * amount) / cap;
                transform.pushPose();
                transform.mulPose(new Quaternionf().rotateZ(angle * ((float)Math.PI / 180)));
                graphics.blitSprite(IEApi.ieLoc("hud/gauge_pointer"), 6, -2, 24, 4);
                transform.popPose();
                transform.translate(23.0f, 37.0f, 0.0f);
                additionalRender.accept(graphics, handler);
            }
        }
        transform.popPose();
    }

    public static void renderDrillOverlay(GuiGraphics graphics, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(graphics, scaledWidth, scaledHeight, player, hand, equipped, false, (builder, handler) -> {
            builder.blitSprite(IEApi.ieLoc("hud/gauge_with_item"), -54, -73, 66, 72);
            ItemStack head = ((DrillItem)equipped.getItem()).getHead(equipped);
            if (!head.isEmpty()) {
                GuiHelper.renderItemWithOverlayIntoGUI(graphics, head, -51, -45, player.level());
            }
        });
    }

    public static void renderBuzzsawOverlay(GuiGraphics graphics, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(graphics, scaledWidth, scaledHeight, player, hand, equipped, false, (builder, handler) -> {
            builder.blitSprite(IEApi.ieLoc("hud/gauge_with_item"), -54, -73, 66, 72);
            ItemStack blade = ((BuzzsawItem)equipped.getItem()).getHead(equipped);
            if (!blade.isEmpty()) {
                GuiHelper.renderItemWithOverlayIntoGUI(graphics, blade, -51, -45, player.level());
            }
        });
    }

    public static void renderChemthrowerOverlay(GuiGraphics graphics, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(graphics, scaledWidth, scaledHeight, player, hand, equipped, true, (builder, handler) -> {
            builder.blitSprite(IEApi.ieLoc("hud/gauge_no_item"), -41, -73, 53, 72);
            boolean ignite = ChemthrowerItem.isIgniteEnable(equipped);
            builder.blitSprite(IEApi.ieLoc(ignite ? "hud/with_flame" : "hud/no_flame"), -32, -43, 12, 12);
            builder.blitSprite(IEApi.ieLoc("hud/text_label"), -100, -20, 64, 16);
            FluidStack fuel = handler.getFluidInTank(0);
            if (!fuel.isEmpty()) {
                String name = ClientUtils.font().substrByWidth((FormattedText)fuel.getHoverName(), 50).getString().trim();
                int width = ClientUtils.font().width(name);
                graphics.drawString(ClientUtils.font(), name, -68 - width / 2, -15, 0x333333, false);
            }
        });
    }

    public static void renderShieldOverlay(GuiGraphics graphics, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        int h;
        Cooldown cooldown;
        UpgradeData upgrades = ((IEShieldItem)equipped.getItem()).getUpgrades(equipped);
        if (upgrades.entries().isEmpty()) {
            return;
        }
        boolean boundLeft = player.getMainArm() == HumanoidArm.RIGHT == (hand == InteractionHand.OFF_HAND);
        float dx = boundLeft ? 16.0f : (float)(scaledWidth - 16 - 64);
        float dy = scaledHeight;
        PoseStack transform = graphics.pose();
        transform.pushPose();
        transform.translate(dx, dy, 0.0f);
        graphics.blitSprite(IEApi.ieLoc("hud/shield_upgrades_base"), 0, -22, 64, 22);
        if (upgrades.has(UpgradeEffect.FLASH)) {
            graphics.blitSprite(IEApi.ieLoc("hud/shield_upgrade_flash"), 11, -38, 16, 16);
            cooldown = upgrades.get(UpgradeEffect.FLASH);
            if (cooldown.isOnCooldown()) {
                h = (int)((float)cooldown.remainingCooldown() / 40.0f * 16.0f);
                graphics.blitSprite(IEApi.ieLoc("hud/shield_flash_cooldown"), 16, 16, 0, 16 - h, 11, -22 - h, 16, h);
            }
        }
        if (upgrades.has(UpgradeEffect.SHOCK)) {
            graphics.blitSprite(IEApi.ieLoc("hud/shield_upgrade_shock"), 40, -38, 12, 16);
            cooldown = upgrades.get(UpgradeEffect.SHOCK);
            if (cooldown.isOnCooldown()) {
                h = (int)((float)cooldown.remainingCooldown() / 40.0f * 16.0f);
                graphics.blitSprite(IEApi.ieLoc("hud/shield_shock_cooldown"), 12, 16, 0, 16 - h, 40, -22 - h, 12, h);
            }
        }
        transform.popPose();
    }

    private static void renderVoltmeterOverlay(GuiGraphics graphics, Player player, int scaledWidth, int scaledHeight) {
        HitResult rrt = ClientUtils.mc().hitResult;
        Either pos = null;
        if (rrt instanceof BlockHitResult) {
            BlockHitResult mop = (BlockHitResult)rrt;
            pos = Either.left((Object)mop.getBlockPos());
        } else if (rrt instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)rrt;
            pos = Either.right((Object)ehr.getEntity().getId());
        }
        if (pos == null) {
            return;
        }
        ArrayList<Component> text = new ArrayList<Component>();
        boolean matches = VoltmeterItem.lastEnergyUpdate.pos().equals((Object)pos);
        long sinceLast = player.level().getGameTime() - VoltmeterItem.lastEnergyUpdate.measuredInTick();
        if (!matches || sinceLast > 20L) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageRequestEnergyUpdate((Either<BlockPos, Integer>)pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (VoltmeterItem.lastEnergyUpdate.isValid() && matches) {
            int maxStorage = VoltmeterItem.lastEnergyUpdate.capacity();
            int storage = VoltmeterItem.lastEnergyUpdate.stored();
            String storageText = Utils.toScientificNotation(storage, "0##", 100000);
            String capacityText = Utils.toScientificNotation(maxStorage, "0##", 100000);
            text.add((Component)Component.translatable((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{storageText + " / " + capacityText}));
        }
        if (rrt instanceof BlockHitResult) {
            BlockHitResult mop = (BlockHitResult)rrt;
            matches = VoltmeterItem.lastRedstoneUpdate.pos().equals((Object)mop.getBlockPos());
            sinceLast = player.level().getGameTime() - VoltmeterItem.lastRedstoneUpdate.measuredInTick();
            if (!matches || sinceLast > 20L) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageRequestRedstoneUpdate(mop.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (VoltmeterItem.lastRedstoneUpdate.isSignalSource() && matches) {
                VoltmeterItem.lastRedstoneUpdate.rsLevels().consume(aByte -> text.add((Component)Component.translatable((String)"desc.immersiveengineering.info.redstone_level", (Object[])new Object[]{String.valueOf(aByte)})), pairs -> {
                    if (((Pair[])pairs).length > 0) {
                        text.add((Component)Component.translatable((String)"desc.immersiveengineering.info.redstone_level", (Object[])new Object[]{""}));
                        for (Pair p : pairs) {
                            MutableComponent c = Component.translatable((String)"desc.immersiveengineering.info.redstone_level_on_channel", (Object[])new Object[]{p.getSecond(), Lib.getRedstoneColorComponent((DyeColor)p.getFirst())});
                            text.add((Byte)p.getSecond() < 10 ? new SpacerComponent("0").append((Component)c) : c);
                        }
                    }
                });
            }
        }
        BlockOverlayUtils.drawBlockOverlayText(graphics, text, scaledWidth, scaledHeight);
    }

    private static int leftHeight() {
        return Minecraft.getInstance().gui.leftHeight;
    }

    private static int rightHeight() {
        return Minecraft.getInstance().gui.rightHeight;
    }
}

