/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public abstract class IERecipeProvider
extends RecipeProvider {
    protected static final int standardSmeltingTime = 200;
    protected static final int blastDivider = 2;
    private final HashMap<String, Integer> pathCount = new HashMap();

    public IERecipeProvider(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> provider) {
        super(p_248933_, provider);
    }

    protected ResourceLocation toRL(String s) {
        if (!((String)s).contains("/")) {
            s = "crafting/" + (String)s;
        }
        if (this.pathCount.containsKey(s)) {
            int count = this.pathCount.get(s) + 1;
            this.pathCount.put((String)s, count);
            return IEApi.ieLoc((String)((String)s + count));
        }
        this.pathCount.put((String)s, 1);
        return IEApi.ieLoc((String)s);
    }

    protected void add3x3Conversion(ItemLike bigItem, ItemLike smallItem, TagKey<Item> smallTag, RecipeOutput out) {
        this.shapedMisc(bigItem).define(Character.valueOf('s'), smallTag).define(Character.valueOf('i'), smallItem).pattern("sss").pattern("sis").pattern("sss").unlockedBy("has_" + this.toPath(smallItem), IERecipeProvider.has((ItemLike)smallItem)).save(out, String.valueOf(this.toRL(this.toPath(smallItem) + "_to_")) + this.toPath(bigItem));
        this.shapelessMisc(smallItem, 9).requires(bigItem).unlockedBy("has_" + this.toPath(bigItem), IERecipeProvider.has((ItemLike)smallItem)).save(out, this.toRL(this.toPath(bigItem) + "_to_" + this.toPath(smallItem)));
    }

    protected ShapedRecipeBuilder shapedMisc(ItemLike output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output);
    }

    protected ShapedRecipeBuilder shapedMisc(ItemLike output, int count) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count);
    }

    protected ShapelessRecipeBuilder shapelessMisc(ItemLike output) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output);
    }

    protected ShapelessRecipeBuilder shapelessMisc(ItemLike output, int count) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count);
    }

    protected String toPath(ItemLike src) {
        return BuiltInRegistries.ITEM.getKey((Object)src.asItem()).getPath();
    }

    protected void addStandardSmeltingBlastingRecipe(ItemLike input, ItemLike output, float xp, int smeltingTime, RecipeOutput out, String extraPostfix) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xp, (int)smeltingTime).unlockedBy("has_" + this.toPath(input), IERecipeProvider.has((ItemLike)input)).save(out, this.toRL("smelting/" + this.toPath(output) + extraPostfix));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xp, (int)(smeltingTime / 2)).unlockedBy("has_" + this.toPath(input), IERecipeProvider.has((ItemLike)input)).save(out, this.toRL("smelting/" + this.toPath(output) + extraPostfix + "_from_blasting"));
    }

    @ParametersAreNonnullByDefault
    protected void addCornerStraightMiddle(ItemLike output, int count, Ingredient corner, Ingredient side, Ingredient middle, Criterion<?> condition, RecipeOutput out) {
        this.shapedMisc(output, count).define(Character.valueOf('c'), corner).define(Character.valueOf('s'), side).define(Character.valueOf('m'), middle).pattern("csc").pattern("sms").pattern("csc").unlockedBy("has_item", condition).save(out, this.toRL(this.toPath(output)));
    }

    @ParametersAreNonnullByDefault
    protected void addSandwich(ItemLike output, int count, Ingredient top, Ingredient middle, Ingredient bottom, Criterion<?> condition, RecipeOutput out) {
        this.shapedMisc(output, count).define(Character.valueOf('t'), top).define(Character.valueOf('m'), middle).define(Character.valueOf('b'), bottom).pattern("ttt").pattern("mmm").pattern("bbb").unlockedBy("has_item", condition).save(out, this.toRL(this.toPath(output)));
    }

    protected void addWall(ItemLike block, RecipeOutput out) {
        ItemLike wall = (ItemLike)IEBlocks.TO_WALL.get(BuiltInRegistries.ITEM.getKey((Object)block.asItem()));
        this.shapedMisc(wall, 6).define(Character.valueOf('s'), block).pattern("sss").pattern("sss").unlockedBy("has_" + this.toPath(block), IERecipeProvider.has((ItemLike)block)).save(out, this.toRL(this.toPath(wall)));
    }

    protected void addStonecuttingRecipe(ItemLike input, ItemLike output, RecipeOutput out) {
        this.addStonecuttingRecipe(input, output, 1, out);
    }

    protected void addStonecuttingRecipe(ItemLike input, ItemLike output, int amount, RecipeOutput out) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)amount).unlockedBy("has_" + this.toPath(input), IERecipeProvider.has((ItemLike)input)).save(out, this.toRL("stonecutting/" + this.toPath(output)));
    }

    protected void addStandardSmeltingBlastingRecipe(ItemLike input, ItemLike output, float xp, RecipeOutput out) {
        this.addStandardSmeltingBlastingRecipe(input, output, xp, out, "");
    }

    protected void addStandardSmeltingBlastingRecipe(ItemLike input, ItemLike output, float xp, RecipeOutput out, String extraPostfix) {
        this.addStandardSmeltingBlastingRecipe(input, output, xp, 200, out, extraPostfix);
    }

    public static ICondition getTagCondition(TagKey<?> tag) {
        return new NotCondition((ICondition)new TagEmptyCondition(tag.location()));
    }

    public static ICondition getTagCondition(ResourceLocation tag) {
        return IERecipeProvider.getTagCondition(TagUtils.createItemWrapper((ResourceLocation)tag));
    }

    @Nonnull
    protected Ingredient makeIngredient(ItemLike in) {
        return Ingredient.of((ItemLike[])new ItemLike[]{in});
    }

    @Nonnull
    protected Ingredient makeIngredient(TagKey<Item> in) {
        return Ingredient.of(in);
    }
}

