/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.fluids.ConcreteFluid;
import blusunrize.immersiveengineering.common.fluids.IEFluid;
import blusunrize.immersiveengineering.common.fluids.IEFluidBlock;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class IEFluids {
    public static final DeferredRegister<Fluid> REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"immersiveengineering");
    public static final DeferredRegister<FluidType> TYPE_REGISTER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"immersiveengineering");
    public static final List<FluidEntry> ALL_ENTRIES = new ArrayList<FluidEntry>();
    public static final Set<IEBlocks.BlockEntry<? extends LiquidBlock>> ALL_FLUID_BLOCKS = new HashSet<IEBlocks.BlockEntry<? extends LiquidBlock>>();
    public static final FluidEntry CREOSOTE = FluidEntry.make("creosote", 800, ImmersiveEngineering.rl("block/fluid/creosote_still"), ImmersiveEngineering.rl("block/fluid/creosote_flow"), IEFluid.createBuilder(1230, 2000));
    public static final FluidEntry PLANTOIL = FluidEntry.make("plantoil", ImmersiveEngineering.rl("block/fluid/plantoil_still"), ImmersiveEngineering.rl("block/fluid/plantoil_flow"), IEFluid.createBuilder(920, 1000));
    public static final FluidEntry ETHANOL = FluidEntry.make("ethanol", ImmersiveEngineering.rl("block/fluid/ethanol_still"), ImmersiveEngineering.rl("block/fluid/ethanol_flow"), IEFluid.createBuilder(790, 1000));
    public static final FluidEntry BIODIESEL = FluidEntry.make("biodiesel", ImmersiveEngineering.rl("block/fluid/biodiesel_still"), ImmersiveEngineering.rl("block/fluid/biodiesel_flow"), IEFluid.createBuilder(880, 1000));
    public static final FluidEntry HIGH_POWER_BIODIESEL = FluidEntry.make("high_power_biodiesel", ImmersiveEngineering.rl("block/fluid/biodiesel_still"), ImmersiveEngineering.rl("block/fluid/biodiesel_flow"), IEFluid.createBuilder(910, 1000));
    public static final FluidEntry CONCRETE = FluidEntry.make("concrete", ImmersiveEngineering.rl("block/fluid/concrete_still"), ImmersiveEngineering.rl("block/fluid/concrete_flow"), ConcreteFluid::new, ConcreteFluid.Flowing::new, IEFluid.createBuilder(2400, 4000), ImmutableList.of((Object)IEProperties.INT_32));
    public static final FluidEntry HERBICIDE = FluidEntry.make("herbicide", ImmersiveEngineering.rl("block/fluid/herbicide_still"), ImmersiveEngineering.rl("block/fluid/herbicide_flow"), IEFluid.createBuilder(1100, 1000));
    public static final FluidEntry REDSTONE_ACID = FluidEntry.make("redstone_acid", ImmersiveEngineering.rl("block/fluid/redstone_acid_still"), ImmersiveEngineering.rl("block/fluid/redstone_acid_flow"), IEFluid.createBuilder(1200, 1000));
    public static final Holder<FluidType> POTION_TYPE = TYPE_REGISTER.register("potion", PotionFluid.PotionFluidType::new);
    public static final DeferredHolder<Fluid, PotionFluid> POTION = REGISTER.register("potion", PotionFluid::new);
    public static final FluidEntry ACETALDEHYDE = FluidEntry.make("acetaldehyde", ImmersiveEngineering.rl("block/fluid/acetaldehyde_still"), ImmersiveEngineering.rl("block/fluid/acetaldehyde_flow"), IEFluid.createBuilder(788, 210));
    public static final FluidEntry PHENOLIC_RESIN = FluidEntry.make("phenolic_resin", ImmersiveEngineering.rl("block/fluid/resin_still"), ImmersiveEngineering.rl("block/fluid/resin_flow"), IEFluid.createBuilder(1100, 2800));

    public static void registerBucketCapabilities(RegisterCapabilitiesEvent event) {
        for (FluidEntry entry : ALL_ENTRIES) {
            event.registerItem(Capabilities.FluidHandler.ITEM, (stack, $) -> new FluidBucketWrapper(stack), new ItemLike[]{(ItemLike)entry.bucket.get()});
        }
    }

    public record FluidEntry(DeferredHolder<Fluid, IEFluid> flowing, ResourceLocation flowingTexture, DeferredHolder<Fluid, IEFluid> still, ResourceLocation stillTexture, IEBlocks.BlockEntry<IEFluidBlock> block, DeferredHolder<Item, BucketItem> bucket, Holder<FluidType> type, List<Property<?>> properties) {
        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex) {
            return FluidEntry.make(name, 0, stillTex, flowingTex);
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex, Consumer<FluidType.Properties> buildAttributes) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, buildAttributes);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex) {
            return FluidEntry.make(name, burnTime, stillTex, flowingTex, null);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidType.Properties> buildAttributes) {
            return FluidEntry.make(name, burnTime, stillTex, flowingTex, IEFluid::new, IEFluid.Flowing::new, buildAttributes, ImmutableList.of());
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex, Function<FluidEntry, ? extends IEFluid> makeStill, Function<FluidEntry, ? extends IEFluid> makeFlowing, @Nullable Consumer<FluidType.Properties> buildAttributes, ImmutableList<Property<?>> properties) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, makeStill, makeFlowing, buildAttributes, properties);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, Function<FluidEntry, ? extends IEFluid> makeStill, Function<FluidEntry, ? extends IEFluid> makeFlowing, @Nullable Consumer<FluidType.Properties> buildAttributes, List<Property<?>> properties) {
            FluidType.Properties builder = FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY);
            if (buildAttributes != null) {
                buildAttributes.accept(builder);
            }
            DeferredHolder type = TYPE_REGISTER.register(name, () -> new FluidType(builder));
            MutableObject thisMutable = new MutableObject();
            DeferredHolder still = REGISTER.register(name, () -> FluidEntry.lambda$make$1(makeStill, (Mutable)thisMutable));
            DeferredHolder flowing = REGISTER.register(name + "_flowing", () -> FluidEntry.lambda$make$2(makeFlowing, (Mutable)thisMutable));
            IEBlocks.BlockEntry<IEFluidBlock> block = new IEBlocks.BlockEntry<IEFluidBlock>(name + "_fluid_block", () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER), arg_0 -> FluidEntry.lambda$make$4((Mutable)thisMutable, arg_0));
            DeferredHolder bucket = IEItems.REGISTER.register(name + "_bucket", () -> FluidEntry.makeBucket((Supplier<IEFluid>)still, burnTime));
            FluidEntry entry = new FluidEntry((DeferredHolder<Fluid, IEFluid>)flowing, flowingTex, (DeferredHolder<Fluid, IEFluid>)still, stillTex, block, (DeferredHolder<Item, BucketItem>)bucket, (Holder<FluidType>)type, properties);
            thisMutable.setValue((Object)entry);
            ALL_FLUID_BLOCKS.add(block);
            ALL_ENTRIES.add(entry);
            return entry;
        }

        public IEFluid getFlowing() {
            return (IEFluid)((Object)this.flowing.value());
        }

        public IEFluid getStill() {
            return (IEFluid)((Object)this.still.value());
        }

        public IEFluidBlock getBlock() {
            return this.block.get();
        }

        public BucketItem getBucket() {
            return (BucketItem)this.bucket.value();
        }

        private static BucketItem makeBucket(Supplier<IEFluid> still, final int burnTime) {
            return new BucketItem((Fluid)still.get(), new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)){

                public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
                    return burnTime;
                }
            };
        }

        public DeferredHolder<Fluid, IEFluid> getStillGetter() {
            return this.still;
        }

        private static /* synthetic */ IEFluidBlock lambda$make$4(Mutable thisMutable, BlockBehaviour.Properties p) {
            return new IEFluidBlock((FluidEntry)thisMutable.getValue(), p);
        }

        private static /* synthetic */ IEFluid lambda$make$2(Function makeFlowing, Mutable thisMutable) {
            return IEFluid.makeFluid(makeFlowing, (FluidEntry)thisMutable.getValue());
        }

        private static /* synthetic */ IEFluid lambda$make$1(Function makeStill, Mutable thisMutable) {
            return IEFluid.makeFluid(makeStill, (FluidEntry)thisMutable.getValue());
        }
    }
}

