/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items.upgrades;

import blusunrize.immersiveengineering.api.tool.upgrade.IUpgrade;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.upgrades.ToolUpgrade;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ToolUpgradeItem
extends IEBaseItem
implements IUpgrade {
    private final ToolUpgrade type;

    public ToolUpgradeItem(ToolUpgrade type) {
        super(new Item.Properties().stacksTo(1));
        this.type = type;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)("desc.immersiveengineering.flavour." + BuiltInRegistries.ITEM.getKey((Object)this).getPath())).withStyle(ChatFormatting.GRAY));
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.type.stackSize;
    }

    @Override
    public Set<String> getUpgradeTypes(ItemStack upgrade) {
        return this.type.toolset;
    }

    @Override
    public boolean canApplyUpgrades(UpgradeData target, ItemStack upgrade) {
        BiPredicate<ItemStack, UpgradeData> check = this.type.applyCheck;
        if (check != null) {
            return check.test(upgrade, target);
        }
        return true;
    }

    @Override
    public UpgradeData applyUpgrades(UpgradeData base, ItemStack upgrade) {
        return this.type.function.apply(upgrade, base);
    }
}

