/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import blusunrize.immersiveengineering.client.render.tooltip.RevolverServerTooltip;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.network.MessageSpeedloaderSync;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.network.PacketDistributor;

public class RevolverItem
extends UpgradeableToolItem
implements IEItemInterfaces.IBulletContainer,
ZoomHandler.IZoomTool {
    public static final String TYPE = "REVOLVER";
    public static final ResourceLocation speedModUUID = IEApi.ieLoc("speed_modifier");
    public static final ResourceLocation luckModUUID = IEApi.ieLoc("luck_modifier");
    float[] zoomSteps = new float[]{0.3125f, 0.4f, 0.5f, 0.625f};
    public static final Multimap<String, SpecialRevolver> specialRevolvers = ArrayListMultimap.create();
    public static final Map<String, SpecialRevolver> specialRevolversByTag = new HashMap<String, SpecialRevolver>();

    public RevolverItem() {
        super(new Item.Properties().stacksTo(1).component(IEDataComponents.REVOLVER_PERKS, (Object)Perks.EMPTY).component(IEDataComponents.REVOLVER_ELITE, (Object)"").component(IEDataComponents.REVOLVER_COOLDOWN, (Object)RevolverCooldowns.DEFAULT), TYPE, 21);
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        registrar.register(CapabilityShader.ITEM, stack -> new CapabilityShader.ShaderWrapper_Item(IEApi.ieLoc("revolver"), (ItemStack)stack));
        InternalStorageItem.registerCapabilitiesISI(registrar);
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 18, 80, 32, TYPE, stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 19, 100, 32, TYPE, stack, true, level, getPlayer)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (inv != null && !inv.getStackInSlot(18).isEmpty() && !inv.getStackInSlot(19).isEmpty()) {
            Utils.unlockIEAdvancement(player, "tools/upgrade_revolver");
        }
    }

    @Nonnull
    public String getDescriptionId(@Nonnull ItemStack stack) {
        String tag = this.getRevolverDisplayTag(stack);
        if (!tag.isEmpty()) {
            return this.getDescriptionId() + "." + tag;
        }
        return super.getDescriptionId(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        String tag = this.getRevolverDisplayTag(stack);
        if (!tag.isEmpty()) {
            list.add((Component)Component.translatable((String)("desc.immersiveengineering.flavour.revolver." + tag)).withStyle(ChatFormatting.GRAY));
        } else if (stack.has(IEDataComponents.REVOLVER_FLAVOUR)) {
            list.add((Component)Component.translatable((String)("desc.immersiveengineering.flavour.revolver." + (String)stack.get(IEDataComponents.REVOLVER_FLAVOUR))).withStyle(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.revolver").withStyle(ChatFormatting.GRAY));
        }
        for (Map.Entry<RevolverPerk, Double> entry : RevolverItem.getPerks(stack).perks().entrySet()) {
            list.add((Component)Component.literal((String)"  ").append(entry.getKey().getDisplayString(entry.getValue())));
        }
    }

    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack pStack) {
        return Optional.of(new RevolverServerTooltip(this.getBullets(pStack), this.getBulletCount(pStack)));
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        double luck;
        double speed;
        UpgradeData upgrades;
        double melee;
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        if (this.getUpgrades(stack).has(UpgradeEffect.FANCY_ANIMATION)) {
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        if ((melee = (double)(upgrades = RevolverItem.getUpgradesStatic(stack)).get(UpgradeEffect.MELEE).floatValue()) != 0.0) {
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, melee, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        if ((speed = (double)upgrades.get(UpgradeEffect.SPEED).floatValue()) != 0.0) {
            builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(speedModUUID, speed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.HAND);
        }
        if ((luck = (double)upgrades.get(UpgradeEffect.LUCK).floatValue()) != 0.0) {
            builder.add(Attributes.LUCK, new AttributeModifier(luckModUUID, luck, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND);
        }
        return builder.build();
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity ent, int slot, boolean inHand) {
        super.inventoryTick(stack, world, ent, slot, inHand);
        RevolverCooldowns cooldowns = RevolverItem.getCooldowns(stack);
        if (cooldowns.reloadTimer > 0 || cooldowns.fireCooldown > 0) {
            stack.set(IEDataComponents.REVOLVER_COOLDOWN, (Object)new RevolverCooldowns(Math.max(cooldowns.reloadTimer - 1, 0), Math.max(cooldowns.fireCooldown - 1, 0)));
        }
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack revolver = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.openGui(player, hand);
            return InteractionResultHolder.sidedSuccess((Object)revolver, (boolean)world.isClientSide());
        }
        if (player.getAttackStrengthScale(1.0f) < 1.0f) {
            return InteractionResultHolder.pass((Object)revolver);
        }
        if (this.getUpgrades(revolver).has(UpgradeEffect.NERF)) {
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.6f);
            return InteractionResultHolder.sidedSuccess((Object)revolver, (boolean)world.isClientSide());
        }
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.pass((Object)revolver);
        }
        NonNullList<ItemStack> bullets = this.getBullets(revolver);
        if (bullets.stream().noneMatch(stack -> stack.getItem() instanceof BulletItem) && this.useSpeedloader(world, player, revolver, hand, bullets)) {
            return InteractionResultHolder.sidedSuccess((Object)revolver, (boolean)world.isClientSide());
        }
        ItemStack bulletStack = (ItemStack)bullets.get(0);
        Item bullet0 = bulletStack.getItem();
        if (bullet0 instanceof BulletItem) {
            BulletHandler.IBullet<?> bullet = ((BulletItem)bullet0).getType();
            if (bullet != null) {
                if (!world.isClientSide()) {
                    ShaderRegistry.ShaderAndCase shader;
                    float noise = RevolverItem.fireProjectile(world, (LivingEntity)player, revolver, bullet, bulletStack);
                    bullets.set(0, (Object)bullet.getCasing((ItemStack)bullets.get(0)).copy());
                    Utils.attractEnemies((LivingEntity)player, 64.0f * noise);
                    if (noise > 0.2f) {
                        Holder.Reference eventTriggered = (double)noise > 0.5 ? GameEvent.EXPLODE : GameEvent.PROJECTILE_SHOOT;
                        player.gameEvent((Holder)eventTriggered);
                    }
                    if ((shader = ShaderRegistry.getStoredShaderAndCase(revolver)) != null) {
                        Vec3 pos = Utils.getLivingFrontPos((LivingEntity)player, 0.75, (double)player.getBbHeight() * 0.75, ItemUtils.getLivingHand((LivingEntity)player, hand), false, 1.0f);
                        shader.registryEntry().getEffectFunction().execute(world, revolver, shader.sCase().getShaderType().toString(), pos, Vec3.directionFromRotation((Vec2)player.getRotationVector()), 0.125f);
                    }
                }
            } else {
                world.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            world.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.rotateCylinder(revolver, player, true, bullets);
        player.getCooldowns().addCooldown((Item)this, this.getMaxShootCooldown(revolver));
        return InteractionResultHolder.sidedSuccess((Object)revolver, (boolean)world.isClientSide());
    }

    public boolean useSpeedloader(Level level, Player player, ItemStack revolver, InteractionHand hand, NonNullList<ItemStack> bullets) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            SpeedloaderItem speedloader;
            ItemStack stack = player.getInventory().getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof SpeedloaderItem) || (speedloader = (SpeedloaderItem)item).isEmpty(stack)) continue;
            if (!level.isClientSide()) {
                for (ItemStack b : bullets) {
                    if (b.isEmpty()) continue;
                    level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), b));
                }
                NonNullList<ItemStack> bulletList = speedloader.getBullets(stack);
                this.setBullets(revolver, bulletList, true);
                ((SpeedloaderItem)stack.getItem()).setContainedItems(stack, (NonNullList<ItemStack>)NonNullList.withSize((int)8, (Object)ItemStack.EMPTY));
                player.getInventory().setChanged();
                if (player instanceof ServerPlayer) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new MessageSpeedloaderSync(i, hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            RevolverCooldowns oldCooldowns = RevolverItem.getCooldowns(revolver);
            revolver.set(IEDataComponents.REVOLVER_COOLDOWN, (Object)new RevolverCooldowns(60, oldCooldowns.fireCooldown));
            player.getCooldowns().addCooldown((Item)this, 60);
            return true;
        }
        return false;
    }

    public static float fireProjectile(Level world, LivingEntity shooter, ItemStack revolver, BulletHandler.IBullet bullet, ItemStack bulletStack) {
        Player p;
        Player player = shooter instanceof Player ? (p = (Player)shooter) : null;
        Vec3 vec = shooter.getLookAngle();
        boolean electro = RevolverItem.getUpgradesStatic(revolver).has(UpgradeEffect.ELECTRO);
        int count = bullet.getProjectileCount(player);
        if (count == 1) {
            shooter.level().addFreshEntity(RevolverItem.getBullet(shooter, player, vec, bulletStack, electro));
        } else {
            for (int i = 0; i < count; ++i) {
                Vec3 vecDir = vec.add(shooter.getRandom().nextGaussian() * 0.1, shooter.getRandom().nextGaussian() * 0.1, shooter.getRandom().nextGaussian() * 0.1);
                shooter.level().addFreshEntity(RevolverItem.getBullet(shooter, player, vecDir, bulletStack, electro));
            }
        }
        UpgradeData upgrades = RevolverItem.getUpgradesStatic(revolver);
        float noise = upgrades.get(UpgradeEffect.NOISE).floatValue() / 2.0f;
        SoundEvent sound = bullet.getSound();
        if (sound == null) {
            sound = (SoundEvent)IESounds.revolverFire.value();
        }
        world.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), sound, SoundSource.PLAYERS, noise, 1.0f);
        return noise;
    }

    public int getMaxShootCooldown(ItemStack stack) {
        return (int)Math.ceil(15.0f * RevolverItem.getUpgradesStatic(stack).get(UpgradeEffect.COOLDOWN).floatValue());
    }

    @Override
    public int getBulletCount(ItemStack revolver) {
        return 8 + this.getUpgrades(revolver).get(UpgradeEffect.BULLETS);
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver) {
        return ListUtils.fromStream(RevolverItem.getContainedItems(revolver).stream(), this.getBulletCount(revolver));
    }

    private static Entity getBullet(LivingEntity living, @Nullable Player player, Vec3 vecDir, ItemStack bulletStack, boolean electro) {
        return ((BulletItem)bulletStack.getItem()).createBullet(living.level(), player, living.getEyePosition(), vecDir, bulletStack, electro);
    }

    public void setBullets(ItemStack revolver, NonNullList<ItemStack> bullets, boolean ignoreExtendedMag) {
        int i;
        IItemHandlerModifiable inv = (IItemHandlerModifiable)revolver.getCapability(Capabilities.ItemHandler.ITEM);
        for (i = 0; i < 18; ++i) {
            inv.setStackInSlot(i, ItemStack.EMPTY);
        }
        if (ignoreExtendedMag && this.getUpgrades(revolver).get(UpgradeEffect.BULLETS) > 0) {
            for (i = 0; i < bullets.size(); ++i) {
                inv.setStackInSlot(i < 2 ? i : i + this.getUpgrades(revolver).get(UpgradeEffect.BULLETS), (ItemStack)bullets.get(i));
            }
        } else {
            for (i = 0; i < bullets.size(); ++i) {
                inv.setStackInSlot(i, (ItemStack)bullets.get(i));
            }
        }
    }

    public void rotateCylinder(ItemStack revolver, Player player, boolean forward, NonNullList<ItemStack> bullets) {
        NonNullList cycled = NonNullList.withSize((int)this.getBulletCount(revolver), (Object)ItemStack.EMPTY);
        int offset = forward ? -1 : 1;
        for (int i = 0; i < cycled.size(); ++i) {
            cycled.set((i + offset + cycled.size()) % cycled.size(), (Object)((ItemStack)bullets.get(i)));
        }
        this.setBullets(revolver, (NonNullList<ItemStack>)cycled, false);
        player.getInventory().setChanged();
    }

    public void rotateCylinder(ItemStack revolver, Player player, boolean forward) {
        NonNullList<ItemStack> bullets = this.getBullets(revolver);
        this.rotateCylinder(revolver, player, forward, bullets);
    }

    @Override
    public UpgradeData getUpgradeBase(ItemStack stack) {
        return (UpgradeData)stack.getOrDefault(IEDataComponents.BASE_UPGRADES, (Object)UpgradeData.EMPTY);
    }

    public String getRevolverDisplayTag(ItemStack revolver) {
        String tag = (String)revolver.get(IEDataComponents.REVOLVER_ELITE);
        if (!tag.isEmpty()) {
            int split = tag.lastIndexOf("_");
            if (split < 0) {
                split = tag.length();
            }
            return tag.substring(0, split);
        }
        return "";
    }

    public static Perks getPerks(ItemStack stack) {
        return (Perks)stack.getOrDefault(IEDataComponents.REVOLVER_PERKS, (Object)Perks.EMPTY);
    }

    @Override
    public boolean canZoom(ItemStack stack, Player player) {
        return RevolverItem.getUpgradesStatic(stack).has(UpgradeEffect.SCOPE);
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, Player player) {
        return this.zoomSteps;
    }

    public void onCraftedBy(ItemStack stack, @Nonnull Level world, @Nonnull Player player) {
        ArrayList list;
        if (stack.isEmpty() || player == null) {
            return;
        }
        String uuid = player.getUUID().toString();
        if (specialRevolvers.containsKey((Object)uuid) && !(list = new ArrayList(specialRevolvers.get((Object)uuid))).isEmpty()) {
            list.add(null);
            String existingTag = (String)stack.get(IEDataComponents.REVOLVER_ELITE);
            if (existingTag.isEmpty()) {
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(0));
            } else {
                int i;
                for (i = 0; !(i >= list.size() || list.get(i) != null && existingTag.equals(((SpecialRevolver)list.get((int)i)).tag)); ++i) {
                }
                int next = (i + 1) % list.size();
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(next));
            }
        }
        this.recalculateUpgrades(stack, world, player);
    }

    public void applySpecialCrafting(ItemStack stack, SpecialRevolver r) {
        if (r == null) {
            stack.set(IEDataComponents.REVOLVER_ELITE, (Object)"");
            stack.remove(IEDataComponents.REVOLVER_FLAVOUR);
            stack.remove(IEDataComponents.UPGRADE_DATA);
            return;
        }
        if (r.tag != null && !r.tag.isEmpty()) {
            stack.set(IEDataComponents.REVOLVER_ELITE, (Object)r.tag);
        }
        if (r.flavour != null && !r.flavour.isEmpty()) {
            stack.set(IEDataComponents.REVOLVER_FLAVOUR, (Object)r.flavour);
        }
        stack.set(IEDataComponents.BASE_UPGRADES, (Object)r.baseUpgrades);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || CapabilityShader.shouldReequipDueToShader(oldStack, newStack);
    }

    @Override
    @Nullable
    protected IEMenuTypes.ItemContainerType<?> getContainerType() {
        return IEMenuTypes.REVOLVER;
    }

    public static RevolverCooldowns getCooldowns(ItemStack revolver) {
        return (RevolverCooldowns)revolver.getOrDefault(IEDataComponents.REVOLVER_COOLDOWN, (Object)RevolverCooldowns.DEFAULT);
    }

    public record Perks(Map<RevolverPerk, Double> perks) {
        public static final DualCodec<ByteBuf, Perks> CODECS = IEDualCodecs.forMap(IEDualCodecs.forEnum((Enum[])RevolverPerk.values()), DualCodecs.DOUBLE).map(Perks::new, Perks::perks);
        public static final Perks EMPTY = new Perks(new EnumMap<RevolverPerk, Double>(RevolverPerk.class));
    }

    public record RevolverCooldowns(int reloadTimer, int fireCooldown) {
        public static final DualCodec<ByteBuf, RevolverCooldowns> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.INT.fieldOf("reloadTimer"), RevolverCooldowns::reloadTimer, (DualMapCodec)DualCodecs.INT.fieldOf("fireCooldown"), RevolverCooldowns::fireCooldown, RevolverCooldowns::new);
        public static final RevolverCooldowns DEFAULT = new RevolverCooldowns(0, 0);
    }

    @ParametersAreNonnullByDefault
    public static enum RevolverPerk {
        COOLDOWN(f -> f > 1.0, f -> Utils.NUMBERFORMAT_PREFIXED.format((1.0 - f) * 100.0), (l, r) -> l * r, 1.0, -0.75, -0.05),
        NOISE(f -> f > 1.0, f -> Utils.NUMBERFORMAT_PREFIXED.format((f - 1.0) * 100.0), (l, r) -> l * r, 1.0, -0.9, -0.1),
        LUCK(f -> f < 0.0, f -> Utils.NUMBERFORMAT_PREFIXED.format(f * 100.0), (l, r) -> l + r, 0.0, 3.0, 0.5);

        private final DoublePredicate isBadValue;
        private final Function<Double, String> valueFormatter;
        private final DoubleBinaryOperator valueConcat;
        private final double generate_median;
        private final double generate_deviation;
        private final double generate_luckScale;

        private RevolverPerk(DoublePredicate isBadValue, Function<Double, String> valueFormatter, DoubleBinaryOperator valueConcat, double generate_median, double generate_deviation, double generate_luckScale) {
            this.isBadValue = isBadValue;
            this.valueFormatter = valueFormatter;
            this.valueConcat = valueConcat;
            this.generate_median = generate_median;
            this.generate_deviation = generate_deviation;
            this.generate_luckScale = generate_luckScale;
        }

        public String getNBTKey() {
            return this.name().toLowerCase(Locale.US);
        }

        public Component getDisplayString(double value) {
            String key = "desc.immersiveengineering.info.revolver.perk." + this.toString();
            return Component.translatable((String)key, (Object[])new Object[]{this.valueFormatter.apply(value)}).withStyle(this.isBadValue.test(value) ? ChatFormatting.RED : ChatFormatting.BLUE);
        }

        public static Component getFormattedName(Component name, Perks perks) {
            double averageTier = 0.0;
            for (Map.Entry<RevolverPerk, Double> entry : perks.perks.entrySet()) {
                RevolverPerk perk = entry.getKey();
                double value = entry.getValue();
                double dTier = (value - perk.generate_median) / perk.generate_deviation * 3.0;
                averageTier += dTier;
                int iTier = (int)Mth.clamp((double)(dTier < 0.0 ? Math.floor(dTier) : Math.ceil(dTier)), (double)-3.0, (double)3.0);
                if (iTier == 0) {
                    iTier = 1;
                }
                String translate = "desc.immersiveengineering.info.revolver.perk." + perk.name().toLowerCase(Locale.US) + ".tier" + iTier;
                name = Component.translatable((String)translate, (Object[])new Object[]{name});
            }
            int rarityTier = (int)Math.ceil(Mth.clamp((double)(averageTier + 3.0), (double)0.0, (double)6.0) / 6.0 * 5.0);
            Rarity rarity = switch (rarityTier) {
                case 5 -> (Rarity)Lib.RARITY_MASTERWORK.getValue();
                case 4 -> Rarity.EPIC;
                case 3 -> Rarity.RARE;
                case 2 -> Rarity.UNCOMMON;
                default -> Rarity.COMMON;
            };
            return name.copy().withStyle(rarity.color());
        }

        public static int calculateTier(Perks perks) {
            double averageTier = 0.0;
            for (Map.Entry<RevolverPerk, Double> entry : perks.perks.entrySet()) {
                RevolverPerk perk = entry.getKey();
                double value = entry.getValue();
                double dTier = (value - perk.generate_median) / perk.generate_deviation * 3.0;
                averageTier += dTier;
            }
            return (int)Math.ceil(Mth.clamp((double)(averageTier + 3.0), (double)0.0, (double)6.0) / 6.0 * 5.0);
        }

        public double concat(double left, double right) {
            return this.valueConcat.applyAsDouble(left, right);
        }

        public double generateValue(RandomSource rand, boolean isBad, float luck) {
            double d = Utils.generateLuckInfluencedDouble(this.generate_median, this.generate_deviation, luck, rand, isBad, this.generate_luckScale);
            int i = (int)(d * 100.0);
            d = (double)i / 100.0;
            return d;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }

        public static RevolverPerk get(String name) {
            try {
                return RevolverPerk.valueOf(name.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                return null;
            }
        }

        public static RevolverPerk getRandom(RandomSource rand) {
            int i = rand.nextInt(RevolverPerk.values().length);
            return RevolverPerk.values()[i];
        }

        public static Perks generatePerkSet(RandomSource rand, float luck) {
            RevolverPerk goodPerk = RevolverPerk.getRandom(rand);
            RevolverPerk badPerk = LUCK;
            double val = goodPerk.generateValue(rand, false, luck);
            EnumMap<RevolverPerk, Double> perks = new EnumMap<RevolverPerk, Double>(RevolverPerk.class);
            if (goodPerk == badPerk) {
                val = (val + badPerk.generateValue(rand, true, luck)) / 2.0;
            } else {
                perks.put(badPerk, badPerk.generateValue(rand, true, luck));
            }
            perks.put(goodPerk, val);
            return new Perks(perks);
        }
    }

    public record SpecialRevolver(List<String> uuid, String tag, String flavour, UpgradeData baseUpgrades, List<String> renderAdditions) {
        public static final DualCodec<ByteBuf, SpecialRevolver> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.STRING.listOf().fieldOf("uuid"), SpecialRevolver::uuid, (DualMapCodec)DualCodecs.STRING.fieldOf("tag"), SpecialRevolver::tag, (DualMapCodec)DualCodecs.STRING.fieldOf("flavour"), SpecialRevolver::flavour, (DualMapCodec)UpgradeData.SPECIAL_REVOLVER_CODEC.fieldOf("baseUpgrades"), SpecialRevolver::baseUpgrades, (DualMapCodec)DualCodecs.STRING.listOf().fieldOf("renderAdditions"), SpecialRevolver::renderAdditions, SpecialRevolver::new);
    }
}

